/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution.sampler.plugins.dataprof;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerMeta;
import org.apache.hop.execution.sampler.ExecutionDataSamplerStoreBase;
import org.apache.hop.execution.sampler.IExecutionDataSamplerStore;
import org.apache.hop.execution.sampler.plugins.dataprof.BasicDataProfilingDataSampler;
import org.apache.hop.i18n.BaseMessages;

public class BasicDataProfilingDataSamplerStore
extends ExecutionDataSamplerStoreBase<BasicDataProfilingDataSamplerStore>
implements IExecutionDataSamplerStore {
    private static final Class<?> PKG = BasicDataProfilingDataSampler.class;
    protected BasicDataProfilingDataSampler dataSampler;
    protected Map<String, Object> minValues;
    protected Map<String, IValueMeta> minMeta;
    protected Map<String, Object> maxValues;
    protected Map<String, IValueMeta> maxMeta;
    protected Map<String, Long> nullCounters;
    protected Map<String, Long> nonNullCounters;
    protected Map<String, Integer> minLengths;
    protected Map<String, Integer> maxLengths;
    protected Map<String, Map<BasicDataProfilingDataSampler.ProfilingType, RowBuffer>> profileSamples;

    public BasicDataProfilingDataSamplerStore(BasicDataProfilingDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta, IRowMeta rowMeta, List<Object[]> rows, int maxRows) {
        super(samplerMeta, rowMeta, rows, maxRows);
        this.dataSampler = dataSampler;
        this.profileSamples = Collections.synchronizedMap(new HashMap());
        this.minValues = Collections.synchronizedMap(new HashMap());
        this.minMeta = Collections.synchronizedMap(new HashMap());
        this.maxValues = Collections.synchronizedMap(new HashMap());
        this.maxMeta = Collections.synchronizedMap(new HashMap());
        this.nullCounters = Collections.synchronizedMap(new HashMap());
        this.nonNullCounters = Collections.synchronizedMap(new HashMap());
        this.minLengths = Collections.synchronizedMap(new HashMap());
        this.maxLengths = Collections.synchronizedMap(new HashMap());
    }

    @Override
    public BasicDataProfilingDataSamplerStore getStore() {
        return this;
    }

    public BasicDataProfilingDataSamplerStore(BasicDataProfilingDataSampler dataSampler, ExecutionDataSamplerMeta samplerMeta) {
        this(dataSampler, samplerMeta, null, null, 0);
    }

    @Override
    public void init(IVariables variables, IRowMeta inputRowMeta, IRowMeta outputRowMeta) {
        this.setMaxRows(Const.toInt((String)variables.resolve(this.dataSampler.getSampleSize()), (int)0));
    }

    @Override
    public Map<String, RowBuffer> getSamples() {
        Map<String, RowBuffer> samples = Collections.synchronizedMap(new HashMap());
        String transformName = this.samplerMeta.getTransformName();
        String copyNr = this.samplerMeta.getCopyNr();
        this.getMinValues().forEach((fieldName, value) -> samples.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinValue), this.createRowBuffer((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinValue, this.getMinMeta().get(fieldName), value)));
        this.getMaxValues().forEach((fieldName, value) -> samples.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxValue), this.createRowBuffer((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxValue, this.getMaxMeta().get(fieldName), value)));
        this.getMinLengths().forEach((fieldName, value) -> samples.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinLength), this.createRowBuffer((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinLength, (IValueMeta)new ValueMetaInteger(fieldName), value)));
        this.getMaxLengths().forEach((fieldName, value) -> samples.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxLength), this.createRowBuffer((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxLength, (IValueMeta)new ValueMetaInteger(fieldName), value)));
        if (this.dataSampler.isProfilingNrNull()) {
            this.getNullCounters().forEach((fieldName, value) -> samples.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNulls), this.createRowBuffer((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNulls, (IValueMeta)new ValueMetaInteger(fieldName), value)));
        }
        if (this.dataSampler.isProfilingNrNonNull()) {
            this.getNonNullCounters().forEach((fieldName, value) -> samples.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNonNulls), this.createRowBuffer((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNonNulls, (IValueMeta)new ValueMetaInteger(fieldName), value)));
        }
        for (String fieldName2 : this.getProfileSamples().keySet()) {
            Map<BasicDataProfilingDataSampler.ProfilingType, RowBuffer> dataMap = this.getProfileSamples().get(fieldName2);
            for (BasicDataProfilingDataSampler.ProfilingType profilingType : BasicDataProfilingDataSampler.ProfilingType.values()) {
                RowBuffer rowBuffer = dataMap.get((Object)profilingType);
                if (rowBuffer == null || rowBuffer.isEmpty()) continue;
                String samplesKey = this.createSamplesKey(transformName, copyNr, fieldName2, profilingType);
                samples.put(samplesKey, rowBuffer);
            }
        }
        return samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, ExecutionDataSetMeta> getSamplesMetadata() {
        Map<String, ExecutionDataSetMeta> map = Collections.synchronizedMap(new HashMap());
        String transformName = this.samplerMeta.getTransformName();
        String copyNr = this.samplerMeta.getCopyNr();
        this.getMinValues().forEach((fieldName, value) -> map.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinValue), this.createValueMeta((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinValue)));
        this.getMaxValues().forEach((fieldName, value) -> map.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxValue), this.createValueMeta((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxValue)));
        this.getMinLengths().forEach((fieldName, value) -> map.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinLength), this.createValueMeta((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MinLength)));
        this.getMaxLengths().forEach((fieldName, value) -> map.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxLength), this.createValueMeta((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.MaxLength)));
        if (this.dataSampler.isProfilingNrNull()) {
            this.getNullCounters().forEach((fieldName, value) -> map.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNulls), this.createValueMeta((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNulls)));
        }
        if (this.dataSampler.isProfilingNrNonNull()) {
            this.getNonNullCounters().forEach((fieldName, value) -> map.put(this.createValueKey(transformName, copyNr, (String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNonNulls), this.createValueMeta((String)fieldName, BasicDataProfilingDataSampler.ProfilingType.NrNonNulls)));
        }
        for (String fieldName2 : this.getProfileSamples().keySet()) {
            Map<BasicDataProfilingDataSampler.ProfilingType, RowBuffer> dataMap = this.getProfileSamples().get(fieldName2);
            Map<String, ExecutionDataSetMeta> map2 = map;
            synchronized (map2) {
                Map<BasicDataProfilingDataSampler.ProfilingType, RowBuffer> map3 = dataMap;
                synchronized (map3) {
                    for (BasicDataProfilingDataSampler.ProfilingType profilingType : BasicDataProfilingDataSampler.ProfilingType.values()) {
                        String samplesKey = this.createSamplesKey(this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), fieldName2, profilingType);
                        String samplesDescription = this.createSamplesDescription(this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), fieldName2, profilingType);
                        ExecutionDataSetMeta setMeta = new ExecutionDataSetMeta(samplesKey, this.samplerMeta.getLogChannelId(), this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), fieldName2, profilingType.getDescription(), samplesDescription);
                        map.put(samplesKey, setMeta);
                    }
                }
            }
        }
        return map;
    }

    private RowBuffer createRowBuffer(String fieldName, BasicDataProfilingDataSampler.ProfilingType profilingType, IValueMeta valueMeta, Object valueData) {
        RowMeta bufferRowMeta = new RowMeta();
        bufferRowMeta.addValueMeta(valueMeta);
        Object[] bufferRow = RowDataUtil.allocateRowData((int)1);
        bufferRow[0] = valueData;
        return new RowBuffer((IRowMeta)bufferRowMeta, List.of(bufferRow));
    }

    private String createValueKey(String transformName, String copyNr, String fieldName, BasicDataProfilingDataSampler.ProfilingType profilingType) {
        return transformName + "." + copyNr + ": " + profilingType.name() + "-value-" + fieldName;
    }

    private ExecutionDataSetMeta createValueMeta(String fieldName, BasicDataProfilingDataSampler.ProfilingType profilingType) {
        String setKey = this.createValueKey(this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), fieldName, profilingType);
        String setDescription = profilingType.getDescription() + " : " + fieldName;
        return new ExecutionDataSetMeta(setKey, this.samplerMeta.getLogChannelId(), this.samplerMeta.getTransformName(), this.samplerMeta.getCopyNr(), fieldName, profilingType.getDescription(), setDescription);
    }

    private String createSamplesKey(String transformName, String copyNr, String fieldName, BasicDataProfilingDataSampler.ProfilingType profilingType) {
        return transformName + "." + copyNr + ": " + profilingType.name() + "-samples-" + fieldName;
    }

    private String createSamplesDescription(String transformName, String copyNr, String fieldName, BasicDataProfilingDataSampler.ProfilingType profilingType) {
        return BaseMessages.getString(PKG, (String)"BasicDataProfilingRowsExecutionDataSample.SamplesDescription", (String[])new String[]{transformName, copyNr, profilingType.getDescription(), fieldName});
    }

    public Map<String, Object> getMinValues() {
        return this.minValues;
    }

    public void setMinValues(Map<String, Object> minValues) {
        this.minValues = minValues;
    }

    public Map<String, IValueMeta> getMinMeta() {
        return this.minMeta;
    }

    public void setMinMeta(Map<String, IValueMeta> minMeta) {
        this.minMeta = minMeta;
    }

    public Map<String, Object> getMaxValues() {
        return this.maxValues;
    }

    public void setMaxValues(Map<String, Object> maxValues) {
        this.maxValues = maxValues;
    }

    public Map<String, IValueMeta> getMaxMeta() {
        return this.maxMeta;
    }

    public void setMaxMeta(Map<String, IValueMeta> maxMeta) {
        this.maxMeta = maxMeta;
    }

    public Map<String, Long> getNullCounters() {
        return this.nullCounters;
    }

    public void setNullCounters(Map<String, Long> nullCounters) {
        this.nullCounters = nullCounters;
    }

    public Map<String, Long> getNonNullCounters() {
        return this.nonNullCounters;
    }

    public void setNonNullCounters(Map<String, Long> nonNullCounters) {
        this.nonNullCounters = nonNullCounters;
    }

    public Map<String, Integer> getMinLengths() {
        return this.minLengths;
    }

    public void setMinLengths(Map<String, Integer> minLengths) {
        this.minLengths = minLengths;
    }

    public Map<String, Integer> getMaxLengths() {
        return this.maxLengths;
    }

    public void setMaxLengths(Map<String, Integer> maxLengths) {
        this.maxLengths = maxLengths;
    }

    public Map<String, Map<BasicDataProfilingDataSampler.ProfilingType, RowBuffer>> getProfileSamples() {
        return this.profileSamples;
    }

    public void setProfileSamples(Map<String, Map<BasicDataProfilingDataSampler.ProfilingType, RowBuffer>> profileSamples) {
        this.profileSamples = profileSamples;
    }
}

