/*
 * Decompiled with CFR 0.152.
 */
package com.datastax.oss.driver.internal.core.type.codec;

import com.datastax.oss.driver.api.core.ProtocolVersion;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.DataTypes;
import com.datastax.oss.driver.api.core.type.codec.TypeCodec;
import com.datastax.oss.driver.api.core.type.reflect.GenericType;
import com.datastax.oss.protocol.internal.util.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
public class VarIntCodec
implements TypeCodec<BigInteger> {
    @Override
    @NonNull
    public GenericType<BigInteger> getJavaType() {
        return GenericType.BIG_INTEGER;
    }

    @Override
    @NonNull
    public DataType getCqlType() {
        return DataTypes.VARINT;
    }

    @Override
    public boolean accepts(@NonNull Object value) {
        return value instanceof BigInteger;
    }

    @Override
    public boolean accepts(@NonNull Class<?> javaClass) {
        return BigInteger.class.isAssignableFrom(javaClass);
    }

    @Override
    @Nullable
    public ByteBuffer encode(@Nullable BigInteger value, @NonNull ProtocolVersion protocolVersion) {
        return value == null ? null : ByteBuffer.wrap(value.toByteArray());
    }

    @Override
    @Nullable
    public BigInteger decode(@Nullable ByteBuffer bytes, @NonNull ProtocolVersion protocolVersion) {
        return bytes == null || bytes.remaining() == 0 ? null : new BigInteger(Bytes.getArray((ByteBuffer)bytes));
    }

    @Override
    @NonNull
    public String format(@Nullable BigInteger value) {
        return value == null ? "NULL" : value.toString();
    }

    @Override
    @Nullable
    public BigInteger parse(@Nullable String value) {
        try {
            return value == null || value.isEmpty() || value.equalsIgnoreCase("NULL") ? null : new BigInteger(value);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Cannot parse varint value from \"%s\"", value), e);
        }
    }
}

