/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.valuemapper;

import java.util.HashMap;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopValueException;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapperData;
import org.apache.hop.pipeline.transforms.valuemapper.ValueMapperMeta;
import org.apache.hop.pipeline.transforms.valuemapper.Values;

public class ValueMapper
extends BaseTransform<ValueMapperMeta, ValueMapperData> {
    private static final Class<?> PKG = ValueMapperMeta.class;
    private boolean nonMatchActivated = false;

    public ValueMapper(TransformMeta transformMeta, ValueMapperMeta meta, ValueMapperData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public boolean processRow() throws HopException {
        Object[] r = this.getRow();
        if (r == null) {
            this.setOutputDone();
            return false;
        }
        if (this.first) {
            this.first = false;
            ((ValueMapperData)this.data).previousMeta = this.getInputRowMeta().clone();
            ((ValueMapperData)this.data).outputMeta = ((ValueMapperData)this.data).previousMeta.clone();
            ((ValueMapperMeta)this.meta).getFields(((ValueMapperData)this.data).outputMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
            ((ValueMapperData)this.data).keynr = ((ValueMapperData)this.data).previousMeta.indexOfValue(((ValueMapperMeta)this.meta).getFieldToUse());
            if (((ValueMapperData)this.data).keynr < 0) {
                String message = BaseMessages.getString(PKG, (String)"ValueMapper.RuntimeError.FieldToUseNotFound.VALUEMAPPER0001", (String[])new String[]{((ValueMapperMeta)this.meta).getFieldToUse(), Const.CR, this.getInputRowMeta().getString(r)});
                this.logError(message);
                this.setErrors(1L);
                this.stopAll();
                return false;
            }
            ((ValueMapperData)this.data).sourceValueMeta = this.getInputRowMeta().getValueMeta(((ValueMapperData)this.data).keynr);
            this.setTargetMetaType();
            this.builMapValues();
            ((ValueMapperData)this.data).outputValueMeta = Utils.isEmpty((CharSequence)((ValueMapperMeta)this.meta).getTargetField()) ? ((ValueMapperData)this.data).outputMeta.getValueMeta(((ValueMapperData)this.data).keynr) : ((ValueMapperData)this.data).outputMeta.searchValueMeta(((ValueMapperMeta)this.meta).getTargetField());
        }
        Object sourceValue = r[((ValueMapperData)this.data).keynr];
        Object sourceData = ((ValueMapperData)this.data).sourceValueMeta.convertToNormalStorageType(sourceValue);
        Object target = null;
        if (((ValueMapperData)this.data).emptyFieldValue != null && (r[((ValueMapperData)this.data).keynr] == null || sourceData == null)) {
            target = ((ValueMapperData)this.data).emptyFieldValue;
        } else if (sourceData != null) {
            if (((ValueMapperData)this.data).mapValues.containsKey(sourceData)) {
                target = ((ValueMapperData)this.data).mapValues.get(sourceData);
            } else if (this.nonMatchActivated) {
                target = ((ValueMapperData)this.data).nonMatchDefault;
            }
        }
        if (!Utils.isEmpty((CharSequence)((ValueMapperMeta)this.meta).getTargetField())) {
            r = RowDataUtil.resizeArray((Object[])r, (int)((ValueMapperData)this.data).outputMeta.size());
            r[((ValueMapperData)this.data).outputMeta.size() - 1] = target;
        } else if (target != null) {
            r[((ValueMapperData)this.data).keynr] = target;
        } else if (((ValueMapperData)this.data).sourceValueMeta.isStorageBinaryString()) {
            Object normal;
            r[((ValueMapperData)this.data).keynr] = normal = ((ValueMapperData)this.data).sourceValueMeta.convertToNormalStorageType(r[((ValueMapperData)this.data).keynr]);
        }
        this.putRow(((ValueMapperData)this.data).outputMeta, r);
        return true;
    }

    private Object keyFromString(IValueMeta tgtMeta, IValueMeta srcMeta, String key) throws HopValueException {
        Object v = tgtMeta.convertData(srcMeta, (Object)key);
        return tgtMeta.convertToNormalStorageType(v);
    }

    private String typeName(IValueMeta vm) {
        return vm == null ? "<unknown>" : vm.toStringMeta();
    }

    private void builMapValues() throws HopException {
        ValueMetaString stringValueMeta = new ValueMetaString("String");
        try {
            if (!Utils.isEmpty((CharSequence)((ValueMapperMeta)this.meta).getNonMatchDefault())) {
                this.nonMatchActivated = true;
                String nonMatchStr = this.resolve(((ValueMapperMeta)this.meta).getNonMatchDefault());
                ((ValueMapperData)this.data).nonMatchDefault = this.keyFromString(((ValueMapperData)this.data).targetValueMeta, (IValueMeta)stringValueMeta, nonMatchStr);
            }
        }
        catch (HopValueException e) {
            String msg = String.format("Cannot convert the \"Default upon non-matching\" value [%s] to target type [%s].", this.resolve(((ValueMapperMeta)this.meta).getNonMatchDefault()), this.typeName(((ValueMapperData)this.data).targetValueMeta));
            throw new HopValueException(msg, (Throwable)e);
        }
        for (Values v : ((ValueMapperMeta)this.meta).getValues()) {
            Object tgtValue;
            Object srcValue;
            String src = v.getSource();
            String tgt = this.resolve(v.getTarget());
            try {
                srcValue = this.keyFromString(((ValueMapperData)this.data).sourceValueMeta, (IValueMeta)stringValueMeta, src);
            }
            catch (HopValueException ce) {
                String msg = String.format("Mapping entries: cannot convert source [%s] to source type [%s].", src, this.typeName(((ValueMapperData)this.data).sourceValueMeta));
                throw new HopValueException(msg, (Throwable)ce);
            }
            try {
                tgtValue = this.keyFromString(((ValueMapperData)this.data).targetValueMeta, (IValueMeta)stringValueMeta, tgt);
            }
            catch (HopValueException ce) {
                String msg = String.format("Mapping entries: cannot convert target [%s] to target type [%s].", src, this.typeName(((ValueMapperData)this.data).sourceValueMeta));
                throw new HopValueException(msg, (Throwable)ce);
            }
            if (srcValue == null) continue;
            ((ValueMapperData)this.data).mapValues.put(srcValue, tgtValue);
        }
        for (Values v : ((ValueMapperMeta)this.meta).getValues()) {
            if (!Utils.isEmpty((CharSequence)v.getSource())) continue;
            if (((ValueMapperData)this.data).emptyFieldValue == null) {
                String emptyFieldString = this.resolve(v.getTarget());
                ((ValueMapperData)this.data).emptyFieldValue = this.keyFromString(((ValueMapperData)this.data).targetValueMeta, (IValueMeta)stringValueMeta, emptyFieldString);
                continue;
            }
            throw new HopException(BaseMessages.getString(PKG, (String)"ValueMapper.RuntimeError.OnlyOneEmptyMappingAllowed.VALUEMAPPER0004", (String[])new String[0]));
        }
    }

    private void setTargetMetaType() {
        try {
            int targetValueMetaId;
            String targetValueMetaName;
            if (!Utils.isEmpty((CharSequence)((ValueMapperMeta)this.meta).getTargetType())) {
                targetValueMetaName = ((ValueMapperMeta)this.meta).getTargetType();
                targetValueMetaId = ValueMetaFactory.getIdForValueMeta((String)targetValueMetaName);
            } else {
                boolean noNewField = ((ValueMapperData)this.data).previousMeta.size() == ((ValueMapperData)this.data).outputMeta.size();
                targetValueMetaId = noNewField ? ((ValueMapperData)this.data).sourceValueMeta.getType() : 2;
                targetValueMetaName = ((ValueMapperData)this.data).sourceValueMeta.getName();
            }
            ((ValueMapperData)this.data).targetValueMeta = ValueMetaFactory.createValueMeta((String)targetValueMetaName, (int)targetValueMetaId);
        }
        catch (HopException e) {
            ((ValueMapperData)this.data).targetValueMeta = new ValueMetaString("String");
        }
    }

    public void dispose() {
        super.dispose();
    }

    public boolean init() {
        if (super.init()) {
            ((ValueMapperData)this.data).mapValues = new HashMap();
            return true;
        }
        return false;
    }
}

