/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts;

import java.io.IOException;
import javax.net.ssl.SSLException;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.auth.oauth2.GoogleCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.CallCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.ChannelCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.CompositeChannelCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.Status;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.DualCallCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.FailingCallCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.HandshakerServiceChannel;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.alts.internal.AltsProtocolNegotiator;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.auth.MoreCallCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.internal.SharedResourcePool;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.GrpcSslContexts;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.InternalNettyChannelCredentials;
import org.apache.beam.vendor.grpc.v1p69p0.io.grpc.netty.InternalProtocolNegotiator;
import org.apache.beam.vendor.grpc.v1p69p0.io.netty.handler.ssl.SslContext;

public final class GoogleDefaultChannelCredentials {
    private GoogleDefaultChannelCredentials() {
    }

    public static ChannelCredentials create() {
        return GoogleDefaultChannelCredentials.newBuilder().build();
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        private CallCredentials callCredentials;
        private CallCredentials altsCallCredentials;

        private Builder() {
        }

        public Builder callCredentials(CallCredentials callCreds) {
            this.callCredentials = callCreds;
            return this;
        }

        public Builder altsCallCredentials(CallCredentials callCreds) {
            this.altsCallCredentials = callCreds;
            return this;
        }

        public ChannelCredentials build() {
            ChannelCredentials nettyCredentials = InternalNettyChannelCredentials.create(Builder.createClientFactory());
            CallCredentials tlsCallCreds = this.callCredentials;
            if (tlsCallCreds == null) {
                try {
                    tlsCallCreds = MoreCallCredentials.from(GoogleCredentials.getApplicationDefault());
                }
                catch (IOException e) {
                    tlsCallCreds = new FailingCallCredentials(Status.UNAUTHENTICATED.withDescription("Failed to get Google default credentials").withCause(e));
                }
            }
            CallCredentials callCreds = this.altsCallCredentials == null ? tlsCallCreds : new DualCallCredentials(tlsCallCreds, this.altsCallCredentials);
            return CompositeChannelCredentials.create(nettyCredentials, callCreds);
        }

        private static InternalProtocolNegotiator.ClientFactory createClientFactory() {
            SslContext sslContext;
            try {
                sslContext = GrpcSslContexts.forClient().build();
            }
            catch (SSLException e) {
                throw new RuntimeException(e);
            }
            return new AltsProtocolNegotiator.GoogleDefaultProtocolNegotiatorFactory(ImmutableList.of(), SharedResourcePool.forResource(HandshakerServiceChannel.SHARED_HANDSHAKER_CHANNEL), sslContext);
        }
    }
}

