/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.spark.translation;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.beam.model.pipeline.v1.RunnerApi;
import org.apache.beam.runners.core.InMemoryTimerInternals;
import org.apache.beam.runners.core.ReduceFnRunner;
import org.apache.beam.runners.core.SideInputReader;
import org.apache.beam.runners.core.StateInternals;
import org.apache.beam.runners.core.StateInternalsFactory;
import org.apache.beam.runners.core.SystemReduceFn;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.beam.runners.core.UnsupportedSideInputReader;
import org.apache.beam.runners.core.construction.SerializablePipelineOptions;
import org.apache.beam.runners.core.triggers.ExecutableTriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachine;
import org.apache.beam.runners.core.triggers.TriggerStateMachines;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.util.WindowedValueReceiver;
import org.apache.beam.sdk.util.construction.TriggerTranslation;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.WindowedValue;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.spark.api.java.function.FlatMapFunction;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Instant;

class SparkGroupAlsoByWindowViaOutputBufferFn<@UnknownKeyFor K, @UnknownKeyFor InputT, @UnknownKeyFor W extends @UnknownKeyFor @NonNull @Initialized BoundedWindow>
implements FlatMapFunction<KV<K, Iterable<WindowedValue<InputT>>>, WindowedValue<KV<K, Iterable<InputT>>>> {
    private final /*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy;
    private final @UnknownKeyFor @NonNull @Initialized StateInternalsFactory<K> stateInternalsFactory;
    private final @UnknownKeyFor @NonNull @Initialized SystemReduceFn<K, InputT, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>, W> reduceFn;
    private final @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options;

    public SparkGroupAlsoByWindowViaOutputBufferFn(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized WindowingStrategy<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?, W> windowingStrategy, @UnknownKeyFor @NonNull @Initialized StateInternalsFactory<K> stateInternalsFactory, @UnknownKeyFor @NonNull @Initialized SystemReduceFn<K, InputT, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>, W> reduceFn, @UnknownKeyFor @NonNull @Initialized SerializablePipelineOptions options) {
        this.windowingStrategy = windowingStrategy;
        this.stateInternalsFactory = stateInternalsFactory;
        this.reduceFn = reduceFn;
        this.options = options;
    }

    public @UnknownKeyFor @NonNull @Initialized Iterator<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>>>> call(@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<InputT>>> kv) throws @UnknownKeyFor @NonNull @Initialized Exception {
        Object key = kv.getKey();
        Iterable values = (Iterable)kv.getValue();
        InMemoryTimerInternals timerInternals = new InMemoryTimerInternals();
        timerInternals.advanceProcessingTime(Instant.now());
        timerInternals.advanceSynchronizedProcessingTime(Instant.now());
        StateInternals stateInternals = this.stateInternalsFactory.stateInternalsForKey(key);
        GABWWindowedValueReceiver outputter = new GABWWindowedValueReceiver();
        ReduceFnRunner reduceFnRunner = new ReduceFnRunner(key, this.windowingStrategy, ExecutableTriggerStateMachine.create((TriggerStateMachine)TriggerStateMachines.stateMachineForTrigger((RunnerApi.Trigger)TriggerTranslation.toProto((Trigger)this.windowingStrategy.getTrigger()))), stateInternals, (TimerInternals)timerInternals, outputter, (SideInputReader)new UnsupportedSideInputReader("GroupAlsoByWindow"), this.reduceFn, this.options.get());
        reduceFnRunner.processElements(values);
        timerInternals.advanceInputWatermark(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        timerInternals.advanceSynchronizedProcessingTime(BoundedWindow.TIMESTAMP_MAX_VALUE);
        this.fireEligibleTimers(timerInternals, reduceFnRunner);
        reduceFnRunner.persist();
        return outputter.getOutputs().iterator();
    }

    private void fireEligibleTimers(@UnknownKeyFor @NonNull @Initialized InMemoryTimerInternals timerInternals, @UnknownKeyFor @NonNull @Initialized ReduceFnRunner<K, InputT, @UnknownKeyFor @NonNull @Initialized Iterable<InputT>, W> reduceFnRunner) throws @UnknownKeyFor @NonNull @Initialized Exception {
        ArrayList<TimerInternals.TimerData> timers = new ArrayList<TimerInternals.TimerData>();
        while (true) {
            TimerInternals.TimerData timer;
            if ((timer = timerInternals.removeNextEventTimer()) != null) {
                timers.add(timer);
                continue;
            }
            while ((timer = timerInternals.removeNextProcessingTimer()) != null) {
                timers.add(timer);
            }
            while ((timer = timerInternals.removeNextSynchronizedProcessingTimer()) != null) {
                timers.add(timer);
            }
            if (timers.isEmpty()) break;
            reduceFnRunner.onTimers(timers);
            timers.clear();
        }
    }

    private static class GABWWindowedValueReceiver<@UnknownKeyFor K, @UnknownKeyFor V>
    implements WindowedValueReceiver<KV<K, Iterable<V>>> {
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> outputs = new ArrayList<WindowedValue<KV<K, Iterable<V>>>>();

        private GABWWindowedValueReceiver() {
        }

        public void output(@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>> value) {
            this.outputs.add(value);
        }

        @UnknownKeyFor @NonNull @Initialized Iterable<@UnknownKeyFor @NonNull @Initialized WindowedValue<@UnknownKeyFor @NonNull @Initialized KV<K, @UnknownKeyFor @NonNull @Initialized Iterable<V>>>> getOutputs() {
            return this.outputs;
        }
    }
}

