/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.actions.createfile;

import java.io.IOException;
import java.util.List;
import lombok.Generated;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.Result;
import org.apache.hop.core.ResultFile;
import org.apache.hop.core.annotations.Action;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.action.ActionBase;
import org.apache.hop.workflow.action.validator.AbstractFileValidator;
import org.apache.hop.workflow.action.validator.ActionValidatorUtils;
import org.apache.hop.workflow.action.validator.AndValidator;
import org.apache.hop.workflow.action.validator.IActionValidator;
import org.apache.hop.workflow.action.validator.ValidatorContext;
import org.apache.hop.workflow.engine.IWorkflowEngine;

@Action(id="CREATE_FILE", name="i18n::ActionCreateFile.Name", description="i18n::ActionCreateFile.Description", image="CreateFile.svg", categoryDescription="i18n:org.apache.hop.workflow:ActionCategory.Category.FileManagement", keywords={"i18n::ActionCreateFile.Keyword"}, documentationUrl="/workflow/actions/createfile.html")
public class ActionCreateFile
extends ActionBase
implements Cloneable {
    private static final Class<?> PKG = ActionCreateFile.class;
    private static final String CONST_FILE = "File [";
    private static final String CONST_FILENAME = "filename";
    @HopMetadataProperty(key="filename")
    private String filename = null;
    @HopMetadataProperty(key="fail_if_file_exists")
    private boolean failIfFileExists = true;
    @HopMetadataProperty(key="add_filename_result")
    private boolean addFilenameToResult = false;

    public ActionCreateFile(String n) {
        super(n, "");
    }

    public ActionCreateFile() {
        this("");
    }

    public String getRealFilename() {
        return this.resolve(this.getFilename());
    }

    public Result execute(Result result, int nr) throws HopException {
        result.setResult(false);
        if (this.filename != null) {
            String realFilename = this.getRealFilename();
            try (FileObject fileObject = HopVfs.getFileObject((String)realFilename, (IVariables)this.getVariables());){
                if (fileObject.exists()) {
                    if (this.isFailIfFileExists()) {
                        result.setResult(false);
                        this.logError(CONST_FILE + realFilename + "] exists, failing.");
                    } else {
                        result.setResult(true);
                        if (this.isBasic()) {
                            this.logBasic(CONST_FILE + realFilename + "] already exists, not recreating.");
                        }
                    }
                    if (this.isAddFilenameToResult()) {
                        this.addFilenameToResult(realFilename, result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow);
                    }
                } else {
                    fileObject.createFile();
                    if (this.isBasic()) {
                        this.logBasic(CONST_FILE + realFilename + "] created!");
                    }
                    if (this.isAddFilenameToResult()) {
                        this.addFilenameToResult(realFilename, result, (IWorkflowEngine<WorkflowMeta>)this.parentWorkflow);
                    }
                    result.setResult(true);
                }
            }
            catch (IOException e) {
                this.logError("Could not create file [" + realFilename + "], exception: " + e.getMessage());
                result.setResult(false);
                result.setNrErrors(1L);
            }
        } else {
            this.logError("No filename is defined.");
        }
        return result;
    }

    private void addFilenameToResult(String targetFilename, Result result, IWorkflowEngine<WorkflowMeta> parentWorkflow) throws HopException {
        try (FileObject targetFile = HopVfs.getFileObject((String)targetFilename, (IVariables)this.getVariables());){
            ResultFile resultFile = new ResultFile(0, targetFile, parentWorkflow.getWorkflowName(), this.toString());
            resultFile.setComment("");
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
            if (this.isDetailed()) {
                this.logDetailed(BaseMessages.getString(PKG, (String)"ActionCreateFile.FileAddedToResult", (String[])new String[]{targetFilename}));
            }
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public boolean isEvaluation() {
        return true;
    }

    public void check(List<ICheckResult> remarks, WorkflowMeta workflowMeta, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValidatorContext ctx = new ValidatorContext();
        AbstractFileValidator.putVariableSpace((ValidatorContext)ctx, (IVariables)this.getVariables());
        AndValidator.putValidators((ValidatorContext)ctx, (IActionValidator[])new IActionValidator[]{ActionValidatorUtils.notNullValidator(), ActionValidatorUtils.fileDoesNotExistValidator()});
        ActionValidatorUtils.andValidator().validate((ICheckResultSource)this, CONST_FILENAME, remarks, ctx);
    }

    @Generated
    public void setFilename(String filename) {
        this.filename = filename;
    }

    @Generated
    public void setFailIfFileExists(boolean failIfFileExists) {
        this.failIfFileExists = failIfFileExists;
    }

    @Generated
    public void setAddFilenameToResult(boolean addFilenameToResult) {
        this.addFilenameToResult = addFilenameToResult;
    }

    @Generated
    public String getFilename() {
        return this.filename;
    }

    @Generated
    public boolean isFailIfFileExists() {
        return this.failIfFileExists;
    }

    @Generated
    public boolean isAddFilenameToResult() {
        return this.addFilenameToResult;
    }
}

