/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core;

import java.util.Enumeration;
import java.util.Hashtable;
import lombok.Generated;
import org.apache.hop.core.DbCacheEntry;
import org.apache.hop.core.row.IRowMeta;

public class DbCache {
    private static DbCache dbCache;
    private Hashtable<DbCacheEntry, IRowMeta> cache = new Hashtable();
    private boolean active = true;

    public void put(DbCacheEntry entry, IRowMeta fields) {
        if (!this.active) {
            return;
        }
        IRowMeta copy = fields.clone();
        this.cache.put(entry, copy);
    }

    public IRowMeta get(DbCacheEntry entry) {
        if (!this.active) {
            return null;
        }
        IRowMeta fields = this.cache.get(entry);
        if (fields != null) {
            fields = fields.clone();
        }
        return fields;
    }

    public int size() {
        return this.cache.size();
    }

    public void clear(String dbname) {
        if (dbname == null) {
            this.cache = new Hashtable();
        } else {
            Enumeration<DbCacheEntry> keys = this.cache.keys();
            while (keys.hasMoreElements()) {
                DbCacheEntry entry = keys.nextElement();
                if (!entry.sameDB(dbname)) continue;
                this.cache.remove(entry);
            }
        }
    }

    private DbCache() {
    }

    public static DbCache getInstance() {
        if (dbCache == null) {
            dbCache = new DbCache();
        }
        return dbCache;
    }

    public static void clearAll() {
        DbCache.getInstance().clear(null);
    }

    @Generated
    public boolean isActive() {
        return this.active;
    }

    @Generated
    public void setActive(boolean active) {
        this.active = active;
    }
}

