/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.gui.plugin.key;

import java.lang.reflect.Method;
import java.util.Objects;
import org.apache.hop.core.gui.plugin.key.GuiKeyboardShortcut;
import org.apache.hop.core.gui.plugin.key.GuiOsxKeyboardShortcut;

public class KeyboardShortcut {
    private boolean osx;
    private boolean alt;
    private boolean control;
    private boolean shift;
    private boolean command;
    private int keyCode;
    private String parentMethodName;

    public KeyboardShortcut() {
        this.keyCode = 0;
    }

    public KeyboardShortcut(GuiKeyboardShortcut shortcut, Method parentMethod) {
        this.osx = false;
        this.alt = shortcut.alt();
        this.control = shortcut.control();
        this.shift = shortcut.shift();
        this.command = shortcut.command();
        this.keyCode = shortcut.key();
        this.parentMethodName = parentMethod.getName();
    }

    public KeyboardShortcut(GuiOsxKeyboardShortcut shortcut, Method parentMethod) {
        this.osx = true;
        this.alt = shortcut.alt();
        this.control = shortcut.control();
        this.shift = shortcut.shift();
        this.command = shortcut.command();
        this.keyCode = shortcut.key();
        this.parentMethodName = parentMethod.getName();
    }

    public String toString() {
        if (this.keyCode == 0) {
            return this.parentMethodName.toString();
        }
        StringBuilder str = new StringBuilder();
        if (this.control) {
            str.append("Ctrl+");
        }
        if (this.alt) {
            str.append("Alt+");
        }
        if (this.shift) {
            str.append("Shift+");
        }
        if (this.command) {
            str.append("Cmd+");
        }
        if (this.keyCode >= 65 && this.keyCode <= 90) {
            str.append((char)this.keyCode);
        } else if (this.keyCode >= 97 && this.keyCode <= 122) {
            str.append(Character.toUpperCase((char)this.keyCode));
        } else if (this.keyCode == 127) {
            str.append("Delete");
        } else if (this.keyCode >= 48 && this.keyCode <= 57 || "+-/*".indexOf(this.keyCode) >= 0) {
            str.append((char)this.keyCode);
        }
        if ((this.keyCode & 0x1000000) != 0) {
            switch (this.keyCode & 0xFFFF) {
                case 1: {
                    str.append("UP");
                    break;
                }
                case 2: {
                    str.append("DOWN");
                    break;
                }
                case 3: {
                    str.append("LEFT");
                    break;
                }
                case 4: {
                    str.append("RIGHT");
                    break;
                }
                case 5: {
                    str.append("PAGE_UP");
                    break;
                }
                case 6: {
                    str.append("PAGE_DOWN");
                    break;
                }
                case 7: {
                    str.append("HOME");
                    break;
                }
                case 8: {
                    str.append("END");
                    break;
                }
                case 9: {
                    str.append("INSERT");
                    break;
                }
                case 10: {
                    str.append("F1");
                    break;
                }
                case 11: {
                    str.append("F2");
                    break;
                }
                case 12: {
                    str.append("F3");
                    break;
                }
                case 13: {
                    str.append("F3");
                    break;
                }
                case 14: {
                    str.append("F5");
                    break;
                }
                case 15: {
                    str.append("F6");
                    break;
                }
                case 16: {
                    str.append("F7");
                    break;
                }
                case 17: {
                    str.append("F8");
                    break;
                }
                case 18: {
                    str.append("F9");
                    break;
                }
                case 19: {
                    str.append("F10");
                    break;
                }
                case 20: {
                    str.append("F11");
                    break;
                }
                case 21: {
                    str.append("F12");
                    break;
                }
                case 22: {
                    str.append("F13");
                    break;
                }
                case 23: {
                    str.append("F14");
                    break;
                }
                case 24: {
                    str.append("F15");
                    break;
                }
                case 25: {
                    str.append("F16");
                    break;
                }
                case 26: {
                    str.append("F17");
                    break;
                }
                case 27: {
                    str.append("F18");
                    break;
                }
                case 28: {
                    str.append("F19");
                    break;
                }
                case 29: {
                    str.append("F20");
                    break;
                }
            }
        }
        return str.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyboardShortcut that = (KeyboardShortcut)o;
        return this.alt == that.alt && this.control == that.control && this.shift == that.shift && this.command == that.command && this.keyCode == that.keyCode && this.parentMethodName.equals(that.parentMethodName);
    }

    public int hashCode() {
        return Objects.hash(this.alt, this.control, this.shift, this.command, this.keyCode, this.parentMethodName);
    }

    public boolean isOsx() {
        return this.osx;
    }

    public void setOsx(boolean osx) {
        this.osx = osx;
    }

    public boolean isAlt() {
        return this.alt;
    }

    public void setAlt(boolean alt) {
        this.alt = alt;
    }

    public boolean isControl() {
        return this.control;
    }

    public void setControl(boolean control) {
        this.control = control;
    }

    public boolean isShift() {
        return this.shift;
    }

    public void setShift(boolean shift) {
        this.shift = shift;
    }

    public boolean isCommand() {
        return this.command;
    }

    public void setCommand(boolean command) {
        this.command = command;
    }

    public int getKeyCode() {
        return this.keyCode;
    }

    public void setKeyCode(int keyCode) {
        this.keyCode = keyCode;
    }

    public String getParentMethodName() {
        return this.parentMethodName;
    }

    public void setParentMethodName(String parentMethodName) {
        this.parentMethodName = parentMethodName;
    }
}

