/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kafka;

import java.nio.charset.StandardCharsets;
import org.apache.beam.sdk.io.kafka.KafkaRecord;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Redistribute;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.hash.Hashing;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.primitives.UnsignedInteger;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class KafkaReadRedistribute<@UnknownKeyFor K, @UnknownKeyFor V>
extends PTransform<PCollection<KafkaRecord<K, V>>, PCollection<KafkaRecord<K, V>>> {
    private @Nullable @UnknownKeyFor @Initialized Integer numBuckets = null;
    private @UnknownKeyFor @NonNull @Initialized boolean byRecordKey = false;

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KafkaReadRedistribute<K, V> byOffsetShard(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
        return new KafkaReadRedistribute<K, V>(numBuckets, false);
    }

    public static <K, V> @UnknownKeyFor @NonNull @Initialized KafkaReadRedistribute<K, V> byRecordKey(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
        return new KafkaReadRedistribute<K, V>(numBuckets, true);
    }

    private KafkaReadRedistribute(@Nullable @UnknownKeyFor @Initialized Integer numBuckets, @UnknownKeyFor @NonNull @Initialized boolean byRecordKey) {
        this.numBuckets = numBuckets;
        this.byRecordKey = byRecordKey;
    }

    public @UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V>> expand(@UnknownKeyFor @NonNull @Initialized PCollection<@UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V>> input) {
        if (this.byRecordKey) {
            return (PCollection)((PCollection)((PCollection)input.apply("Pair with shard from key", (PTransform)ParDo.of(new AssignRecordKeyFn(this.numBuckets)))).apply((PTransform)Redistribute.byKey().withAllowDuplicates(false))).apply((PTransform)Values.create());
        }
        return (PCollection)((PCollection)((PCollection)input.apply("Pair with shard from offset", (PTransform)ParDo.of(new AssignOffsetShardFn(this.numBuckets)))).apply((PTransform)Redistribute.byKey().withAllowDuplicates(false))).apply((PTransform)Values.create());
    }

    static class AssignRecordKeyFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KafkaRecord<K, V>, KV<Integer, KafkaRecord<K, V>>> {
        private @NonNull @UnknownKeyFor @Initialized UnsignedInteger numBuckets;

        public AssignRecordKeyFn(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
            this.numBuckets = numBuckets != null && numBuckets > 0 ? UnsignedInteger.fromIntBits((int)numBuckets) : UnsignedInteger.valueOf((long)0L);
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V>>> receiver) {
            Object key = element.getKV().getKey();
            String keyString = key == null ? "" : key.toString();
            int hash = Hashing.farmHashFingerprint64().hashBytes(keyString.getBytes(StandardCharsets.UTF_8)).asInt();
            if (this.numBuckets != null) {
                hash = UnsignedInteger.fromIntBits((int)hash).mod(this.numBuckets).intValue();
            }
            receiver.output((Object)KV.of((Object)hash, element));
        }
    }

    static class AssignOffsetShardFn<@UnknownKeyFor K, @UnknownKeyFor V>
    extends DoFn<KafkaRecord<K, V>, KV<Integer, KafkaRecord<K, V>>> {
        private @NonNull @UnknownKeyFor @Initialized UnsignedInteger numBuckets;

        public AssignOffsetShardFn(@Nullable @UnknownKeyFor @Initialized Integer numBuckets) {
            this.numBuckets = numBuckets != null && numBuckets > 0 ? UnsignedInteger.fromIntBits((int)numBuckets) : UnsignedInteger.valueOf((long)0L);
        }

        @DoFn.ProcessElement
        public void processElement(@DoFn.Element @UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V> element, // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DoFn.OutputReceiver<@UnknownKeyFor @NonNull @Initialized KV<@UnknownKeyFor @NonNull @Initialized Integer, @UnknownKeyFor @NonNull @Initialized KafkaRecord<K, V>>> receiver) {
            int hash = Hashing.farmHashFingerprint64().hashLong(element.getOffset()).asInt();
            if (this.numBuckets != null) {
                hash = UnsignedInteger.fromIntBits((int)hash).mod(this.numBuckets).intValue();
            }
            receiver.output((Object)KV.of((Object)hash, element));
        }
    }
}

