/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.util;

import java.util.Optional;

public final class Reference<T> {
    private final T value;
    private final boolean isOwned;

    private Reference(T value, boolean isOwned) {
        this.value = value;
        this.isOwned = isOwned;
    }

    public T deref() {
        return this.value;
    }

    public Optional<T> owned() {
        return this.isOwned ? Optional.of(this.value) : Optional.empty();
    }

    public boolean isOwned() {
        return this.isOwned;
    }

    public String toString() {
        return this.value.toString();
    }

    public static <V> Reference<V> owned(V value) {
        return new Reference<V>(value, true);
    }

    public static <V> Reference<V> borrowed(V value) {
        return new Reference<V>(value, false);
    }
}

