/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import java.util.List;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteWriteSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration
extends PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration {
    private final String project;
    private final String location;
    private final String topicName;
    private final String format;
    private final @Nullable ErrorHandling errorHandling;
    private final @Nullable List<String> attributes;
    private final @Nullable String attributeId;
    private final @Nullable String fileDescriptorPath;
    private final @Nullable String messageName;
    private final @Nullable String schema;

    private AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration(String project, String location, String topicName, String format, @Nullable ErrorHandling errorHandling, @Nullable List<String> attributes, @Nullable String attributeId, @Nullable String fileDescriptorPath, @Nullable String messageName, @Nullable String schema) {
        this.project = project;
        this.location = location;
        this.topicName = topicName;
        this.format = format;
        this.errorHandling = errorHandling;
        this.attributes = attributes;
        this.attributeId = attributeId;
        this.fileDescriptorPath = fileDescriptorPath;
        this.messageName = messageName;
        this.schema = schema;
    }

    @Override
    @SchemaFieldDescription(value="The GCP project where the Pubsub Lite reservation resides. This can be a project number of a project ID.")
    public String getProject() {
        return this.project;
    }

    @Override
    @SchemaFieldDescription(value="The region or zone where the Pubsub Lite reservation resides.")
    public String getLocation() {
        return this.location;
    }

    @Override
    @SchemaFieldDescription(value="The name of the topic to publish data into. This will be concatenated with the project and location parameters to build a full topic path.")
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub Lite. Valid options are: RAW,JSON,AVRO,PROTO")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public @Nullable ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="List of attribute keys whose values will be pulled out as Pubsub Lite message attributes.  For example, if the format is `JSON` and attributes is `[\"a\", \"b\"]` then elements of the form `Row(any_field=..., a=..., b=...)` will result in Pubsub Lite messages whose payload has the contents of any_field and whose attribute will be populated with the values of `a` and `b`.")
    public @Nullable List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @SchemaFieldDescription(value="If set, will set an attribute for each Pubsub Lite message with the given name and a unique value. This attribute can then be used in a ReadFromPubSubLite PTransform to deduplicate messages.")
    public @Nullable String getAttributeId() {
        return this.attributeId;
    }

    @Override
    @SchemaFieldDescription(value="The path to the Protocol Buffer File Descriptor Set file. This file is used for schema definition and message serialization.")
    public @Nullable String getFileDescriptorPath() {
        return this.fileDescriptorPath;
    }

    @Override
    @SchemaFieldDescription(value="The name of the Protocol Buffer message to be used for schema extraction and data conversion.")
    public @Nullable String getMessageName() {
        return this.messageName;
    }

    @Override
    public @Nullable String getSchema() {
        return this.schema;
    }

    public String toString() {
        return "PubsubLiteWriteSchemaTransformConfiguration{project=" + this.project + ", location=" + this.location + ", topicName=" + this.topicName + ", format=" + this.format + ", errorHandling=" + this.errorHandling + ", attributes=" + this.attributes + ", attributeId=" + this.attributeId + ", fileDescriptorPath=" + this.fileDescriptorPath + ", messageName=" + this.messageName + ", schema=" + this.schema + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration) {
            PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration that = (PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration)o;
            return this.project.equals(that.getProject()) && this.location.equals(that.getLocation()) && this.topicName.equals(that.getTopicName()) && this.format.equals(that.getFormat()) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling())) && (this.attributes == null ? that.getAttributes() == null : this.attributes.equals(that.getAttributes())) && (this.attributeId == null ? that.getAttributeId() == null : this.attributeId.equals(that.getAttributeId())) && (this.fileDescriptorPath == null ? that.getFileDescriptorPath() == null : this.fileDescriptorPath.equals(that.getFileDescriptorPath())) && (this.messageName == null ? that.getMessageName() == null : this.messageName.equals(that.getMessageName())) && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.project.hashCode();
        h$ *= 1000003;
        h$ ^= this.location.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributes == null ? 0 : this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributeId == null ? 0 : this.attributeId.hashCode();
        h$ *= 1000003;
        h$ ^= this.fileDescriptorPath == null ? 0 : this.fileDescriptorPath.hashCode();
        h$ *= 1000003;
        h$ ^= this.messageName == null ? 0 : this.messageName.hashCode();
        h$ *= 1000003;
        return h$ ^= this.schema == null ? 0 : this.schema.hashCode();
    }

    static final class Builder
    extends PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder {
        private String project;
        private String location;
        private String topicName;
        private String format;
        private @Nullable ErrorHandling errorHandling;
        private @Nullable List<String> attributes;
        private @Nullable String attributeId;
        private @Nullable String fileDescriptorPath;
        private @Nullable String messageName;
        private @Nullable String schema;

        Builder() {
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setProject(String project) {
            if (project == null) {
                throw new NullPointerException("Null project");
            }
            this.project = project;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setLocation(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setTopicName(String topicName) {
            if (topicName == null) {
                throw new NullPointerException("Null topicName");
            }
            this.topicName = topicName;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setErrorHandling(ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setAttributes(List<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setAttributeId(String attributeId) {
            this.attributeId = attributeId;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setFileDescriptorPath(String fileDescriptorPath) {
            this.fileDescriptorPath = fileDescriptorPath;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setMessageName(String messageName) {
            this.messageName = messageName;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration.Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public PubsubLiteWriteSchemaTransformProvider.PubsubLiteWriteSchemaTransformConfiguration build() {
            if (this.project == null || this.location == null || this.topicName == null || this.format == null) {
                StringBuilder missing = new StringBuilder();
                if (this.project == null) {
                    missing.append(" project");
                }
                if (this.location == null) {
                    missing.append(" location");
                }
                if (this.topicName == null) {
                    missing.append(" topicName");
                }
                if (this.format == null) {
                    missing.append(" format");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubLiteWriteSchemaTransformProvider_PubsubLiteWriteSchemaTransformConfiguration(this.project, this.location, this.topicName, this.format, this.errorHandling, this.attributes, this.attributeId, this.fileDescriptorPath, this.messageName, this.schema);
        }
    }
}

