/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.aws2.s3;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.NonWritableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.SeekableByteChannel;
import org.apache.beam.sdk.io.aws2.s3.S3FileSystemConfiguration;
import org.apache.beam.sdk.io.aws2.s3.S3ResourceId;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.calledmethods.qual.EnsuresCalledMethodsIf;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import software.amazon.awssdk.core.ResponseInputStream;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.services.s3.S3Client;
import software.amazon.awssdk.services.s3.model.GetObjectRequest;
import software.amazon.awssdk.services.s3.model.GetObjectResponse;
import software.amazon.awssdk.services.s3.model.HeadObjectRequest;
import software.amazon.awssdk.utils.IoUtils;

@SuppressFBWarnings(value={"CT_CONSTRUCTOR_THROW"}, justification="Initialization is safe.")
class S3ReadableSeekableByteChannel
implements SeekableByteChannel {
    private static final @UnknownKeyFor @NonNull @Initialized long ABORT_THRESHOLD = 8192L;
    private final @UnknownKeyFor @NonNull @Initialized S3Client s3Client;
    private final @UnknownKeyFor @NonNull @Initialized S3ResourceId path;
    private final @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config;
    private final @UnknownKeyFor @NonNull @Initialized long contentLength;
    private @UnknownKeyFor @NonNull @Initialized long position = 0L;
    private @UnknownKeyFor @NonNull @Initialized boolean open = true;
    private @Nullable @UnknownKeyFor @Initialized ResponseInputStream<@UnknownKeyFor @NonNull @Initialized GetObjectResponse> s3ResponseInputStream;
    private @Nullable @UnknownKeyFor @Initialized ReadableByteChannel s3ObjectContentChannel;

    S3ReadableSeekableByteChannel(@UnknownKeyFor @NonNull @Initialized S3Client s3Client, @UnknownKeyFor @NonNull @Initialized S3ResourceId path, @UnknownKeyFor @NonNull @Initialized S3FileSystemConfiguration config) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.s3Client = (S3Client)Preconditions.checkNotNull((Object)s3Client, (Object)"s3Client");
        Preconditions.checkNotNull((Object)path, (Object)"path");
        this.config = (S3FileSystemConfiguration)Preconditions.checkNotNull((Object)config, (Object)"config");
        if (path.getSize().isPresent()) {
            this.contentLength = (Long)path.getSize().get();
            this.path = path;
        } else {
            HeadObjectRequest request = (HeadObjectRequest)HeadObjectRequest.builder().bucket(path.getBucket()).key(path.getKey()).build();
            try {
                this.contentLength = s3Client.headObject(request).contentLength();
            }
            catch (SdkClientException e) {
                throw new IOException(e);
            }
            this.path = path.withSize(this.contentLength);
        }
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int read(@UnknownKeyFor @NonNull @Initialized ByteBuffer destinationBuffer) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        if (!destinationBuffer.hasRemaining()) {
            return 0;
        }
        if (this.position == this.contentLength) {
            return -1;
        }
        if (this.s3ResponseInputStream == null) {
            GetObjectRequest.Builder builder = GetObjectRequest.builder().bucket(this.path.getBucket()).key(this.path.getKey()).sseCustomerKey(this.config.getSSECustomerKey().getKey()).sseCustomerAlgorithm(this.config.getSSECustomerKey().getAlgorithm());
            if (this.position > 0L) {
                builder.range(String.format("bytes=%s-%s", this.position, this.contentLength));
            }
            GetObjectRequest request = (GetObjectRequest)builder.build();
            try {
                this.s3ResponseInputStream = this.s3Client.getObject(request);
            }
            catch (SdkClientException e) {
                throw new IOException(e);
            }
            this.s3ObjectContentChannel = Channels.newChannel(new BufferedInputStream((InputStream)this.s3ResponseInputStream, 0x100000));
        }
        int totalBytesRead = 0;
        int bytesRead = 0;
        do {
            totalBytesRead += bytesRead;
            try {
                bytesRead = this.s3ObjectContentChannel.read(destinationBuffer);
            }
            catch (SdkServiceException e) {
                throw new IOException(e);
            }
        } while (bytesRead > 0);
        this.position += (long)totalBytesRead;
        return totalBytesRead;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long position() throws @UnknownKeyFor @NonNull @Initialized ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.position;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel position(@UnknownKeyFor @NonNull @Initialized long newPosition) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        Preconditions.checkArgument((newPosition >= 0L ? 1 : 0) != 0, (Object)"newPosition too low");
        Preconditions.checkArgument((newPosition < this.contentLength ? 1 : 0) != 0, (Object)"new position too high");
        if (newPosition == this.position) {
            return this;
        }
        this.closeStream();
        this.position = newPosition;
        return this;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized long size() throws @UnknownKeyFor @NonNull @Initialized ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        return this.contentLength;
    }

    private void closeStream() throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (this.s3ResponseInputStream == null) {
            return;
        }
        if (this.contentLength - this.position > 8192L) {
            this.s3ResponseInputStream.abort();
            this.s3ResponseInputStream.release();
        } else {
            IoUtils.drainInputStream(this.s3ResponseInputStream);
        }
        this.s3ObjectContentChannel.close();
        this.s3ObjectContentChannel = null;
        this.s3ResponseInputStream = null;
    }

    @Override
    public void close() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.closeStream();
        this.open = false;
    }

    @Override
    @EnsuresCalledMethodsIf(expression={"this"}, result=false, methods={"close"})
    public @UnknownKeyFor @NonNull @Initialized boolean isOpen() {
        return this.open;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized int write(@UnknownKeyFor @NonNull @Initialized ByteBuffer src) {
        throw new NonWritableChannelException();
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized SeekableByteChannel truncate(@UnknownKeyFor @NonNull @Initialized long size) {
        throw new NonWritableChannelException();
    }
}

