/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.kafka.consumer;

import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.gui.Point;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.execution.ExecutionInfoLocation;
import org.apache.hop.execution.profiling.ExecutionDataProfile;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.TransformWithMappingMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.injector.InjectorField;
import org.apache.hop.pipeline.transforms.injector.InjectorMeta;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerField;
import org.apache.hop.pipeline.transforms.kafka.consumer.KafkaConsumerInputMeta;
import org.apache.hop.pipeline.transforms.kafka.shared.KafkaDialogHelper;
import org.apache.hop.pipeline.transforms.kafka.shared.KafkaFactory;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageBox;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.hopgui.HopGui;
import org.apache.hop.ui.hopgui.file.pipeline.HopPipelineFileType;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class KafkaConsumerInputDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = KafkaConsumerInputDialog.class;
    private static final Map<String, String> DEFAULT_OPTION_VALUES = ImmutableMap.of((Object)"auto.offset.reset", (Object)"latest");
    private final KafkaFactory kafkaFactory = KafkaFactory.defaultFactory();
    protected KafkaConsumerInputMeta meta;
    protected Label wlFilename;
    protected TextVar wFilename;
    protected Button wbFilename;
    protected Button wbCreatePipeline;
    protected MetaSelectionLine<ExecutionInfoLocation> wLocation;
    protected MetaSelectionLine<ExecutionDataProfile> wProfile;
    protected Label wlSubTransform;
    protected ComboVar wSubTransform;
    protected ModifyListener lsMod;
    protected Label wlBatchSize;
    protected TextVar wBatchSize;
    protected Label wlBatchDuration;
    protected TextVar wBatchDuration;
    protected CTabFolder wTabFolder;
    protected CTabItem wSetupTab;
    protected CTabItem wBatchTab;
    protected CTabItem wResultsTab;
    protected Composite wSetupComp;
    protected Composite wBatchComp;
    protected Composite wResultsComp;
    private final HopGui hopGui;
    private TextVar wConsumerGroup;
    private Button wbAutoCommit;
    private Button wbManualCommit;
    private TableView fieldsTable;
    private TableView topicsTable;
    private TableView optionsTable;
    private TextVar wBootstrapServers;
    private final int middle = this.props.getMiddlePct();
    private final int margin = PropsUi.getMargin();

    public KafkaConsumerInputDialog(Shell parent, IVariables variables, KafkaConsumerInputMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.meta = transformMeta;
        this.hopGui = HopGui.getInstance();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.meta);
        this.shell.setMinimumSize(527, 622);
        this.lsMod = e -> this.meta.setChanged();
        this.changed = this.meta.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = PropsUi.getMargin();
        formLayout.marginHeight = PropsUi.getMargin();
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(this.getDialogTitle());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        KafkaConsumerInputDialog.positionBottomButtons((Composite)this.shell, (Button[])new Button[]{this.wOk, this.wCancel}, (int)this.margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.TransformName.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(this.lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment((Control)this.wlTransformName, this.margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        this.wlFilename = new Label((Composite)this.shell, 131072);
        PropsUi.setLook((Widget)this.wlFilename);
        this.wlFilename.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Pipeline", (String[])new String[0]));
        FormData fdlFilename = new FormData();
        fdlFilename.left = new FormAttachment(0, 0);
        fdlFilename.top = new FormAttachment((Control)this.wTransformName, this.margin * 2);
        fdlFilename.right = new FormAttachment(this.middle, -this.margin);
        this.wlFilename.setLayoutData((Object)fdlFilename);
        this.wbCreatePipeline = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)this.wbCreatePipeline);
        this.wbCreatePipeline.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Pipeline.CreatePipeline", (String[])new String[0]));
        FormData fdCreatePipeline = new FormData();
        fdCreatePipeline.right = new FormAttachment(100, 0);
        fdCreatePipeline.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wbCreatePipeline.setLayoutData((Object)fdCreatePipeline);
        this.wbCreatePipeline.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                KafkaConsumerInputDialog.this.createNewKafkaPipeline();
            }
        });
        this.wbFilename = new Button((Composite)this.shell, 8);
        PropsUi.setLook((Widget)this.wbFilename);
        this.wbFilename.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Pipeline.Browse", (String[])new String[0]));
        FormData fdbFilename = new FormData();
        fdbFilename.right = new FormAttachment((Control)this.wbCreatePipeline, -this.margin);
        fdbFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wbFilename.setLayoutData((Object)fdbFilename);
        this.wbFilename.addListener(13, e -> {
            HopPipelineFileType pipelineFileType = new HopPipelineFileType();
            BaseDialog.presentFileDialog((Shell)this.shell, (TextVar)this.wFilename, (IVariables)this.variables, (String[])pipelineFileType.getFilterExtensions(), (String[])pipelineFileType.getFilterNames(), (boolean)true);
        });
        this.wFilename = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wFilename);
        FormData fdFilename = new FormData();
        fdFilename.left = new FormAttachment((Control)this.wlFilename, this.margin);
        fdFilename.right = new FormAttachment((Control)this.wbFilename, -PropsUi.getMargin());
        fdFilename.top = new FormAttachment((Control)this.wlFilename, 0, 0x1000000);
        this.wFilename.setLayoutData((Object)fdFilename);
        this.wLocation = new MetaSelectionLine(this.variables, this.metadataProvider, ExecutionInfoLocation.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Location.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Location.Tooltip", (String[])new String[0]));
        FormData fdLocation = new FormData();
        fdLocation.left = new FormAttachment(0, 0);
        fdLocation.top = new FormAttachment((Control)this.wFilename, this.margin);
        fdLocation.right = new FormAttachment(100, 0);
        this.wLocation.setLayoutData((Object)fdLocation);
        this.wProfile = new MetaSelectionLine(this.variables, this.metadataProvider, ExecutionDataProfile.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Profile.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Profile.Tooltip", (String[])new String[0]));
        FormData fdProfile = new FormData();
        fdProfile.left = new FormAttachment(0, 0);
        fdProfile.top = new FormAttachment(this.wLocation, this.margin);
        fdProfile.right = new FormAttachment(100, 0);
        this.wProfile.setLayoutData((Object)fdProfile);
        try {
            this.wLocation.fillItems();
            this.wProfile.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error getting lists of locations and profiles", e2);
        }
        this.wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)this.wTabFolder, (int)4);
        this.wTabFolder.setUnselectedCloseVisible(true);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment(this.wProfile, 15);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -15);
        fdTabFolder.right = new FormAttachment(100, 0);
        this.wTabFolder.setLayoutData((Object)fdTabFolder);
        this.buildSetupTab();
        this.buildBatchTab();
        this.buildResultsTab();
        this.createAdditionalTabs();
        this.getData();
        this.wTabFolder.setSelection(0);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void ok() {
        this.transformName = this.wTransformName.getText();
        if (Utils.isEmpty((CharSequence)this.wFilename.getText())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.FilenameMissing.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.FilenameMissing.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        if (this.isSelfReferencing()) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.SelfReference.Header", (String[])new String[0]));
            mb.setMessage(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.SelfReference.Message", (String[])new String[0]));
            mb.open();
            return;
        }
        this.updateMeta(this.meta);
        this.dispose();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void updateMeta(KafkaConsumerInputMeta m) {
        m.setFilename(this.wFilename.getText());
        m.setExecutionInformationLocation(this.wLocation.getText());
        m.setExecutionDataProfile(this.wProfile.getText());
        m.setBatchSize(this.wBatchSize.getText());
        m.setBatchDuration(this.wBatchDuration.getText());
        m.setSubTransform(this.wSubTransform.getText());
        this.setTopicsFromTable();
        m.setConsumerGroup(this.wConsumerGroup.getText());
        m.setDirectBootstrapServers(this.wBootstrapServers.getText());
        m.setAutoCommit(this.wbAutoCommit.getSelection());
        this.setFieldsFromTable();
        this.setOptionsFromTable();
    }

    protected String getDialogTitle() {
        return BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Shell.Title", (String[])new String[0]);
    }

    protected void createAdditionalTabs() {
        this.buildFieldsTab();
        this.buildOptionsTab();
        this.buildOffsetManagement();
    }

    private void buildOffsetManagement() {
        Group wOffsetGroup = new Group(this.wBatchComp, 16);
        wOffsetGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OffsetManagement", (String[])new String[0]));
        FormLayout flOffsetGroup = new FormLayout();
        flOffsetGroup.marginHeight = 15;
        flOffsetGroup.marginWidth = 15;
        wOffsetGroup.setLayout((Layout)flOffsetGroup);
        FormData fdOffsetGroup = new FormData();
        fdOffsetGroup.top = new FormAttachment((Control)this.wBatchSize, 15);
        fdOffsetGroup.left = new FormAttachment(0, 0);
        fdOffsetGroup.right = new FormAttachment(100, 0);
        wOffsetGroup.setLayoutData((Object)fdOffsetGroup);
        PropsUi.setLook((Widget)wOffsetGroup);
        this.wbAutoCommit = new Button((Composite)wOffsetGroup, 16);
        this.wbAutoCommit.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.AutoOffset", (String[])new String[0]));
        FormData fdbAutoCommit = new FormData();
        fdbAutoCommit.top = new FormAttachment(0, 0);
        fdbAutoCommit.left = new FormAttachment(this.middle, 0);
        this.wbAutoCommit.setLayoutData((Object)fdbAutoCommit);
        PropsUi.setLook((Widget)this.wbAutoCommit);
        this.wbManualCommit = new Button((Composite)wOffsetGroup, 16);
        this.wbManualCommit.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.ManualOffset", (String[])new String[0]));
        FormData fdbManualCommit = new FormData();
        fdbManualCommit.left = new FormAttachment(this.middle, 0);
        fdbManualCommit.top = new FormAttachment((Control)this.wbAutoCommit, this.margin);
        this.wbManualCommit.setLayoutData((Object)fdbManualCommit);
        PropsUi.setLook((Widget)this.wbManualCommit);
    }

    protected void buildSetup(Composite wSetupComp) {
        PropsUi.setLook((Widget)wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        wSetupComp.setLayout((Layout)setupLayout);
        Label wlBootstrapServers = new Label(wSetupComp, 131072);
        PropsUi.setLook((Widget)wlBootstrapServers);
        wlBootstrapServers.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BootstrapServers", (String[])new String[0]));
        FormData fdlBootstrapServers = new FormData();
        fdlBootstrapServers.left = new FormAttachment(0, 0);
        fdlBootstrapServers.top = new FormAttachment(0, 0);
        fdlBootstrapServers.right = new FormAttachment(this.middle, -this.margin);
        wlBootstrapServers.setLayoutData((Object)fdlBootstrapServers);
        this.wBootstrapServers = new TextVar(this.variables, wSetupComp, 18436);
        PropsUi.setLook((Widget)this.wBootstrapServers);
        this.wBootstrapServers.addModifyListener(this.lsMod);
        FormData fdBootstrapServers = new FormData();
        fdBootstrapServers.left = new FormAttachment((Control)wlBootstrapServers, this.margin);
        fdBootstrapServers.top = new FormAttachment((Control)wlBootstrapServers, 0, 0x1000000);
        fdBootstrapServers.right = new FormAttachment(100, 0);
        this.wBootstrapServers.setLayoutData((Object)fdBootstrapServers);
        Label wlTopic = new Label(wSetupComp, 16384);
        PropsUi.setLook((Widget)wlTopic);
        wlTopic.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Topics", (String[])new String[0]));
        FormData fdlTopic = new FormData();
        fdlTopic.left = new FormAttachment(0, 0);
        fdlTopic.top = new FormAttachment((Control)this.wBootstrapServers, 3 * PropsUi.getMargin());
        fdlTopic.right = new FormAttachment(this.props.getMiddlePct(), 0);
        wlTopic.setLayoutData((Object)fdlTopic);
        this.wConsumerGroup = new TextVar(this.variables, wSetupComp, 18436);
        PropsUi.setLook((Widget)this.wConsumerGroup);
        this.wConsumerGroup.addModifyListener(this.lsMod);
        FormData fdConsumerGroup = new FormData();
        fdConsumerGroup.right = new FormAttachment(100, 0);
        fdConsumerGroup.bottom = new FormAttachment(100, 0);
        this.wConsumerGroup.setLayoutData((Object)fdConsumerGroup);
        Label wlConsumerGroup = new Label(wSetupComp, 131072);
        PropsUi.setLook((Widget)wlConsumerGroup);
        wlConsumerGroup.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.ConsumerGroup", (String[])new String[0]));
        FormData fdlConsumerGroup = new FormData();
        fdlConsumerGroup.left = new FormAttachment(0, 0);
        fdlConsumerGroup.top = new FormAttachment((Control)this.wConsumerGroup, 0, 0x1000000);
        fdlConsumerGroup.right = new FormAttachment(this.middle, -this.margin);
        wlConsumerGroup.setLayoutData((Object)fdlConsumerGroup);
        fdConsumerGroup.left = new FormAttachment((Control)wlConsumerGroup, this.margin);
        this.buildTopicsTable(wSetupComp, (Control)wlTopic, (Control)wlConsumerGroup);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        wSetupComp.setLayoutData((Object)fdSetupComp);
        wSetupComp.layout();
        this.wSetupTab.setControl((Control)wSetupComp);
    }

    private void buildFieldsTab() {
        CTabItem wFieldsTab = new CTabItem(this.wTabFolder, 0, 2);
        wFieldsTab.setFont(GuiResource.getInstance().getFontDefault());
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.FieldsTab", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wFieldsComp.setLayout((Layout)fieldsLayout);
        FormData fieldsFormData = new FormData();
        fieldsFormData.left = new FormAttachment(0, 0);
        fieldsFormData.top = new FormAttachment((Control)wFieldsComp, 0);
        fieldsFormData.right = new FormAttachment(100, 0);
        fieldsFormData.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fieldsFormData);
        this.buildFieldTable(wFieldsComp, (Control)wFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
    }

    private void buildOptionsTab() {
        CTabItem wOptionsTab = new CTabItem(this.wTabFolder, 0);
        wOptionsTab.setFont(GuiResource.getInstance().getFontDefault());
        wOptionsTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.OptionsTab", (String[])new String[0]));
        Composite wOptionsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)wOptionsComp);
        FormLayout fieldsLayout = new FormLayout();
        fieldsLayout.marginHeight = 15;
        fieldsLayout.marginWidth = 15;
        wOptionsComp.setLayout((Layout)fieldsLayout);
        FormData optionsFormData = new FormData();
        optionsFormData.left = new FormAttachment(0, 0);
        optionsFormData.top = new FormAttachment((Control)wOptionsComp, 0);
        optionsFormData.right = new FormAttachment(100, 0);
        optionsFormData.bottom = new FormAttachment(100, 0);
        wOptionsComp.setLayoutData((Object)optionsFormData);
        this.buildOptionsTable(wOptionsComp);
        wOptionsComp.layout();
        wOptionsTab.setControl((Control)wOptionsComp);
    }

    private void buildFieldTable(Composite parentWidget, Control relativePosition) {
        ColumnInfo[] columns = this.getFieldColumns();
        int fieldCount = KafkaConsumerField.Name.values().length;
        this.fieldsTable = new TableView(this.variables, parentWidget, 67586, columns, fieldCount, true, this.lsMod, this.props, false);
        this.fieldsTable.setSortable(false);
        this.populateFieldData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(relativePosition, 5);
        fdData.right = new FormAttachment(100, 0);
        this.fieldsTable.setLayoutData((Object)fdData);
        this.fieldsTable.setReadonly(true);
    }

    private void buildOptionsTable(Composite parentWidget) {
        ColumnInfo[] columns = this.getOptionsColumns();
        if (this.meta.getConfig().isEmpty()) {
            List<String> list = KafkaDialogHelper.getConsumerAdvancedConfigOptionNames();
            LinkedHashMap<String, String> advancedConfig = new LinkedHashMap<String, String>();
            for (String item : list) {
                advancedConfig.put(item, DEFAULT_OPTION_VALUES.getOrDefault(item, ""));
            }
            this.meta.setConfig(advancedConfig);
        }
        int fieldCount = this.meta.getConfig().size();
        this.optionsTable = new TableView(this.variables, parentWidget, 67586, columns, fieldCount, false, this.lsMod, this.props, false);
        this.optionsTable.setSortable(false);
        this.populateOptionsData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(0, 0);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(100, 0);
        this.optionsTable.setLayoutData((Object)fdData);
    }

    private void buildSetupTab() {
        this.wSetupTab = new CTabItem(this.wTabFolder, 0);
        this.wSetupTab.setFont(GuiResource.getInstance().getFontDefault());
        this.wSetupTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.SetupTab", (String[])new String[0]));
        this.wSetupComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)this.wSetupComp);
        FormLayout setupLayout = new FormLayout();
        setupLayout.marginHeight = 15;
        setupLayout.marginWidth = 15;
        this.wSetupComp.setLayout((Layout)setupLayout);
        this.buildSetup(this.wSetupComp);
        FormData fdSetupComp = new FormData();
        fdSetupComp.left = new FormAttachment(0, 0);
        fdSetupComp.top = new FormAttachment(0, 0);
        fdSetupComp.right = new FormAttachment(100, 0);
        fdSetupComp.bottom = new FormAttachment(100, 0);
        this.wSetupComp.setLayoutData((Object)fdSetupComp);
        this.wSetupComp.layout();
        this.wSetupTab.setControl((Control)this.wSetupComp);
    }

    private void buildBatchTab() {
        this.wBatchTab = new CTabItem(this.wTabFolder, 0);
        this.wBatchTab.setFont(GuiResource.getInstance().getFontDefault());
        this.wBatchTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BatchTab", (String[])new String[0]));
        this.wBatchComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)this.wBatchComp);
        FormLayout batchLayout = new FormLayout();
        batchLayout.marginHeight = 15;
        batchLayout.marginWidth = 15;
        this.wBatchComp.setLayout((Layout)batchLayout);
        FormData fdBatchComp = new FormData();
        fdBatchComp.left = new FormAttachment(0, 0);
        fdBatchComp.top = new FormAttachment(0, 0);
        fdBatchComp.right = new FormAttachment(100, 0);
        fdBatchComp.bottom = new FormAttachment(100, 0);
        this.wBatchComp.setLayoutData((Object)fdBatchComp);
        this.wlBatchDuration = new Label(this.wBatchComp, 131072);
        PropsUi.setLook((Widget)this.wlBatchDuration);
        this.wlBatchDuration.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BatchDuration", (String[])new String[0]));
        FormData fdlBatchDuration = new FormData();
        fdlBatchDuration.left = new FormAttachment(0, 0);
        fdlBatchDuration.top = new FormAttachment(0, 0);
        fdlBatchDuration.right = new FormAttachment(this.middle, -this.margin);
        this.wlBatchDuration.setLayoutData((Object)fdlBatchDuration);
        this.wBatchDuration = new TextVar(this.variables, this.wBatchComp, 18436);
        PropsUi.setLook((Widget)this.wBatchDuration);
        this.wBatchDuration.addModifyListener(this.lsMod);
        FormData fdBatchDuration = new FormData();
        fdBatchDuration.left = new FormAttachment((Control)this.wlBatchDuration, this.margin);
        fdBatchDuration.right = new FormAttachment(100, 0);
        fdBatchDuration.top = new FormAttachment((Control)this.wlBatchDuration, 0, 0x1000000);
        this.wBatchDuration.setLayoutData((Object)fdBatchDuration);
        this.wlBatchSize = new Label(this.wBatchComp, 131072);
        PropsUi.setLook((Widget)this.wlBatchSize);
        this.wlBatchSize.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.BatchSize", (String[])new String[0]));
        FormData fdlBatchSize = new FormData();
        fdlBatchSize.left = new FormAttachment(0, 0);
        fdlBatchSize.top = new FormAttachment((Control)this.wBatchDuration, this.margin);
        fdlBatchSize.right = new FormAttachment(this.middle, -this.margin);
        this.wlBatchSize.setLayoutData((Object)fdlBatchSize);
        this.wBatchSize = new TextVar(this.variables, this.wBatchComp, 18436);
        PropsUi.setLook((Widget)this.wBatchSize);
        this.wBatchSize.addModifyListener(this.lsMod);
        FormData fdBatchSize = new FormData();
        fdBatchSize.left = new FormAttachment((Control)this.wlBatchSize, this.margin);
        fdBatchSize.right = new FormAttachment(100, 0);
        fdBatchSize.top = new FormAttachment((Control)this.wlBatchSize, 0, 0x1000000);
        this.wBatchSize.setLayoutData((Object)fdBatchSize);
        this.wBatchComp.layout();
        this.wBatchTab.setControl((Control)this.wBatchComp);
    }

    private void buildResultsTab() {
        this.wResultsTab = new CTabItem(this.wTabFolder, 0);
        this.wResultsTab.setFont(GuiResource.getInstance().getFontDefault());
        this.wResultsTab.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.ResultsTab", (String[])new String[0]));
        this.wResultsComp = new Composite((Composite)this.wTabFolder, 0);
        PropsUi.setLook((Widget)this.wResultsComp);
        FormLayout resultsLayout = new FormLayout();
        resultsLayout.marginHeight = 15;
        resultsLayout.marginWidth = 15;
        this.wResultsComp.setLayout((Layout)resultsLayout);
        FormData fdResultsComp = new FormData();
        fdResultsComp.left = new FormAttachment(0, 0);
        fdResultsComp.top = new FormAttachment(0, 0);
        fdResultsComp.right = new FormAttachment(100, 0);
        fdResultsComp.bottom = new FormAttachment(100, 0);
        this.wResultsComp.setLayoutData((Object)fdResultsComp);
        this.wlSubTransform = new Label(this.wResultsComp, 131072);
        PropsUi.setLook((Widget)this.wlSubTransform);
        FormData fdlSubTrans = new FormData();
        fdlSubTrans.left = new FormAttachment(0, 0);
        fdlSubTrans.top = new FormAttachment(0, 0);
        fdlSubTrans.right = new FormAttachment(this.middle, -this.margin);
        this.wlSubTransform.setLayoutData((Object)fdlSubTrans);
        this.wlSubTransform.setText(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Pipeline.SubPipelineTransform", (String[])new String[0]));
        this.wSubTransform = new ComboVar(this.variables, this.wResultsComp, 18436);
        PropsUi.setLook((Widget)this.wSubTransform);
        FormData fdSubTransform = new FormData();
        fdSubTransform.left = new FormAttachment((Control)this.wlSubTransform, this.margin);
        fdSubTransform.right = new FormAttachment(100, 0);
        fdSubTransform.top = new FormAttachment((Control)this.wlSubTransform, 0, 0x1000000);
        this.wSubTransform.setLayoutData((Object)fdSubTransform);
        this.wSubTransform.getCComboWidget().addListener(15, this::populateSubTransforms);
        this.wResultsComp.layout();
        this.wResultsTab.setControl((Control)this.wResultsComp);
    }

    private ColumnInfo[] getFieldColumns() {
        KafkaConsumerField.Type[] values = KafkaConsumerField.Type.values();
        String[] supportedTypes = (String[])Arrays.stream(values).map(KafkaConsumerField.Type::toString).toArray(String[]::new);
        ColumnInfo referenceName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Ref", (String[])new String[0]), 1, false, true);
        ColumnInfo name = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Name", (String[])new String[0]), 1, false, false);
        ColumnInfo type = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Type", (String[])new String[0]), 2, supportedTypes, false);
        type.setDisabledListener(rowNumber -> {
            String ref = this.fieldsTable.getTable().getItem(rowNumber).getText(1);
            KafkaConsumerField.Name refName = KafkaConsumerField.Name.valueOf(ref.toUpperCase());
            return refName != KafkaConsumerField.Name.KEY && refName != KafkaConsumerField.Name.MESSAGE;
        });
        return new ColumnInfo[]{referenceName, name, type};
    }

    private ColumnInfo[] getOptionsColumns() {
        ColumnInfo optionName = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.NameField", (String[])new String[0]), 1, false, false);
        ColumnInfo value = new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.Column.Value", (String[])new String[0]), 1, false, false);
        value.setUsingVariables(true);
        return new ColumnInfo[]{optionName, value};
    }

    private void populateFieldData() {
        List<KafkaConsumerField> fieldDefinitions = this.meta.getFieldDefinitions();
        int rowIndex = 0;
        for (KafkaConsumerField field : fieldDefinitions) {
            TableItem key = this.fieldsTable.getTable().getItem(rowIndex++);
            key.setText(1, Const.NVL((String)field.getKafkaName().toString(), (String)""));
            key.setText(2, Const.NVL((String)field.getOutputName(), (String)""));
            key.setText(3, Const.NVL((String)field.getOutputType().toString(), (String)""));
        }
    }

    private void populateOptionsData() {
        int rowIndex = 0;
        for (Map.Entry<String, String> entry : this.meta.getConfig().entrySet()) {
            TableItem key = this.optionsTable.getTable().getItem(rowIndex++);
            key.setText(1, entry.getKey());
            key.setText(2, entry.getValue());
        }
    }

    private void populateTopicsData() {
        List<String> topics = this.meta.getTopics();
        int rowIndex = 0;
        for (String topic : topics) {
            TableItem key = this.topicsTable.getTable().getItem(rowIndex++);
            if (topic == null) continue;
            key.setText(1, topic);
        }
    }

    private void buildTopicsTable(Composite parentWidget, Control controlAbove, Control controlBelow) {
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"KafkaConsumerInputDialog.NameField", (String[])new String[0]), 2, new String[1], false)};
        columns[0].setUsingVariables(true);
        int topicsCount = this.meta.getTopics().size();
        Listener lsFocusInTopic = e -> {
            CCombo comboWidget = (CCombo)e.widget;
            ComboVar topicsCombo = (ComboVar)comboWidget.getParent();
            KafkaDialogHelper kdh = new KafkaDialogHelper(this.variables, topicsCombo, this.wBootstrapServers, this.kafkaFactory, this.optionsTable, this.meta.getParentTransformMeta());
            kdh.clusterNameChanged(e);
        };
        this.topicsTable = new TableView(this.variables, parentWidget, 67586, columns, topicsCount, false, this.lsMod, this.props, true, lsFocusInTopic);
        this.topicsTable.setSortable(false);
        this.populateTopicsData();
        FormData fdData = new FormData();
        fdData.left = new FormAttachment(0, 0);
        fdData.top = new FormAttachment(controlAbove, 5);
        fdData.right = new FormAttachment(100, 0);
        fdData.bottom = new FormAttachment(controlBelow, -10, 128);
        this.topicsTable.setLayoutData((Object)fdData);
        this.topicsTable.optimizeTableView();
    }

    protected void getData() {
        this.wFilename.setText(Const.NVL((String)this.meta.getFilename(), (String)""));
        this.wLocation.setText(Const.NVL((String)this.meta.getExecutionInformationLocation(), (String)""));
        this.wProfile.setText(Const.NVL((String)this.meta.getExecutionDataProfile(), (String)""));
        this.wBootstrapServers.setText(Const.NVL((String)this.meta.getDirectBootstrapServers(), (String)""));
        this.populateTopicsData();
        this.wSubTransform.setText(Const.NVL((String)this.meta.getSubTransform(), (String)""));
        this.wConsumerGroup.setText(Const.NVL((String)this.meta.getConsumerGroup(), (String)""));
        this.wBatchSize.setText(Const.NVL((String)this.meta.getBatchSize(), (String)""));
        this.wBatchDuration.setText(Const.NVL((String)this.meta.getBatchDuration(), (String)""));
        this.wbAutoCommit.setSelection(this.meta.isAutoCommit());
        this.wbManualCommit.setSelection(!this.meta.isAutoCommit());
        this.populateFieldData();
        this.fieldsTable.optimizeTableView();
        this.topicsTable.optimizeTableView();
        this.optionsTable.optimizeTableView();
    }

    private void cancel() {
        this.meta.setChanged(false);
        this.dispose();
    }

    private void setFieldsFromTable() {
        int itemCount = this.fieldsTable.getItemCount();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = this.fieldsTable.getTable().getItem(rowIndex);
            String kafkaName = row.getText(1);
            String outputName = row.getText(2);
            String outputType = row.getText(3);
            try {
                KafkaConsumerField.Name ref = KafkaConsumerField.Name.valueOf(kafkaName.toUpperCase());
                KafkaConsumerField field = new KafkaConsumerField(ref, outputName, KafkaConsumerField.Type.valueOf(outputType));
                this.meta.setField(field);
                continue;
            }
            catch (IllegalArgumentException e) {
                if (!this.isDebug()) continue;
                this.logDebug(e.getMessage(), new Object[]{e});
            }
        }
    }

    private void setTopicsFromTable() {
        int itemCount = this.topicsTable.getItemCount();
        ArrayList<String> tableTopics = new ArrayList<String>();
        for (int rowIndex = 0; rowIndex < itemCount; ++rowIndex) {
            TableItem row = this.topicsTable.getTable().getItem(rowIndex);
            String topic = row.getText(1);
            if ("".equals(topic) || tableTopics.indexOf(topic) != -1) continue;
            tableTopics.add(topic);
        }
        this.meta.setTopics(tableTopics);
    }

    private void setOptionsFromTable() {
        this.meta.setConfig(KafkaDialogHelper.getConfig(this.optionsTable));
    }

    protected String[] getFieldNames() {
        return (String[])Arrays.stream(this.fieldsTable.getTable().getItems()).map(row -> row.getText(2)).toArray(String[]::new);
    }

    protected int[] getFieldTypes() {
        return Arrays.stream(this.fieldsTable.getTable().getItems()).mapToInt(row -> ValueMetaFactory.getIdForValueMeta((String)row.getText(3))).toArray();
    }

    protected void createNewKafkaPipeline() {
        PipelineMeta kafkaPipelineMeta = this.createSubPipelineMeta();
        try {
            HopGui.getExplorerPerspective().addPipeline(kafkaPipelineMeta);
            HopGui.getExplorerPerspective().activate();
            String filename = this.hopGui.fileDelegate.fileSaveAs();
            if (StringUtils.isNotEmpty((String)filename)) {
                HopGui.getInstance().getDisplay().asyncExec(() -> this.wFilename.setText(filename));
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error adding new Kafka pipeline", e);
        }
    }

    protected PipelineMeta createSubPipelineMeta() {
        InjectorMeta injectorMeta = new InjectorMeta();
        String[] fieldNames = this.getFieldNames();
        int[] fieldTypes = this.getFieldTypes();
        for (int i = 0; i < fieldNames.length; ++i) {
            InjectorField field = new InjectorField(fieldNames[i], ValueMetaFactory.getValueMetaName((int)fieldTypes[i]), "", "");
            injectorMeta.getInjectorFields().add(field);
        }
        TransformMeta recsFromStream = new TransformMeta("RecordsFromStream", "Get messages from Kafka", (ITransformMeta)injectorMeta);
        recsFromStream.setLocation(new Point(100, 100));
        PipelineMeta pipelineMeta = new PipelineMeta();
        pipelineMeta.addTransform(recsFromStream);
        pipelineMeta.setFilename("");
        return pipelineMeta;
    }

    private PipelineMeta loadKafkaPipelineMeta() throws HopException {
        KafkaConsumerInputMeta copyMeta = this.meta.clone();
        this.updateMeta(copyMeta);
        return TransformWithMappingMeta.loadMappingMeta((TransformWithMappingMeta)copyMeta, (IHopMetadataProvider)this.getMetadataProvider(), (IVariables)this.variables);
    }

    protected void populateSubTransforms(Event event) {
        try {
            String current = this.wSubTransform.getText();
            this.wSubTransform.removeAll();
            Optional.ofNullable(this.loadKafkaPipelineMeta()).ifPresent(pipelineMeta -> pipelineMeta.getTransforms().stream().map(TransformMeta::getName).sorted().forEach(arg_0 -> ((ComboVar)this.wSubTransform).add(arg_0)));
            HopGui.getInstance().getDisplay().asyncExec(() -> this.wSubTransform.setText(current));
        }
        catch (HopException e) {
            this.log.logError("Error getting transform names from Kafka pipeline", (Throwable)e);
        }
    }

    private boolean isSelfReferencing() {
        return this.variables.resolve(this.wFilename.getText()).equals(this.variables.resolve(this.pipelineMeta.getFilename()));
    }
}

