/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.redshift.bulkloader;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.Const;
import org.apache.hop.core.DbCache;
import org.apache.hop.core.SourceToTargetMapping;
import org.apache.hop.core.SqlStatement;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.util.StringUtil;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoaderField;
import org.apache.hop.pipeline.transforms.redshift.bulkloader.RedshiftBulkLoaderMeta;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.database.dialog.DatabaseExplorerDialog;
import org.apache.hop.ui.core.database.dialog.SqlEditor;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterMappingDialog;
import org.apache.hop.ui.core.dialog.EnterSelectionDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.ComboVar;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;

public class RedshiftBulkLoaderDialog
extends BaseTransformDialog {
    private static final Class<?> PKG = RedshiftBulkLoaderMeta.class;
    public static final String CONST_SYSTEM_DIALOG_ERROR_TITLE = "System.Dialog.Error.Title";
    private MetaSelectionLine<DatabaseMeta> wConnection;
    private Button wTruncate;
    private Button wOnlyWhenHaveRows;
    private TextVar wSchema;
    private TextVar wTable;
    private Button wStreamToS3Csv;
    private ComboVar wLoadFromExistingFileFormat;
    private TextVar wCopyFromFilename;
    private Button wSpecifyFields;
    private TableView wFields;
    private Button wGetFields;
    private Button wDoMapping;
    private RedshiftBulkLoaderMeta input;
    private Map<String, Integer> inputFields;
    private ColumnInfo[] ciFields;
    private static final String AWS_CREDENTIALS = "Credentials";
    private static final String AWS_IAM_ROLE = "IAM Role";
    private String[] awsAuthOptions = new String[]{"Credentials", "IAM Role"};
    private Label wlAwsAuthType;
    private ComboVar wAwsAuthType;
    private Label wlUseSystemVars;
    private Button wUseSystemVars;
    private Label wlAccessKeyId;
    private TextVar wAccessKeyId;
    private Label wlSecretAccessKey;
    private TextVar wSecretAccessKey;
    private Label wlAwsIamRole;
    private TextVar wAwsIamRole;
    private List<ColumnInfo> tableFieldColumns = new ArrayList<ColumnInfo>();

    public RedshiftBulkLoaderDialog(Shell parent, IVariables variables, RedshiftBulkLoaderMeta transformMeta, PipelineMeta pipelineMeta) {
        super(parent, variables, (ITransformMeta)transformMeta, pipelineMeta);
        this.input = transformMeta;
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        PropsUi.setLook((Widget)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        FocusAdapter lsFocusLost = new FocusAdapter(){

            public void focusLost(FocusEvent arg0) {
                RedshiftBulkLoaderDialog.this.setTableFieldCombo();
            }
        };
        this.backupChanged = this.input.hasChanged();
        int middle = this.props.getMiddlePct();
        int margin = 4;
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DialogTitle", (String[])new String[0]));
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.TransformName.Label", (String[])new String[0]));
        this.wlTransformName.setToolTipText(BaseMessages.getString(PKG, (String)"System.TransformName.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin * 2);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        PropsUi.setLook((Widget)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin * 2);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        DatabaseMeta dbm = this.pipelineMeta.findDatabase(this.input.getConnection(), this.variables);
        this.wConnection = this.addConnectionLine((Composite)this.shell, (Control)this.wTransformName, this.input.getDatabaseMeta(), null);
        if (this.input.getDatabaseMeta() == null && this.pipelineMeta.nrDatabases() == 1) {
            this.wConnection.select(0);
        }
        this.wConnection.addModifyListener(lsMod);
        TextVar lastControl = this.wConnection;
        Label wlSchema = new Label((Composite)this.shell, 131072);
        wlSchema.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.TargetSchema.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSchema);
        FormData fdlSchema = new FormData();
        fdlSchema.left = new FormAttachment(0, 0);
        fdlSchema.right = new FormAttachment(middle, -margin);
        fdlSchema.top = new FormAttachment(lastControl, margin * 2);
        wlSchema.setLayoutData((Object)fdlSchema);
        Button wbSchema = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbSchema);
        wbSchema.setText(BaseMessages.getString((String)"System.Button.Browse"));
        FormData fdbSchema = new FormData();
        fdbSchema.right = new FormAttachment(100, 0);
        fdbSchema.top = new FormAttachment(lastControl, margin * 2);
        wbSchema.setLayoutData((Object)fdbSchema);
        this.wSchema = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wSchema);
        this.wSchema.addModifyListener(lsMod);
        this.wSchema.addFocusListener((FocusListener)lsFocusLost);
        FormData fdSchema = new FormData();
        fdSchema.left = new FormAttachment(middle, 0);
        fdSchema.top = new FormAttachment(lastControl, margin * 2);
        fdSchema.right = new FormAttachment((Control)wbSchema, -margin);
        this.wSchema.setLayoutData((Object)fdSchema);
        lastControl = this.wSchema;
        Label wlTable = new Label((Composite)this.shell, 131072);
        wlTable.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.TargetTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTable);
        FormData fdlTable = new FormData();
        fdlTable.left = new FormAttachment(0, 0);
        fdlTable.right = new FormAttachment(middle, -margin);
        fdlTable.top = new FormAttachment((Control)lastControl, margin);
        wlTable.setLayoutData((Object)fdlTable);
        Button wbTable = new Button((Composite)this.shell, 0x1000008);
        PropsUi.setLook((Widget)wbTable);
        wbTable.setText(BaseMessages.getString((String)"System.Button.Browse"));
        FormData fdbTable = new FormData();
        fdbTable.right = new FormAttachment(100, 0);
        fdbTable.top = new FormAttachment((Control)lastControl, margin);
        wbTable.setLayoutData((Object)fdbTable);
        this.wTable = new TextVar(this.variables, (Composite)this.shell, 18436);
        PropsUi.setLook((Widget)this.wTable);
        this.wTable.addModifyListener(lsMod);
        this.wTable.addFocusListener((FocusListener)lsFocusLost);
        FormData fdTable = new FormData();
        fdTable.top = new FormAttachment((Control)lastControl, margin);
        fdTable.left = new FormAttachment(middle, 0);
        fdTable.right = new FormAttachment((Control)wbTable, -margin);
        this.wTable.setLayoutData((Object)fdTable);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString((String)"System.Button.OK"));
        this.wCreate = new Button((Composite)this.shell, 8);
        this.wCreate.setText(BaseMessages.getString((String)"System.Button.SQL"));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString((String)"System.Button.Cancel"));
        lastControl = this.wTable;
        CTabFolder wTabFolder = new CTabFolder((Composite)this.shell, 2048);
        PropsUi.setLook((Widget)wTabFolder, (int)4);
        this.addGeneralTab(wTabFolder, margin, middle, lsMod, (FocusListener)lsFocusLost);
        this.addAwsAuthenticationTab(wTabFolder, margin, middle, lsMod);
        this.addFieldsTab(wTabFolder, margin, middle, lsMod);
        FormData fdTabFolder = new FormData();
        fdTabFolder.left = new FormAttachment(0, 0);
        fdTabFolder.top = new FormAttachment((Control)lastControl, 2 * margin);
        fdTabFolder.right = new FormAttachment(100, 0);
        fdTabFolder.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        wTabFolder.setLayoutData((Object)fdTabFolder);
        wTabFolder.setSelection(0);
        this.setButtonPositions(new Button[]{this.wOk, this.wCancel, this.wCreate}, margin, null);
        this.wOk.addListener(13, c -> this.ok());
        this.wCancel.addListener(13, c -> this.cancel());
        this.wCreate.addListener(13, c -> this.sql());
        this.wGetFields.addListener(13, c -> this.get());
        wbTable.addListener(13, c -> this.getTableName());
        this.setSize();
        this.getData();
        this.setTableFieldCombo();
        this.input.setChanged(this.backupChanged);
        this.toggleSpecifyFieldsFlags();
        this.toggleKeysSelection();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void addGeneralTab(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod, FocusListener lsFocusLost) {
        CTabItem wGeneralTab = new CTabItem(wTabFolder, 0);
        wGeneralTab.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.GeneralTab.Label", (String[])new String[0]));
        FormLayout generalLayout = new FormLayout();
        generalLayout.marginWidth = 3;
        generalLayout.marginHeight = 3;
        Composite wGeneralComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wGeneralComp);
        wGeneralComp.setLayout((Layout)generalLayout);
        Label wlTruncate = new Label(wGeneralComp, 131072);
        wlTruncate.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.TruncateTable.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlTruncate);
        FormData fdlTruncate = new FormData();
        fdlTruncate.top = new FormAttachment(0, margin);
        fdlTruncate.left = new FormAttachment(0, 0);
        fdlTruncate.right = new FormAttachment(middle, -margin);
        wlTruncate.setLayoutData((Object)fdlTruncate);
        this.wTruncate = new Button(wGeneralComp, 32);
        PropsUi.setLook((Widget)this.wTruncate);
        FormData fdTruncate = new FormData();
        fdTruncate.top = new FormAttachment(0, margin);
        fdTruncate.left = new FormAttachment(middle, 0);
        fdTruncate.right = new FormAttachment(100, 0);
        this.wTruncate.setLayoutData((Object)fdTruncate);
        SelectionAdapter lsTruncMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RedshiftBulkLoaderDialog.this.input.setChanged();
            }
        };
        this.wTruncate.addSelectionListener((SelectionListener)lsTruncMod);
        this.wTruncate.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RedshiftBulkLoaderDialog.this.toggleSpecifyFieldsFlags();
            }
        });
        Label lastControl = wlTruncate;
        Label wlOnlyWhenHaveRows = new Label(wGeneralComp, 131072);
        wlOnlyWhenHaveRows.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.OnlyWhenHaveRows.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlOnlyWhenHaveRows);
        FormData fdlOnlyWhenHaveRows = new FormData();
        fdlOnlyWhenHaveRows.top = new FormAttachment((Control)lastControl, margin);
        fdlOnlyWhenHaveRows.left = new FormAttachment(0, 0);
        fdlOnlyWhenHaveRows.right = new FormAttachment(middle, -margin);
        wlOnlyWhenHaveRows.setLayoutData((Object)fdlOnlyWhenHaveRows);
        this.wOnlyWhenHaveRows = new Button(wGeneralComp, 32);
        PropsUi.setLook((Widget)this.wOnlyWhenHaveRows);
        FormData fdTruncateWhenHaveRows = new FormData();
        fdTruncateWhenHaveRows.top = new FormAttachment((Control)lastControl, margin);
        fdTruncateWhenHaveRows.left = new FormAttachment(middle, 0);
        fdTruncateWhenHaveRows.right = new FormAttachment(100, 0);
        this.wOnlyWhenHaveRows.setLayoutData((Object)fdTruncateWhenHaveRows);
        SelectionAdapter lsSelMod = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RedshiftBulkLoaderDialog.this.input.setChanged();
            }
        };
        this.wOnlyWhenHaveRows.addSelectionListener((SelectionListener)lsSelMod);
        lastControl = wlOnlyWhenHaveRows;
        Label wlSpecifyFields = new Label(wGeneralComp, 131072);
        wlSpecifyFields.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.SpecifyFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlSpecifyFields);
        FormData fdlSpecifyFields = new FormData();
        fdlSpecifyFields.top = new FormAttachment((Control)lastControl, margin);
        fdlSpecifyFields.left = new FormAttachment(0, 0);
        fdlSpecifyFields.right = new FormAttachment(middle, -margin);
        wlSpecifyFields.setLayoutData((Object)fdlSpecifyFields);
        this.wSpecifyFields = new Button(wGeneralComp, 32);
        PropsUi.setLook((Widget)this.wSpecifyFields);
        FormData fdSpecifyFields = new FormData();
        fdSpecifyFields.top = new FormAttachment((Control)lastControl, margin);
        fdSpecifyFields.left = new FormAttachment(middle, 0);
        fdSpecifyFields.right = new FormAttachment(100, 0);
        this.wSpecifyFields.setLayoutData((Object)fdSpecifyFields);
        this.wSpecifyFields.addSelectionListener((SelectionListener)lsSelMod);
        lastControl = wlSpecifyFields;
        this.wSpecifyFields.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                RedshiftBulkLoaderDialog.this.toggleSpecifyFieldsFlags();
            }
        });
        Label wlStreamToS3Csv = new Label(wGeneralComp, 131072);
        wlStreamToS3Csv.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.StreamCsvToS3.Label", (String[])new String[0]));
        wlStreamToS3Csv.setToolTipText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.StreamCsvToS3.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlStreamToS3Csv);
        FormData fdlStreamToS3Csv = new FormData();
        fdlStreamToS3Csv.top = new FormAttachment((Control)lastControl, margin);
        fdlStreamToS3Csv.left = new FormAttachment(0, 0);
        fdlStreamToS3Csv.right = new FormAttachment(middle, -margin);
        wlStreamToS3Csv.setLayoutData((Object)fdlStreamToS3Csv);
        this.wStreamToS3Csv = new Button(wGeneralComp, 32);
        this.wStreamToS3Csv.setToolTipText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.StreamCsvToS3.ToolTip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wStreamToS3Csv);
        FormData fdStreamToS3Csv = new FormData();
        fdStreamToS3Csv.top = new FormAttachment((Control)lastControl, margin);
        fdStreamToS3Csv.left = new FormAttachment(middle, 0);
        fdStreamToS3Csv.right = new FormAttachment(100, 0);
        this.wStreamToS3Csv.setLayoutData((Object)fdStreamToS3Csv);
        this.wStreamToS3Csv.setSelection(true);
        lastControl = wlStreamToS3Csv;
        this.wStreamToS3Csv.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (RedshiftBulkLoaderDialog.this.wStreamToS3Csv.getSelection()) {
                    RedshiftBulkLoaderDialog.this.wLoadFromExistingFileFormat.setText("");
                }
                RedshiftBulkLoaderDialog.this.wLoadFromExistingFileFormat.setEnabled(!RedshiftBulkLoaderDialog.this.wStreamToS3Csv.getSelection());
            }
        });
        Label wlLoadFromExistingFile = new Label(wGeneralComp, 131072);
        wlLoadFromExistingFile.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.LoadFromExistingFile.Label", (String[])new String[0]));
        wlLoadFromExistingFile.setToolTipText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.LoadFromExistingFile.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)wlLoadFromExistingFile);
        FormData fdlLoadFromExistingFile = new FormData();
        fdlLoadFromExistingFile.top = new FormAttachment((Control)lastControl, margin * 2);
        fdlLoadFromExistingFile.left = new FormAttachment(0, 0);
        fdlLoadFromExistingFile.right = new FormAttachment(middle, -margin);
        wlLoadFromExistingFile.setLayoutData((Object)fdlLoadFromExistingFile);
        this.wLoadFromExistingFileFormat = new ComboVar(this.variables, wGeneralComp, 2060);
        FormData fdLoadFromExistingFile = new FormData();
        fdLoadFromExistingFile.top = new FormAttachment((Control)lastControl, margin);
        fdLoadFromExistingFile.left = new FormAttachment(middle, 0);
        fdLoadFromExistingFile.right = new FormAttachment(100, 0);
        this.wLoadFromExistingFileFormat.setLayoutData((Object)fdLoadFromExistingFile);
        String[] fileFormats = new String[]{"CSV", "Parquet"};
        this.wLoadFromExistingFileFormat.setItems(fileFormats);
        lastControl = this.wLoadFromExistingFileFormat;
        Label wlCopyFromFile = new Label(wGeneralComp, 131072);
        wlCopyFromFile.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.CopyFromFile.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlCopyFromFile);
        FormData fdlCopyFromFile = new FormData();
        fdlCopyFromFile.top = new FormAttachment((Control)lastControl, margin);
        fdlCopyFromFile.left = new FormAttachment(0, 0);
        fdlCopyFromFile.right = new FormAttachment(middle, -margin);
        wlCopyFromFile.setLayoutData((Object)fdlCopyFromFile);
        this.wCopyFromFilename = new TextVar(this.variables, wGeneralComp, 18436);
        PropsUi.setLook((Widget)this.wCopyFromFilename);
        this.wCopyFromFilename.addModifyListener(lsMod);
        this.wCopyFromFilename.addFocusListener(lsFocusLost);
        this.wCopyFromFilename.getTextWidget().setMessage("s3://<FILENAME_IN_BUCKET>");
        FormData fdCopyFromFile = new FormData();
        fdCopyFromFile.top = new FormAttachment((Control)lastControl, margin);
        fdCopyFromFile.left = new FormAttachment(middle, 0);
        fdCopyFromFile.right = new FormAttachment(100, 0);
        this.wCopyFromFilename.setLayoutData((Object)fdCopyFromFile);
        FormData fdGeneralComp = new FormData();
        fdGeneralComp.left = new FormAttachment(0, 0);
        fdGeneralComp.top = new FormAttachment(0, 0);
        fdGeneralComp.right = new FormAttachment(100, 0);
        fdGeneralComp.bottom = new FormAttachment(100, 0);
        wGeneralComp.setLayoutData((Object)fdGeneralComp);
        wGeneralComp.layout();
        wGeneralTab.setControl((Control)wGeneralComp);
    }

    private void addAwsAuthenticationTab(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod) {
        CTabItem wAwsAuthTab = new CTabItem(wTabFolder, 0);
        wAwsAuthTab.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.AwsAuthTab.Label", (String[])new String[0]));
        Composite wAwsAuthComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wAwsAuthComp);
        FormLayout awsAuthCompLayout = new FormLayout();
        awsAuthCompLayout.marginWidth = 5;
        awsAuthCompLayout.marginHeight = 5;
        wAwsAuthComp.setLayout((Layout)awsAuthCompLayout);
        this.wlAwsAuthType = new Label(wAwsAuthComp, 131072);
        this.wlAwsAuthType.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.AuthenticationType.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAwsAuthType);
        FormData fdlAwsAuthType = new FormData();
        fdlAwsAuthType.top = new FormAttachment(0, margin);
        fdlAwsAuthType.left = new FormAttachment(0, 0);
        fdlAwsAuthType.right = new FormAttachment(middle, -margin);
        this.wlAwsAuthType.setLayoutData((Object)fdlAwsAuthType);
        this.wAwsAuthType = new ComboVar(this.variables, wAwsAuthComp, 2056);
        this.wAwsAuthType.setItems(this.awsAuthOptions);
        this.wAwsAuthType.setText(this.awsAuthOptions[0]);
        PropsUi.setLook((Widget)this.wAwsAuthType);
        FormData fdAwsAuthType = new FormData();
        fdAwsAuthType.top = new FormAttachment(0, margin);
        fdAwsAuthType.left = new FormAttachment(middle, 0);
        fdAwsAuthType.right = new FormAttachment(100, 0);
        this.wAwsAuthType.setLayoutData((Object)fdAwsAuthType);
        Label lastControl = this.wlAwsAuthType;
        this.wlUseSystemVars = new Label(wAwsAuthComp, 131072);
        this.wlUseSystemVars.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.Authenticate.UseSystemVars.Label", (String[])new String[0]));
        this.wlUseSystemVars.setToolTipText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.Authenticate.UseSystemVars.Tooltip", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlUseSystemVars);
        FormData fdlUseSystemVars = new FormData();
        fdlUseSystemVars.top = new FormAttachment((Control)lastControl, margin);
        fdlUseSystemVars.left = new FormAttachment(0, 0);
        fdlUseSystemVars.right = new FormAttachment(middle, -margin);
        this.wlUseSystemVars.setLayoutData((Object)fdlUseSystemVars);
        this.wUseSystemVars = new Button(wAwsAuthComp, 32);
        this.wUseSystemVars.setSelection(true);
        PropsUi.setLook((Widget)this.wUseSystemVars);
        FormData fdUseSystemVars = new FormData();
        fdUseSystemVars.top = new FormAttachment((Control)lastControl, margin);
        fdUseSystemVars.left = new FormAttachment(middle, 0);
        fdUseSystemVars.right = new FormAttachment(100, 0);
        this.wUseSystemVars.setLayoutData((Object)fdUseSystemVars);
        lastControl = this.wlUseSystemVars;
        this.wUseSystemVars.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RedshiftBulkLoaderDialog.this.toggleKeysSelection();
            }
        });
        this.wlAccessKeyId = new Label(wAwsAuthComp, 131072);
        this.wlAccessKeyId.setText("AWS_ACCESS_KEY_ID");
        PropsUi.setLook((Widget)this.wlAccessKeyId);
        FormData fdlAccessKeyId = new FormData();
        fdlAccessKeyId.top = new FormAttachment((Control)lastControl, margin);
        fdlAccessKeyId.left = new FormAttachment(0, 0);
        fdlAccessKeyId.right = new FormAttachment(middle, -margin);
        this.wlAccessKeyId.setLayoutData((Object)fdlAccessKeyId);
        this.wAccessKeyId = new TextVar(this.variables, wAwsAuthComp, 18436);
        PropsUi.setLook((Widget)this.wAccessKeyId);
        FormData fdUseAccessKeyId = new FormData();
        fdUseAccessKeyId.top = new FormAttachment((Control)lastControl, margin);
        fdUseAccessKeyId.left = new FormAttachment(middle, 0);
        fdUseAccessKeyId.right = new FormAttachment(100, 0);
        this.wAccessKeyId.setLayoutData((Object)fdUseAccessKeyId);
        this.wAccessKeyId.addModifyListener(lsMod);
        lastControl = this.wAccessKeyId;
        this.wlSecretAccessKey = new Label(wAwsAuthComp, 131072);
        this.wlSecretAccessKey.setText("AWS_SECRET_ACCESS_KEY");
        PropsUi.setLook((Widget)this.wlSecretAccessKey);
        FormData fdlSecretAccessKey = new FormData();
        fdlSecretAccessKey.top = new FormAttachment((Control)lastControl, margin);
        fdlSecretAccessKey.left = new FormAttachment(0, 0);
        fdlSecretAccessKey.right = new FormAttachment(middle, -margin);
        this.wlSecretAccessKey.setLayoutData((Object)fdlSecretAccessKey);
        this.wSecretAccessKey = new TextVar(this.variables, wAwsAuthComp, 0x404804);
        PropsUi.setLook((Widget)this.wSecretAccessKey);
        FormData fdSecretAccessKey = new FormData();
        fdSecretAccessKey.top = new FormAttachment((Control)lastControl, margin);
        fdSecretAccessKey.left = new FormAttachment(middle, 0);
        fdSecretAccessKey.right = new FormAttachment(100, 0);
        this.wSecretAccessKey.setLayoutData((Object)fdSecretAccessKey);
        this.wSecretAccessKey.addModifyListener(lsMod);
        lastControl = this.wSecretAccessKey;
        this.wlAwsIamRole = new Label(wAwsAuthComp, 131072);
        this.wlAwsIamRole.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.IamRole.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)this.wlAwsIamRole);
        FormData fdlIamRole = new FormData();
        fdlIamRole.top = new FormAttachment((Control)lastControl, margin);
        fdlIamRole.left = new FormAttachment(0, 0);
        fdlIamRole.right = new FormAttachment(middle, -margin);
        this.wlAwsIamRole.setLayoutData((Object)fdlIamRole);
        this.wAwsIamRole = new TextVar(this.variables, wAwsAuthComp, 18436);
        this.wAwsIamRole.getTextWidget().setMessage("arn:aws:iam::<aws-account-id>:role/<role-name>");
        PropsUi.setLook((Widget)this.wAwsIamRole);
        FormData fdIamRole = new FormData();
        fdIamRole.top = new FormAttachment((Control)lastControl, margin);
        fdIamRole.left = new FormAttachment(middle, 0);
        fdIamRole.right = new FormAttachment(100, 0);
        this.wAwsIamRole.setLayoutData((Object)fdIamRole);
        this.wAwsIamRole.addModifyListener(lsMod);
        this.wlAwsIamRole.setEnabled(false);
        this.wAwsIamRole.setEnabled(false);
        this.wAwsAuthType.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RedshiftBulkLoaderDialog.this.toggleAuthSelection();
            }
        });
        FormData fdAwsAuthComp = new FormData();
        fdAwsAuthComp.left = new FormAttachment(0, 0);
        fdAwsAuthComp.top = new FormAttachment(0, 0);
        fdAwsAuthComp.right = new FormAttachment(100, 0);
        fdAwsAuthComp.bottom = new FormAttachment(100, 0);
        wAwsAuthComp.setLayoutData((Object)fdAwsAuthComp);
        wAwsAuthComp.layout();
        wAwsAuthTab.setControl((Control)wAwsAuthComp);
    }

    private void addFieldsTab(CTabFolder wTabFolder, int margin, int middle, ModifyListener lsMod) {
        CTabItem wFieldsTab = new CTabItem(wTabFolder, 0);
        wFieldsTab.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.FieldsTab.Label", (String[])new String[0]));
        Composite wFieldsComp = new Composite((Composite)wTabFolder, 0);
        PropsUi.setLook((Widget)wFieldsComp);
        FormLayout fieldsCompLayout = new FormLayout();
        fieldsCompLayout.marginWidth = 5;
        fieldsCompLayout.marginHeight = 5;
        wFieldsComp.setLayout((Layout)fieldsCompLayout);
        Label wlFields = new Label(wFieldsComp, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.InsertFields.Label", (String[])new String[0]));
        PropsUi.setLook((Widget)wlFields);
        FormData fdlUpIns = new FormData();
        fdlUpIns.left = new FormAttachment(0, 0);
        fdlUpIns.top = new FormAttachment(0, margin);
        wlFields.setLayoutData((Object)fdlUpIns);
        int tableCols = 2;
        int upInsRows = this.input.getFields() != null && !this.input.getFields().equals(Collections.emptyList()) ? this.input.getFields().size() : 1;
        this.ciFields = new ColumnInfo[tableCols];
        this.ciFields[0] = new ColumnInfo(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.ColumnInfo.TableField", (String[])new String[0]), 2, new String[]{""}, false);
        this.ciFields[1] = new ColumnInfo(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.ColumnInfo.StreamField", (String[])new String[0]), 2, new String[]{""}, false);
        this.tableFieldColumns.add(this.ciFields[0]);
        this.wFields = new TableView(this.variables, wFieldsComp, 68354, this.ciFields, upInsRows, lsMod, this.props);
        this.wGetFields = new Button(wFieldsComp, 8);
        this.wGetFields.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.GetFields.Button", (String[])new String[0]));
        FormData fdGetFields = new FormData();
        fdGetFields.top = new FormAttachment((Control)wlFields, margin);
        fdGetFields.right = new FormAttachment(100, 0);
        this.wGetFields.setLayoutData((Object)fdGetFields);
        this.wDoMapping = new Button(wFieldsComp, 8);
        this.wDoMapping.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.Button", (String[])new String[0]));
        FormData fdDoMapping = new FormData();
        fdDoMapping.top = new FormAttachment((Control)this.wGetFields, margin);
        fdDoMapping.right = new FormAttachment(100, 0);
        this.wDoMapping.setLayoutData((Object)fdDoMapping);
        this.wDoMapping.addListener(13, arg0 -> this.generateMappings());
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment((Control)this.wDoMapping, -margin);
        fdFields.bottom = new FormAttachment(100, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getFieldsFromPrevious();
        FormData fdFieldsComp = new FormData();
        fdFieldsComp.left = new FormAttachment(0, 0);
        fdFieldsComp.top = new FormAttachment(0, 0);
        fdFieldsComp.right = new FormAttachment(100, 0);
        fdFieldsComp.bottom = new FormAttachment(100, 0);
        wFieldsComp.setLayoutData((Object)fdFieldsComp);
        wFieldsComp.layout();
        wFieldsTab.setControl((Control)wFieldsComp);
    }

    private void getFieldsFromPrevious() {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                TransformMeta transformMeta = RedshiftBulkLoaderDialog.this.pipelineMeta.findTransform(RedshiftBulkLoaderDialog.this.transformName);
                if (transformMeta != null) {
                    try {
                        IRowMeta row = RedshiftBulkLoaderDialog.this.pipelineMeta.getPrevTransformFields(RedshiftBulkLoaderDialog.this.variables, transformMeta);
                        for (int i = 0; i < row.size(); ++i) {
                            RedshiftBulkLoaderDialog.this.inputFields.put(row.getValueMeta(i).getName(), i);
                        }
                        RedshiftBulkLoaderDialog.this.setComboBoxes();
                    }
                    catch (HopException e) {
                        RedshiftBulkLoaderDialog.this.log.logError(this.toString(), new Object[]{BaseMessages.getString((String)"System.Dialog.GetFieldsFailed.Message")});
                    }
                }
            }
        };
        new Thread(runnable).start();
    }

    private void generateMappings() {
        EnterMappingDialog d;
        IRowMeta targetFields;
        IRowMeta sourceFields;
        try {
            sourceFields = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformMeta);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.UnableToFindSourceFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        this.input.setTablename(this.variables.resolve(this.wTable.getText()));
        ITransformMeta transformMeta = this.transformMeta.getTransform();
        if (StringUtils.isEmpty((String)this.input.getConnection())) {
            this.input.setConnection(this.wConnection.getText());
        }
        try {
            targetFields = transformMeta.getRequiredFields(this.variables);
        }
        catch (HopException e) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.UnableToFindTargetFields.Message", (String[])new String[0]), (Exception)((Object)e));
            return;
        }
        String[] inputNames = new String[sourceFields.size()];
        for (int i = 0; i < sourceFields.size(); ++i) {
            IValueMeta value = sourceFields.getValueMeta(i);
            inputNames[i] = value.getName();
        }
        List<SourceToTargetMapping> mappings = new ArrayList();
        StringBuffer missingSourceFields = new StringBuffer();
        StringBuffer missingTargetFields = new StringBuffer();
        int nrFields = this.wFields.nrNonEmpty();
        for (int i = 0; i < nrFields; ++i) {
            int targetIndex;
            TableItem item = this.wFields.getNonEmpty(i);
            String source = item.getText(2);
            String target = item.getText(1);
            int sourceIndex = sourceFields.indexOfValue(source);
            if (sourceIndex < 0) {
                missingSourceFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if ((targetIndex = targetFields.indexOfValue(target)) < 0) {
                missingTargetFields.append(Const.CR + "   " + source + " --> " + target);
            }
            if (sourceIndex < 0 || targetIndex < 0) continue;
            SourceToTargetMapping mapping = new SourceToTargetMapping(sourceIndex, targetIndex);
            mappings.add(mapping);
        }
        if (!missingSourceFields.isEmpty() || !missingTargetFields.isEmpty()) {
            boolean goOn;
            Object message = "";
            if (!missingSourceFields.isEmpty()) {
                message = (String)message + BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.SomeSourceFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            if (!missingTargetFields.isEmpty()) {
                message = (String)message + BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.SomeTargetFieldsNotFound", (String[])new String[]{missingSourceFields.toString()}) + Const.CR;
            }
            message = (String)message + Const.CR;
            message = (String)message + BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.SomeFieldsNotFoundContinue", (String[])new String[0]) + Const.CR;
            int answer = BaseDialog.openMessageBox((Shell)this.shell, (String)BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.DoMapping.SomeFieldsNotFoundTitle", (String[])new String[0]), (String)message, (int)196);
            boolean bl = goOn = (answer & 0x40) != 0;
            if (!goOn) {
                return;
            }
        }
        if ((mappings = (d = new EnterMappingDialog(this.shell, sourceFields.getFieldNames(), targetFields.getFieldNames(), mappings)).open()) != null) {
            this.wFields.table.removeAll();
            this.wFields.table.setItemCount(mappings.size());
            for (int i = 0; i < mappings.size(); ++i) {
                SourceToTargetMapping mapping = (SourceToTargetMapping)mappings.get(i);
                TableItem item = this.wFields.table.getItem(i);
                item.setText(2, sourceFields.getValueMeta(mapping.getSourcePosition()).getName());
                item.setText(1, targetFields.getValueMeta(mapping.getTargetPosition()).getName());
            }
            this.wFields.setRowNums();
            this.wFields.optWidth(true);
        }
    }

    private void setTableFieldCombo() {
        Runnable fieldLoader = () -> {
            block11: {
                DatabaseMeta databaseMeta;
                Iterator<ColumnInfo> iterator = this.tableFieldColumns.iterator();
                while (iterator.hasNext()) {
                    ColumnInfo fieldColumn;
                    ColumnInfo colInfo = fieldColumn = iterator.next();
                    colInfo.setComboValues(new String[0]);
                }
                if (!StringUtil.isEmpty((String)this.wTable.getText()) && (databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables)) != null) {
                    try (Database db = new Database(loggingObject, this.variables, databaseMeta);){
                        String[] fieldNames;
                        db.connect();
                        String schemaTable = databaseMeta.getQuotedSchemaTableCombination(this.variables, this.variables.resolve(this.wSchema.getText()), this.variables.resolve(this.wTable.getText()));
                        IRowMeta r = db.getTableFields(schemaTable);
                        if (null == r || null == (fieldNames = r.getFieldNames())) break block11;
                        Iterator<ColumnInfo> iterator2 = this.tableFieldColumns.iterator();
                        while (iterator2.hasNext()) {
                            ColumnInfo tableFieldColumn;
                            ColumnInfo colInfo = tableFieldColumn = iterator2.next();
                            colInfo.setComboValues(fieldNames);
                        }
                    }
                    catch (Exception e) {
                        Iterator<ColumnInfo> iterator3 = this.tableFieldColumns.iterator();
                        while (iterator3.hasNext()) {
                            ColumnInfo tableFieldColumn;
                            ColumnInfo colInfo = tableFieldColumn = iterator3.next();
                            colInfo.setComboValues(new String[0]);
                        }
                    }
                }
            }
        };
        this.shell.getDisplay().asyncExec(fieldLoader);
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        if (PropsUi.getInstance().isSortFieldByName()) {
            Const.sortStrings((String[])fieldNames);
        }
        this.ciFields[1].setComboValues(fieldNames);
    }

    public void toggleSpecifyFieldsFlags() {
        boolean specifyFields = this.wSpecifyFields.getSelection();
        this.wFields.setEnabled(specifyFields);
        this.wGetFields.setEnabled(specifyFields);
        this.wDoMapping.setEnabled(specifyFields);
    }

    public void getData() {
        if (!StringUtils.isEmpty((String)this.input.getConnection())) {
            this.wConnection.setText(this.input.getConnection());
        }
        if (!StringUtils.isEmpty((String)this.input.getSchemaName())) {
            this.wSchema.setText(this.input.getSchemaName());
        }
        if (!StringUtils.isEmpty((String)this.input.getTableName())) {
            this.wTable.setText(this.input.getTableName());
        }
        if (this.input.isUseCredentials()) {
            this.wAwsAuthType.setText(this.awsAuthOptions[0]);
            this.wUseSystemVars.setSelection(this.input.isUseSystemEnvVars());
            if (!this.input.isUseSystemEnvVars()) {
                if (!StringUtil.isEmpty((String)this.input.getAwsAccessKeyId())) {
                    this.wAccessKeyId.setText(this.input.getAwsAccessKeyId());
                }
                if (!StringUtils.isEmpty((String)this.input.getAwsSecretAccessKey())) {
                    this.wAccessKeyId.setText(this.input.getAwsSecretAccessKey());
                }
            }
        } else if (this.input.isUseAwsIamRole()) {
            this.wAwsAuthType.setText(this.awsAuthOptions[1]);
            if (!StringUtils.isEmpty((String)this.input.getAwsIamRole())) {
                this.wAwsIamRole.setText(this.input.getAwsIamRole());
            }
        }
        this.wStreamToS3Csv.setSelection(this.input.isStreamToS3Csv());
        if (!StringUtils.isEmpty((String)this.input.getLoadFromExistingFileFormat())) {
            this.wLoadFromExistingFileFormat.setText(this.input.getLoadFromExistingFileFormat());
        }
        if (!StringUtils.isEmpty((String)this.input.getCopyFromFilename())) {
            this.wCopyFromFilename.setText(this.input.getCopyFromFilename());
        }
        this.wTruncate.setSelection(this.input.isTruncateTable());
        this.wOnlyWhenHaveRows.setSelection(this.input.isOnlyWhenHaveRows());
        this.wSpecifyFields.setSelection(this.input.specifyFields());
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            RedshiftBulkLoaderField vbf = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            if (vbf.getDatabaseField() != null) {
                item.setText(1, vbf.getDatabaseField());
            }
            if (vbf.getStreamField() == null) continue;
            item.setText(2, vbf.getStreamField());
        }
        this.wTransformName.selectAll();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.backupChanged);
        this.dispose();
    }

    private void getInfo(RedshiftBulkLoaderMeta info) {
        if (!StringUtils.isEmpty((String)this.wConnection.getText())) {
            info.setConnection(this.wConnection.getText());
        }
        if (!StringUtils.isEmpty((String)this.wSchema.getText())) {
            info.setSchemaName(this.wSchema.getText());
        }
        if (!StringUtils.isEmpty((String)this.wTable.getText())) {
            info.setTablename(this.wTable.getText());
        }
        if (this.wAwsAuthType.getText().equals(AWS_CREDENTIALS)) {
            info.setUseCredentials(true);
            info.setUseAwsIamRole(false);
            if (this.wUseSystemVars.getSelection()) {
                info.setUseSystemEnvVars(true);
            } else {
                info.setUseSystemEnvVars(false);
                if (!StringUtils.isEmpty((String)this.wAccessKeyId.getText())) {
                    info.setAwsAccessKeyId(this.wAccessKeyId.getText());
                }
                if (!StringUtil.isEmpty((String)this.wSecretAccessKey.getText())) {
                    info.setAwsSecretAccessKey(this.wSecretAccessKey.getText());
                }
            }
        } else if (this.wAwsAuthType.getText().equals(AWS_IAM_ROLE)) {
            info.setUseCredentials(false);
            info.setUseAwsIamRole(true);
            if (!StringUtils.isEmpty((String)this.wAwsIamRole.getText())) {
                info.setAwsIamRole(this.wAwsIamRole.getText());
            }
        }
        info.setTruncateTable(this.wTruncate.getSelection());
        info.setOnlyWhenHaveRows(this.wOnlyWhenHaveRows.getSelection());
        info.setStreamToS3Csv(this.wStreamToS3Csv.getSelection());
        if (!StringUtils.isEmpty((String)this.wLoadFromExistingFileFormat.getText())) {
            info.setLoadFromExistingFileFormat(this.wLoadFromExistingFileFormat.getText());
        }
        if (!StringUtils.isEmpty((String)this.wCopyFromFilename.getText())) {
            info.setCopyFromFilename(this.wCopyFromFilename.getText());
        }
        info.setSpecifyFields(this.wSpecifyFields.getSelection());
        int nrRows = this.wFields.nrNonEmpty();
        info.getFields().clear();
        for (int i = 0; i < nrRows; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            RedshiftBulkLoaderField vbf = new RedshiftBulkLoaderField(Const.NVL((String)item.getText(1), (String)""), Const.NVL((String)item.getText(2), (String)""));
            info.getFields().add(vbf);
        }
    }

    private void ok() {
        if (StringUtil.isEmpty((String)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        if (Utils.isEmpty((CharSequence)this.input.getConnection())) {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.ConnectionError.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)CONST_SYSTEM_DIALOG_ERROR_TITLE));
            mb.open();
            return;
        }
        this.dispose();
    }

    private void getSchemaName() {
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
        if (databaseMeta != null) {
            try (Database database = new Database(loggingObject, this.variables, databaseMeta);){
                database.connect();
                String[] schemas = database.getSchemas();
                if (null != schemas && schemas.length > 0) {
                    EnterSelectionDialog dialog = new EnterSelectionDialog(this.shell, schemas = Const.sortStrings((String[])schemas), BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.AvailableSchemas.Title", (String[])new String[]{this.wConnection.getText()}), BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.AvailableSchemas.Message", (String[])new String[]{this.wConnection.getText()}));
                    String d = dialog.open();
                    if (d != null) {
                        this.wSchema.setText(Const.NVL((String)d, (String)""));
                        this.setTableFieldCombo();
                    }
                } else {
                    org.apache.hop.ui.core.dialog.MessageBox mb = new org.apache.hop.ui.core.dialog.MessageBox(this.shell, 33);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.NoSchema.Error", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.GetSchemas.Error", (String[])new String[0]));
                    mb.open();
                }
            }
            catch (Exception e) {
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)CONST_SYSTEM_DIALOG_ERROR_TITLE, (String[])new String[0]), BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.ErrorGettingSchemas", (String[])new String[0]), e);
            }
        }
    }

    private void getTableName() {
        String connectionName = this.wConnection.getText();
        if (StringUtil.isEmpty((String)connectionName)) {
            return;
        }
        DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(connectionName, this.variables);
        if (databaseMeta != null) {
            this.log.logDebug(this.toString(), new Object[]{BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.Log.LookingAtConnection", (String[])new String[]{databaseMeta.toString()})});
            DatabaseExplorerDialog std = new DatabaseExplorerDialog(this.shell, 0, this.variables, databaseMeta, this.pipelineMeta.getDatabases());
            std.setSelectedSchemaAndTable(this.wSchema.getText(), this.wTable.getText());
            if (std.open()) {
                this.wSchema.setText(Const.NVL((String)std.getSchemaName(), (String)""));
                this.wTable.setText(Const.NVL((String)std.getTableName(), (String)""));
            }
        } else {
            MessageBox mb = new MessageBox(this.shell, 33);
            mb.setMessage(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.ConnectionError2.DialogMessage", (String[])new String[0]));
            mb.setText(BaseMessages.getString((String)CONST_SYSTEM_DIALOG_ERROR_TITLE));
            mb.open();
        }
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1, 2}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    private void sql() {
        try {
            SqlStatement sql;
            RedshiftBulkLoaderMeta info = new RedshiftBulkLoaderMeta();
            DatabaseMeta databaseMeta = this.pipelineMeta.findDatabase(this.wConnection.getText(), this.variables);
            this.getInfo(info);
            IRowMeta prev = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (info.specifyFields()) {
                RowMeta prevNew = new RowMeta();
                for (int i = 0; i < info.getFields().size(); ++i) {
                    RedshiftBulkLoaderField vbf = info.getFields().get(i);
                    IValueMeta insValue = prev.searchValueMeta(vbf.getStreamField());
                    if (insValue == null) {
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.FailedToFindField.Message", (String[])new String[]{vbf.getStreamField()}));
                    }
                    IValueMeta insertValue = insValue.clone();
                    insertValue.setName(vbf.getDatabaseField());
                    prevNew.addValueMeta(insertValue);
                }
                prev = prevNew;
            }
            if (!(sql = info.getSqlStatements(this.variables, this.pipelineMeta, transformMeta, prev, this.metadataProvider)).hasError()) {
                if (sql.hasSql()) {
                    SqlEditor sqledit = new SqlEditor(this.shell, 0, this.variables, databaseMeta, DbCache.getInstance(), sql.getSql());
                    sqledit.open();
                } else {
                    MessageBox mb = new MessageBox(this.shell, 34);
                    mb.setMessage(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.NoSQL.DialogMessage", (String[])new String[0]));
                    mb.setText(BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.NoSQL.DialogTitle", (String[])new String[0]));
                    mb.open();
                }
            } else {
                MessageBox mb = new MessageBox(this.shell, 33);
                mb.setMessage(sql.getError());
                mb.setText(BaseMessages.getString((String)CONST_SYSTEM_DIALOG_ERROR_TITLE));
                mb.open();
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.BuildSQLError.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"RedshiftBulkLoaderDialog.BuildSQLError.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName();
    }

    public void toggleAuthSelection() {
        if (this.wAwsAuthType.getText().equals(AWS_CREDENTIALS)) {
            this.wlUseSystemVars.setEnabled(true);
            this.wUseSystemVars.setEnabled(true);
            this.wlAccessKeyId.setEnabled(true);
            this.wAccessKeyId.setEnabled(true);
            this.wlSecretAccessKey.setEnabled(true);
            this.wSecretAccessKey.setEnabled(true);
            this.wlAwsIamRole.setEnabled(false);
            this.wAwsIamRole.setEnabled(false);
        }
        if (this.wAwsAuthType.getText().equals(AWS_IAM_ROLE)) {
            this.wlUseSystemVars.setEnabled(false);
            this.wUseSystemVars.setEnabled(false);
            this.wlAccessKeyId.setEnabled(false);
            this.wAccessKeyId.setEnabled(false);
            this.wlSecretAccessKey.setEnabled(false);
            this.wSecretAccessKey.setEnabled(false);
            this.wlAwsIamRole.setEnabled(true);
            this.wAwsIamRole.setEnabled(true);
        }
    }

    public void toggleKeysSelection() {
        this.wlAccessKeyId.setEnabled(!this.wUseSystemVars.getSelection());
        this.wAccessKeyId.setEnabled(!this.wUseSystemVars.getSelection());
        this.wlSecretAccessKey.setEnabled(!this.wUseSystemVars.getSelection());
        this.wSecretAccessKey.setEnabled(!this.wUseSystemVars.getSelection());
    }
}

