/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.benchmark;

import java.io.File;
import java.net.URI;
import java.util.Arrays;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.util.Args;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class BenchmarkConfig {
    private final URI uri;
    private final int requests;
    private final int concurrencyLevel;
    private final TimeValue timeLimit;
    private final Timeout socketTimeout;
    private final File payloadFile;
    private final ContentType contentType;
    private final int verbosity;
    private final boolean headInsteadOfGet;
    private final String[] headers;
    private final boolean keepAlive;
    private final String method;
    private final boolean useChunking;
    private final boolean useExpectContinue;
    private final boolean useAcceptGZip;
    private final String payloadText;
    private final String soapAction;
    private final boolean forceHttp2;
    private final boolean disableSSLVerification;
    private final String trustStorePath;
    private final String identityStorePath;
    private final String trustStorePassword;
    private final String identityStorePassword;

    private BenchmarkConfig(URI uri, int requests, int concurrencyLevel, TimeValue timeLimit, Timeout socketTimeout, File payloadFile, ContentType contentType, int verbosity, boolean headInsteadOfGet, String[] headers, boolean keepAlive, String method, boolean useChunking, boolean useExpectContinue, boolean useAcceptGZip, String payloadText, String soapAction, boolean forceHttp2, boolean disableSSLVerification, String trustStorePath, String identityStorePath, String trustStorePassword, String identityStorePassword) {
        this.uri = uri;
        this.requests = requests;
        this.concurrencyLevel = concurrencyLevel;
        this.timeLimit = timeLimit;
        this.socketTimeout = socketTimeout;
        this.payloadFile = payloadFile;
        this.contentType = contentType;
        this.verbosity = verbosity;
        this.headInsteadOfGet = headInsteadOfGet;
        this.headers = headers;
        this.keepAlive = keepAlive;
        this.method = method;
        this.useChunking = useChunking;
        this.useExpectContinue = useExpectContinue;
        this.useAcceptGZip = useAcceptGZip;
        this.payloadText = payloadText;
        this.soapAction = soapAction;
        this.forceHttp2 = forceHttp2;
        this.disableSSLVerification = disableSSLVerification;
        this.trustStorePath = trustStorePath;
        this.identityStorePath = identityStorePath;
        this.trustStorePassword = trustStorePassword;
        this.identityStorePassword = identityStorePassword;
    }

    public URI getUri() {
        return this.uri;
    }

    public int getRequests() {
        return this.requests;
    }

    public int getConcurrencyLevel() {
        return this.concurrencyLevel;
    }

    public boolean isKeepAlive() {
        return this.keepAlive;
    }

    public int getVerbosity() {
        return this.verbosity;
    }

    public boolean isHeadInsteadOfGet() {
        return this.headInsteadOfGet;
    }

    public File getPayloadFile() {
        return this.payloadFile;
    }

    public ContentType getContentType() {
        return this.contentType;
    }

    public String[] getHeaders() {
        return this.headers != null ? (String[])this.headers.clone() : null;
    }

    public Timeout getSocketTimeout() {
        return this.socketTimeout;
    }

    public String getMethod() {
        return this.method;
    }

    public boolean isUseChunking() {
        return this.useChunking;
    }

    public boolean isUseExpectContinue() {
        return this.useExpectContinue;
    }

    public boolean isUseAcceptGZip() {
        return this.useAcceptGZip;
    }

    public String getPayloadText() {
        return this.payloadText;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public boolean isForceHttp2() {
        return this.forceHttp2;
    }

    public boolean isDisableSSLVerification() {
        return this.disableSSLVerification;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public String getIdentityStorePath() {
        return this.identityStorePath;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public String getIdentityStorePassword() {
        return this.identityStorePassword;
    }

    public TimeValue getTimeLimit() {
        return this.timeLimit;
    }

    public String toString() {
        return "[uri=" + this.uri + ", requests=" + this.requests + ", concurrencyLevel=" + this.concurrencyLevel + ", timeLimit=" + this.timeLimit + ", socketTimeout=" + this.socketTimeout + ", payloadFile=" + this.payloadFile + ", contentType=" + this.contentType + ", verbosity=" + this.verbosity + ", headInsteadOfGet=" + this.headInsteadOfGet + ", headers=" + Arrays.toString(this.headers) + ", keepAlive=" + this.keepAlive + ", method='" + this.method + '\'' + ", useChunking=" + this.useChunking + ", useExpectContinue=" + this.useExpectContinue + ", useAcceptGZip=" + this.useAcceptGZip + ", payloadText='" + this.payloadText + '\'' + ", soapAction='" + this.soapAction + '\'' + ", forceHttp2=" + this.forceHttp2 + ", disableSSLVerification=" + this.disableSSLVerification + ", trustStorePath='" + this.trustStorePath + '\'' + ", identityStorePath='" + this.identityStorePath + '\'' + ", trustStorePassword='" + this.trustStorePassword + '\'' + ", identityStorePassword='" + this.identityStorePassword + '\'' + ']';
    }

    public static Builder custom() {
        return new Builder();
    }

    public static Builder copy(BenchmarkConfig config) {
        Args.notNull((Object)config, (String)"Socket config");
        return new Builder().setUri(config.getUri()).setRequests(config.getRequests()).setConcurrencyLevel(config.getConcurrencyLevel()).setTimeLimit(config.getTimeLimit()).setSocketTimeout(config.getSocketTimeout()).setPayloadFile(config.getPayloadFile()).setContentType(config.getContentType()).setVerbosity(config.getVerbosity()).setHeadInsteadOfGet(config.isHeadInsteadOfGet()).setHeaders(config.getHeaders()).setKeepAlive(config.isKeepAlive()).setMethod(config.getMethod()).setUseChunking(config.isUseChunking()).setUseExpectContinue(config.isUseExpectContinue()).setUseAcceptGZip(config.isUseAcceptGZip()).setPayloadText(config.getPayloadText()).setSoapAction(config.getSoapAction()).setForceHttp2(config.isForceHttp2()).setDisableSSLVerification(config.isDisableSSLVerification()).setTrustStorePath(config.getTrustStorePath()).setIdentityStorePath(config.getIdentityStorePath()).setTrustStorePassword(config.getTrustStorePassword()).setIdentityStorePassword(config.getIdentityStorePassword());
    }

    public static class Builder {
        private URI uri;
        private int requests = 1;
        private int concurrencyLevel = 1;
        private TimeValue timeLimit;
        private Timeout socketTimeout = Timeout.ofSeconds((long)60L);
        private File payloadFile;
        private ContentType contentType;
        private int verbosity = 0;
        private boolean headInsteadOfGet = false;
        private String[] headers;
        private boolean keepAlive = false;
        private String method;
        private boolean useChunking;
        private boolean useExpectContinue;
        private boolean useAcceptGZip;
        private String payloadText;
        private String soapAction;
        private boolean forceHttp2;
        private boolean disableSSLVerification;
        private String trustStorePath;
        private String identityStorePath;
        private String trustStorePassword;
        private String identityStorePassword;

        public Builder setUri(URI uri) {
            this.uri = uri;
            return this;
        }

        public Builder setRequests(int requests) {
            this.requests = requests;
            return this;
        }

        public Builder setConcurrencyLevel(int concurrencyLevel) {
            this.concurrencyLevel = concurrencyLevel;
            return this;
        }

        public Builder setKeepAlive(boolean keepAlive) {
            this.keepAlive = keepAlive;
            return this;
        }

        public Builder setVerbosity(int verbosity) {
            this.verbosity = verbosity;
            return this;
        }

        public Builder setHeadInsteadOfGet(boolean headInsteadOfGet) {
            this.headInsteadOfGet = headInsteadOfGet;
            return this;
        }

        public Builder setContentType(ContentType contentType) {
            this.contentType = contentType;
            return this;
        }

        public Builder setHeaders(String[] headers) {
            this.headers = headers;
            return this;
        }

        public Builder setSocketTimeout(Timeout socketTimeout) {
            this.socketTimeout = socketTimeout;
            return this;
        }

        public Builder setMethod(String method) {
            this.method = method;
            return this;
        }

        public Builder setUseChunking(boolean useChunking) {
            this.useChunking = useChunking;
            return this;
        }

        public Builder setUseExpectContinue(boolean useExpectContinue) {
            this.useExpectContinue = useExpectContinue;
            return this;
        }

        public Builder setUseAcceptGZip(boolean useAcceptGZip) {
            this.useAcceptGZip = useAcceptGZip;
            return this;
        }

        public Builder setPayloadFile(File payloadFile) {
            this.payloadFile = payloadFile;
            return this;
        }

        public Builder setPayloadText(String payloadText) {
            this.payloadText = payloadText;
            return this;
        }

        public Builder setSoapAction(String soapAction) {
            this.soapAction = soapAction;
            return this;
        }

        public Builder setTimeLimit(TimeValue timeLimit) {
            this.timeLimit = timeLimit;
            return this;
        }

        public Builder setForceHttp2(boolean forceHttp2) {
            this.forceHttp2 = forceHttp2;
            return this;
        }

        public Builder setDisableSSLVerification(boolean disableSSLVerification) {
            this.disableSSLVerification = disableSSLVerification;
            return this;
        }

        public Builder setTrustStorePath(String trustStorePath) {
            this.trustStorePath = trustStorePath;
            return this;
        }

        public Builder setIdentityStorePath(String identityStorePath) {
            this.identityStorePath = identityStorePath;
            return this;
        }

        public Builder setTrustStorePassword(String trustStorePassword) {
            this.trustStorePassword = trustStorePassword;
            return this;
        }

        public Builder setIdentityStorePassword(String identityStorePassword) {
            this.identityStorePassword = identityStorePassword;
            return this;
        }

        public BenchmarkConfig build() {
            return new BenchmarkConfig(this.uri, this.requests, this.concurrencyLevel, this.timeLimit, this.socketTimeout, this.payloadFile, this.contentType, this.verbosity, this.headInsteadOfGet, this.headers, this.keepAlive, this.method, this.useChunking, this.useExpectContinue, this.useAcceptGZip, this.payloadText, this.soapAction, this.forceHttp2, this.disableSSLVerification, this.trustStorePath, this.identityStorePath, this.trustStorePassword, this.identityStorePassword);
        }
    }
}

