/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.net.InetAddress;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.hc.core5.http.HttpHost;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestHttpHost {
    TestHttpHost() {
    }

    @Test
    void testConstructor() {
        HttpHost host1 = new HttpHost("somehost");
        Assertions.assertEquals((Object)"somehost", (Object)host1.getHostName());
        Assertions.assertEquals((int)-1, (int)host1.getPort());
        Assertions.assertEquals((Object)"http", (Object)host1.getSchemeName());
        HttpHost host2 = new HttpHost("somehost", 8080);
        Assertions.assertEquals((Object)"somehost", (Object)host2.getHostName());
        Assertions.assertEquals((int)8080, (int)host2.getPort());
        Assertions.assertEquals((Object)"http", (Object)host2.getSchemeName());
        HttpHost host3 = new HttpHost("somehost", -1);
        Assertions.assertEquals((Object)"somehost", (Object)host3.getHostName());
        Assertions.assertEquals((int)-1, (int)host3.getPort());
        Assertions.assertEquals((Object)"http", (Object)host3.getSchemeName());
        HttpHost host4 = new HttpHost("https", "somehost", 443);
        Assertions.assertEquals((Object)"somehost", (Object)host4.getHostName());
        Assertions.assertEquals((int)443, (int)host4.getPort());
        Assertions.assertEquals((Object)"https", (Object)host4.getSchemeName());
        HttpHost host5 = new HttpHost("https", "somehost");
        Assertions.assertEquals((Object)"somehost", (Object)host5.getHostName());
        Assertions.assertEquals((int)-1, (int)host5.getPort());
        Assertions.assertEquals((Object)"https", (Object)host5.getSchemeName());
        Assertions.assertThrows(NullPointerException.class, () -> new HttpHost(null, (String)null, -1));
        Assertions.assertThrows(IllegalArgumentException.class, () -> new HttpHost(null, "   ", -1));
        Assertions.assertThrows(NullPointerException.class, () -> new HttpHost(null, (InetAddress)null, -1));
    }

    @Test
    void testHashCode() throws Exception {
        HttpHost host1 = new HttpHost("http", "somehost", 8080);
        HttpHost host2 = new HttpHost("http", "somehost", 80);
        HttpHost host3 = new HttpHost("http", "someotherhost", 8080);
        HttpHost host4 = new HttpHost("http", "somehost", 80);
        HttpHost host5 = new HttpHost("http", "SomeHost", 80);
        HttpHost host6 = new HttpHost("myhttp", "SomeHost", 80);
        HttpHost host7 = new HttpHost("http", InetAddress.getByAddress("127.0.0.1", new byte[]{127, 0, 0, 1}), 80);
        HttpHost host8 = new HttpHost("http", "127.0.0.1", 80);
        HttpHost host9 = new HttpHost("http", InetAddress.getByAddress("somehost", new byte[]{127, 0, 0, 1}), 80);
        HttpHost host10 = new HttpHost("http", InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), "somehost", 80);
        HttpHost host11 = new HttpHost("http", InetAddress.getByAddress("someotherhost", new byte[]{127, 0, 0, 1}), 80);
        Assertions.assertEquals((int)host1.hashCode(), (int)host1.hashCode());
        Assertions.assertNotEquals((int)host1.hashCode(), (int)host2.hashCode());
        Assertions.assertNotEquals((int)host1.hashCode(), (int)host3.hashCode());
        Assertions.assertEquals((int)host2.hashCode(), (int)host4.hashCode());
        Assertions.assertEquals((int)host2.hashCode(), (int)host5.hashCode());
        Assertions.assertNotEquals((int)host5.hashCode(), (int)host6.hashCode());
        Assertions.assertNotEquals((int)host7.hashCode(), (int)host8.hashCode());
        Assertions.assertNotEquals((int)host8.hashCode(), (int)host9.hashCode());
        Assertions.assertEquals((int)host9.hashCode(), (int)host10.hashCode());
        Assertions.assertNotEquals((int)host10.hashCode(), (int)host11.hashCode());
        Assertions.assertNotEquals((int)host9.hashCode(), (int)host11.hashCode());
    }

    @Test
    void testEquals() throws Exception {
        HttpHost host1 = new HttpHost("http", "somehost", 8080);
        HttpHost host2 = new HttpHost("http", "somehost", 80);
        HttpHost host3 = new HttpHost("http", "someotherhost", 8080);
        HttpHost host4 = new HttpHost("http", "somehost", 80);
        HttpHost host5 = new HttpHost("http", "SomeHost", 80);
        HttpHost host6 = new HttpHost("myhttp", "SomeHost", 80);
        HttpHost host7 = new HttpHost("http", InetAddress.getByAddress("127.0.0.1", new byte[]{127, 0, 0, 1}), 80);
        HttpHost host8 = new HttpHost("http", "127.0.0.1", 80);
        HttpHost host9 = new HttpHost("http", InetAddress.getByAddress("somehost", new byte[]{127, 0, 0, 1}), 80);
        HttpHost host10 = new HttpHost("http", InetAddress.getByAddress(new byte[]{127, 0, 0, 1}), "somehost", 80);
        HttpHost host11 = new HttpHost("http", InetAddress.getByAddress("someotherhost", new byte[]{127, 0, 0, 1}), 80);
        Assertions.assertEquals((Object)host1, (Object)host1);
        Assertions.assertNotEquals((Object)host1, (Object)host2);
        Assertions.assertNotEquals((Object)host1, (Object)host3);
        Assertions.assertEquals((Object)host2, (Object)host4);
        Assertions.assertEquals((Object)host2, (Object)host5);
        Assertions.assertNotEquals((Object)host5, (Object)host6);
        Assertions.assertNotEquals((Object)host7, (Object)host8);
        Assertions.assertNotEquals((Object)host7, (Object)host9);
        Assertions.assertNotEquals(null, (Object)host1);
        Assertions.assertNotEquals((Object)"http://somehost", (Object)host1);
        Assertions.assertNotEquals((Object)"http://somehost", (Object)host9);
        Assertions.assertNotEquals((Object)host8, (Object)host9);
        Assertions.assertEquals((Object)host9, (Object)host10);
        Assertions.assertNotEquals((Object)host9, (Object)host11);
    }

    @Test
    void testToString() throws Exception {
        HttpHost host1 = new HttpHost("somehost");
        Assertions.assertEquals((Object)"http://somehost", (Object)host1.toString());
        HttpHost host2 = new HttpHost("somehost", -1);
        Assertions.assertEquals((Object)"http://somehost", (Object)host2.toString());
        HttpHost host3 = new HttpHost("somehost", -1);
        Assertions.assertEquals((Object)"http://somehost", (Object)host3.toString());
        HttpHost host4 = new HttpHost("somehost", 8888);
        Assertions.assertEquals((Object)"http://somehost:8888", (Object)host4.toString());
        HttpHost host5 = new HttpHost("myhttp", "somehost", -1);
        Assertions.assertEquals((Object)"myhttp://somehost", (Object)host5.toString());
        HttpHost host6 = new HttpHost("myhttp", "somehost", 80);
        Assertions.assertEquals((Object)"myhttp://somehost:80", (Object)host6.toString());
        HttpHost host7 = new HttpHost("http", InetAddress.getByAddress("127.0.0.1", new byte[]{127, 0, 0, 1}), 80);
        Assertions.assertEquals((Object)"http://127.0.0.1:80", (Object)host7.toString());
        HttpHost host9 = new HttpHost("http", InetAddress.getByAddress("somehost", new byte[]{127, 0, 0, 1}), 80);
        Assertions.assertEquals((Object)"http://somehost:80", (Object)host9.toString());
    }

    @Test
    void testToHostString() {
        HttpHost host1 = new HttpHost("somehost");
        Assertions.assertEquals((Object)"somehost", (Object)host1.toHostString());
        HttpHost host2 = new HttpHost("somehost");
        Assertions.assertEquals((Object)"somehost", (Object)host2.toHostString());
        HttpHost host3 = new HttpHost("somehost", -1);
        Assertions.assertEquals((Object)"somehost", (Object)host3.toHostString());
        HttpHost host4 = new HttpHost("somehost", 8888);
        Assertions.assertEquals((Object)"somehost:8888", (Object)host4.toHostString());
    }

    @Test
    void testSerialization() throws Exception {
        HttpHost orig = new HttpHost("https", "somehost", 8080);
        ByteArrayOutputStream outbuffer = new ByteArrayOutputStream();
        try (ObjectOutputStream outStream = new ObjectOutputStream(outbuffer);){
            outStream.writeObject(orig);
        }
        byte[] raw = outbuffer.toByteArray();
        ByteArrayInputStream inBuffer = new ByteArrayInputStream(raw);
        ObjectInputStream inStream = new ObjectInputStream(inBuffer);
        HttpHost clone = (HttpHost)inStream.readObject();
        Assertions.assertEquals((Object)orig, (Object)clone);
    }

    @Test
    void testCreateFromString() throws Exception {
        Assertions.assertEquals((Object)new HttpHost("https", "somehost", 8080), (Object)HttpHost.create((String)"https://somehost:8080"));
        Assertions.assertEquals((Object)new HttpHost("https", "somehost", 8080), (Object)HttpHost.create((String)"HttpS://SomeHost:8080"));
        Assertions.assertEquals((Object)new HttpHost(null, "somehost", 1234), (Object)HttpHost.create((String)"somehost:1234"));
        Assertions.assertEquals((Object)new HttpHost(null, "somehost", -1), (Object)HttpHost.create((String)"somehost"));
    }

    @Test
    void testCreateFromURI() {
        Assertions.assertEquals((Object)new HttpHost("https", "somehost", 8080), (Object)HttpHost.create((URI)URI.create("https://somehost:8080")));
        Assertions.assertEquals((Object)new HttpHost("https", "somehost", 8080), (Object)HttpHost.create((URI)URI.create("HttpS://SomeHost:8080")));
        Assertions.assertEquals((Object)new HttpHost("https", "somehost", 8080), (Object)HttpHost.create((URI)URI.create("HttpS://SomeHost:8080/foo")));
    }

    @Test
    void testCreateFromStringInvalid() {
        Assertions.assertThrows(URISyntaxException.class, () -> HttpHost.create((String)" host "));
        Assertions.assertThrows(URISyntaxException.class, () -> HttpHost.create((String)"host :8080"));
        Assertions.assertThrows(IllegalArgumentException.class, () -> HttpHost.create((String)""));
    }

    @Test
    void testIpv6HostAndPort() throws Exception {
        HttpHost host = HttpHost.create((String)"[::1]:80");
        Assertions.assertEquals((Object)"http", (Object)host.getSchemeName());
        Assertions.assertEquals((Object)"::1", (Object)host.getHostName());
        Assertions.assertEquals((int)80, (int)host.getPort());
    }

    @Test
    void testIpv6HostAndPortWithScheme() throws Exception {
        HttpHost host = HttpHost.create((String)"https://[::1]:80");
        Assertions.assertEquals((Object)"https", (Object)host.getSchemeName());
        Assertions.assertEquals((Object)"::1", (Object)host.getHostName());
        Assertions.assertEquals((int)80, (int)host.getPort());
    }

    @Test
    void testIpv6HostAndPortWithoutBrackets() {
        Assertions.assertThrows(URISyntaxException.class, () -> HttpHost.create((String)"::1:80"));
    }

    @Test
    void testIpv6HostWithoutPort() {
        Assertions.assertThrows(URISyntaxException.class, () -> HttpHost.create((String)"::1"));
    }

    @Test
    void testIpv6HostToString() {
        Assertions.assertEquals((Object)"http://[::1]:80", (Object)new HttpHost("::1", 80).toString());
        Assertions.assertEquals((Object)"http://[::1]", (Object)new HttpHost("::1", -1).toString());
    }
}

