/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.cluster;

import java.io.Serializable;
import java.util.Objects;
import org.apache.ignite.IgniteCheckedException;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.internal.processors.configuration.distributed.DistributePropertyListener;
import org.apache.ignite.internal.processors.configuration.distributed.DistributedProperty;
import org.jetbrains.annotations.NotNull;

public final class DistributedConfigurationUtils {
    private DistributedConfigurationUtils() {
    }

    public static <T extends Serializable> void setDefaultValue(DistributedProperty<T> property, T value, IgniteLogger log) {
        if (property.get() == null) {
            try {
                property.propagateAsync(null, value).listen(future -> {
                    if (future.error() != null) {
                        log.error("Cannot set default value of '" + property.getName() + '\'', future.error());
                    }
                });
            }
            catch (IgniteCheckedException e) {
                log.error("Cannot initiate setting default value of '" + property.getName() + '\'', e);
            }
        }
    }

    @NotNull
    public static <T> DistributePropertyListener<T> makeUpdateListener(String propUpdMsg, IgniteLogger log) {
        return (name, oldVal, newVal) -> {
            if (!Objects.equals(oldVal, newVal) && log.isInfoEnabled()) {
                log.info(String.format(propUpdMsg, name, oldVal, newVal));
            }
        };
    }
}

