/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.ignite.IgniteException;
import org.apache.ignite.cache.query.QueryDetailMetrics;
import org.apache.ignite.compute.ComputeJobResult;
import org.apache.ignite.internal.processors.cache.GridCacheProcessor;
import org.apache.ignite.internal.processors.cache.GridCacheUtils;
import org.apache.ignite.internal.processors.cache.IgniteInternalCache;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsAdapter;
import org.apache.ignite.internal.processors.cache.query.GridCacheQueryDetailMetricsKey;
import org.apache.ignite.internal.processors.task.GridInternal;
import org.apache.ignite.internal.util.typedef.internal.S;
import org.apache.ignite.internal.visor.VisorJob;
import org.apache.ignite.internal.visor.VisorMultiNodeTask;
import org.apache.ignite.internal.visor.query.VisorQueryDetailMetrics;
import org.apache.ignite.internal.visor.query.VisorQueryDetailMetricsCollectorTaskArg;
import org.jetbrains.annotations.Nullable;

@GridInternal
public class VisorQueryDetailMetricsCollectorTask
extends VisorMultiNodeTask<VisorQueryDetailMetricsCollectorTaskArg, Collection<VisorQueryDetailMetrics>, Collection<? extends QueryDetailMetrics>> {
    private static final long serialVersionUID = 0L;

    protected VisorCacheQueryDetailMetricsCollectorJob job(VisorQueryDetailMetricsCollectorTaskArg arg) {
        return new VisorCacheQueryDetailMetricsCollectorJob(arg, this.debug);
    }

    @Override
    @Nullable
    protected Collection<VisorQueryDetailMetrics> reduce0(List<ComputeJobResult> results) throws IgniteException {
        HashMap taskRes = new HashMap();
        for (ComputeJobResult computeJobResult : results) {
            if (computeJobResult.getException() != null) {
                throw computeJobResult.getException();
            }
            Collection metrics = (Collection)computeJobResult.getData();
            VisorCacheQueryDetailMetricsCollectorJob.aggregateMetrics(-1L, taskRes, metrics);
        }
        Collection aggMetrics = taskRes.values();
        ArrayList<VisorQueryDetailMetrics> arrayList = new ArrayList<VisorQueryDetailMetrics>(aggMetrics.size());
        for (GridCacheQueryDetailMetricsAdapter m : aggMetrics) {
            arrayList.add(new VisorQueryDetailMetrics(m));
        }
        return arrayList;
    }

    private static class VisorCacheQueryDetailMetricsCollectorJob
    extends VisorJob<VisorQueryDetailMetricsCollectorTaskArg, Collection<? extends QueryDetailMetrics>> {
        private static final long serialVersionUID = 0L;

        protected VisorCacheQueryDetailMetricsCollectorJob(@Nullable VisorQueryDetailMetricsCollectorTaskArg arg, boolean debug) {
            super(arg, debug);
        }

        private static void aggregateMetrics(long since, Map<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> res, Collection<GridCacheQueryDetailMetricsAdapter> metrics) {
            for (GridCacheQueryDetailMetricsAdapter m : metrics) {
                GridCacheQueryDetailMetricsKey key;
                if (m.lastStartTime() <= since) continue;
                GridCacheQueryDetailMetricsAdapter aggMetrics = res.get(key = m.key());
                res.put(key, aggMetrics == null ? m : aggMetrics.aggregate(m));
            }
        }

        @Override
        protected Collection<? extends QueryDetailMetrics> run(@Nullable VisorQueryDetailMetricsCollectorTaskArg arg) throws IgniteException {
            assert (arg != null);
            GridCacheProcessor cacheProc = this.ignite.context().cache();
            Collection<String> cacheNames = cacheProc.cacheNames();
            HashMap<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter> aggMetrics = new HashMap<GridCacheQueryDetailMetricsKey, GridCacheQueryDetailMetricsAdapter>();
            for (String cacheName : cacheNames) {
                IgniteInternalCache cache;
                if (GridCacheUtils.isSystemCache(cacheName) || (cache = cacheProc.cache(cacheName)) == null || !cache.context().started()) continue;
                VisorCacheQueryDetailMetricsCollectorJob.aggregateMetrics(arg.getSince(), aggMetrics, cache.context().queries().detailMetrics());
            }
            return new ArrayList(aggMetrics.values());
        }

        public String toString() {
            return S.toString(VisorCacheQueryDetailMetricsCollectorJob.class, this);
        }
    }
}

