/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 * 
 *  http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License. 
 */

package org.drools.workbench.screens.scenariosimulation.kogito.client.editor.strategies;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;

import org.drools.workbench.screens.scenariosimulation.client.commands.ScenarioSimulationContext;
import org.drools.workbench.screens.scenariosimulation.client.editor.strategies.AbstractDMODataManagementStrategy;
import org.drools.workbench.screens.scenariosimulation.client.enums.GridWidget;
import org.drools.workbench.screens.scenariosimulation.client.rightpanel.TestToolsView;
import org.drools.workbench.screens.scenariosimulation.kogito.client.dmo.KogitoAsyncPackageDataModelOracle;
import org.drools.workbench.screens.scenariosimulation.model.dmo.ModelField;
import org.drools.workbench.screens.scenariosimulation.model.typedescriptor.FactModelTree;
import org.uberfire.client.callbacks.Callback;

public class KogitoDMODataManagementStrategy extends AbstractDMODataManagementStrategy {

    protected KogitoAsyncPackageDataModelOracle kogitoOracle;

    public KogitoDMODataManagementStrategy(KogitoAsyncPackageDataModelOracle kogitoOracle) {
        this.kogitoOracle = kogitoOracle;
    }

    @Override
    public boolean isADataType(String value) {
        return kogitoOracle != null && Arrays.asList(kogitoOracle.getFactTypes()).contains(value);
    }

    @Override
    protected void manageDataObjects(final List<String> dataObjectsTypes,
                                     final Map<String, String> superTypeMap,
                                     final TestToolsView.Presenter testToolsPresenter,
                                     final int expectedElements,
                                     final SortedMap<String, FactModelTree> dataObjectsFieldsMap,
                                     final ScenarioSimulationContext context,
                                     final List<String> simpleJavaTypes,
                                     final GridWidget gridWidget) {
        // Iterate over all dataObjects to retrieve their modelfields
        dataObjectsTypes.forEach(factType -> {
            ModelField[] retrieved = kogitoOracle.getFieldCompletions(factType);
            FactModelTree toSend = getFactModelTree(factType, superTypeMap, retrieved);
            aggregatorCallbackMethod(testToolsPresenter, expectedElements, dataObjectsFieldsMap, context, toSend, simpleJavaTypes, gridWidget);
        });
    }

    @Override
    protected List<String> getFactTypes() {
        return Arrays.asList(kogitoOracle.getFactTypes());
    }

    @Override
    protected void getSuperType(String factType, Callback<String> callback) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected boolean skipPopulateTestTools() {
        return kogitoOracle == null || kogitoOracle.getFactTypes().length == 0;
    }

    @Override
    protected String getFQCNByFactName(String factName) {
        return kogitoOracle.getFQCNByFactName(factName);
    }

    @Override
    protected String getParametricFieldType(String factName, String propertyName) {
        return kogitoOracle.getParametricFieldType(factName, propertyName);
    }
}
