/*
 * Decompiled with CFR 0.152.
 */
package org.apache.livy.repl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.net.InetAddress;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.Map;
import org.apache.livy.Logging;
import org.apache.livy.Utils$;
import org.apache.livy.client.common.ClientConf;
import org.apache.livy.repl.Interpreter;
import org.apache.livy.repl.PySparkJobProcessor;
import org.apache.livy.repl.PythonInterpreter;
import org.apache.livy.rsc.driver.SparkEntries;
import org.apache.spark.SparkConf;
import org.slf4j.Logger;
import py4j.Gateway;
import py4j.GatewayServer;
import py4j.Py4JException;
import py4j.reflection.PythonProxyHandler;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;
import scala.runtime.Null$;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public final class PythonInterpreter$
implements Logging {
    public static final PythonInterpreter$ MODULE$;
    private final Logger logger;
    private volatile boolean bitmap$0;

    static {
        new PythonInterpreter$();
    }

    private Logger logger$lzycompute() {
        PythonInterpreter$ pythonInterpreter$ = this;
        synchronized (pythonInterpreter$) {
            if (!this.bitmap$0) {
                this.logger = Logging.class.logger((Logging)this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    public void trace(Function0<Object> message) {
        Logging.class.trace((Logging)this, message);
    }

    public void debug(Function0<Object> message) {
        Logging.class.debug((Logging)this, message);
    }

    public void info(Function0<Object> message) {
        Logging.class.info((Logging)this, message);
    }

    public void warn(Function0<Object> message) {
        Logging.class.warn((Logging)this, message);
    }

    public void warn(Function0<Object> message, Throwable t) {
        Logging.class.warn((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message, Throwable t) {
        Logging.class.error((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<Object> message) {
        Logging.class.error((Logging)this, message);
    }

    public Interpreter apply(SparkConf conf, SparkEntries sparkEntries) {
        String pythonExec = (String)conf.getOption("spark.pyspark.python").orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return package$.MODULE$.env().get((Object)"PYSPARK_PYTHON");
            }
        }).orElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Option<String> apply() {
                return package$.MODULE$.props().get("pyspark.python");
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "python";
            }
        });
        String secretKey = Utils$.MODULE$.createSecret(256);
        GatewayServer gatewayServer = this.createGatewayServer(sparkEntries, secretKey);
        gatewayServer.start();
        ProcessBuilder builder = new ProcessBuilder((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pythonExec, this.createFakeShell().toString()}))).asJava());
        Map<String, String> env = builder.environment();
        String[] pythonPath = (String[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])((String)package$.MODULE$.env().getOrElse((Object)"PYTHONPATH", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })).split(File.pathSeparator)).$plus$plus(ClientConf.TEST_MODE ? Nil$.MODULE$ : this.findPySparkArchives(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).$plus$plus(ClientConf.TEST_MODE ? Nil$.MODULE$ : this.findPyFiles(conf), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
        env.put("PYSPARK_PYTHON", pythonExec);
        env.put("PYTHONPATH", Predef$.MODULE$.refArrayOps((Object[])pythonPath).mkString(File.pathSeparator));
        env.put("PYTHONUNBUFFERED", "YES");
        env.put("PYSPARK_GATEWAY_PORT", String.valueOf(BoxesRunTime.boxToInteger((int)gatewayServer.getListeningPort())));
        env.put("PYSPARK_GATEWAY_SECRET", secretKey);
        env.put("SPARK_HOME", (String)package$.MODULE$.env().getOrElse((Object)"SPARK_HOME", (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return ".";
            }
        }));
        env.put("LIVY_SPARK_MAJOR_VERSION", conf.get("spark.livy.spark_major_version", "1"));
        builder.redirectError(ProcessBuilder.Redirect.PIPE);
        Process process = builder.start();
        return new PythonInterpreter(process, gatewayServer);
    }

    private Seq<String> findPySparkArchives() {
        return (Seq)package$.MODULE$.env().get((Object)"PYSPARK_ARCHIVES_PATH").map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$1) {
                return Predef$.MODULE$.refArrayOps((Object[])x$1.split(",")).toSeq();
            }
        }).getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply() {
                return (Seq)package$.MODULE$.env().get((Object)"SPARK_HOME").map((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<String> apply(String sparkHome) {
                        String pyLibPath = ((TraversableOnce)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{sparkHome, "python", "lib"}))).mkString(File.separator);
                        File pyArchivesFile = new File(pyLibPath, "pyspark.zip");
                        Predef$.MODULE$.require(pyArchivesFile.exists(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "pyspark.zip not found; cannot start pyspark interpreter.";
                            }
                        });
                        File py4jFile = Files.newDirectoryStream(Paths.get(pyLibPath, new String[0]), "py4j-*-src.zip").iterator().next().toFile();
                        Predef$.MODULE$.require(py4jFile.exists(), (Function0)new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final String apply() {
                                return "py4j-*-src.zip not found; cannot start pyspark interpreter.";
                            }
                        });
                        return (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{pyArchivesFile.getAbsolutePath(), py4jFile.getAbsolutePath()}));
                    }
                }).getOrElse((Function0)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final Seq<Nothing$> apply() {
                        return (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
                    }
                });
            }
        });
    }

    /*
     * Enabled aggressive block sorting
     */
    private Seq<String> findPyFiles(SparkConf conf) {
        Seq seq;
        String[] pyFiles;
        block3: {
            block2: {
                pyFiles = ((String)package$.MODULE$.props().getOrElse((Object)"spark.submit.pyFiles", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                })).split(",");
                Object object = package$.MODULE$.env().getOrElse((Object)"SPARK_YARN_MODE", (Function0)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "";
                    }
                });
                String string = "true";
                if (!(object == null ? string != null : !object.equals(string))) break block2;
                String string2 = conf.get("spark.master", "").toLowerCase();
                String string3 = "yarn";
                if (string2 != null ? !string2.equals(string3) : string3 != null) break block3;
                String string4 = conf.get("spark.submit.deployMode", "").toLowerCase();
                String string5 = "cluster";
                if (string4 != null ? !string4.equals(string5) : string5 != null) break block3;
            }
            seq = (Seq)Predef$.MODULE$.refArrayOps((Object[])pyFiles).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String file) {
                    String name = new File(file).getName();
                    return new File(name).getAbsolutePath();
                }
            }, Array$.MODULE$.fallbackCanBuildFrom(Predef.DummyImplicit$.MODULE$.dummyImplicit()));
            return seq;
        }
        seq = Predef$.MODULE$.wrapRefArray((Object[])pyFiles);
        return seq;
    }

    /*
     * WARNING - void declaration
     */
    private File createFakeShell() {
        void var2_2;
        InputStream source = this.getClass().getClassLoader().getResourceAsStream("fake_shell.py");
        File file = Files.createTempFile("", "", new FileAttribute[0]).toFile();
        file.deleteOnExit();
        FileOutputStream sink = new FileOutputStream(file);
        byte[] buf = new byte[1024];
        int n = source.read(buf);
        while (n > 0) {
            sink.write(buf, 0, n);
            n = source.read(buf);
        }
        source.close();
        sink.close();
        return var2_2;
    }

    private GatewayServer createGatewayServer(SparkEntries sparkEntries, String secretKey) {
        GatewayServer gatewayServer;
        try {
            Class<?> clz = Class.forName("py4j.GatewayServer$GatewayServerBuilder", true, Thread.currentThread().getContextClassLoader());
            Object builder = clz.getConstructor(Object.class).newInstance(sparkEntries);
            InetAddress localhost = InetAddress.getLoopbackAddress();
            builder.getClass().getMethod("authToken", String.class).invoke(builder, secretKey);
            builder.getClass().getMethod("javaPort", Integer.TYPE).invoke(builder, Predef$.MODULE$.int2Integer(0));
            builder.getClass().getMethod("javaAddress", InetAddress.class).invoke(builder, localhost);
            builder.getClass().getMethod("callbackClient", Integer.TYPE, InetAddress.class, String.class).invoke(builder, Predef$.MODULE$.int2Integer(25334), localhost, secretKey);
            gatewayServer = (GatewayServer)builder.getClass().getMethod("build", new Class[0]).invoke(builder, new Object[0]);
        }
        catch (Throwable throwable) {
            GatewayServer gatewayServer2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Throwable e = (Throwable)option.get();
            this.warn((Function0<Object>)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Fail to create GatewayServer with auth parameter, downgrade to old constructor";
                }
            }, e);
            gatewayServer = gatewayServer2 = new GatewayServer((Object)sparkEntries, 0);
        }
        return gatewayServer;
    }

    public PySparkJobProcessor org$apache$livy$repl$PythonInterpreter$$initiatePy4jCallbackGateway(GatewayServer server) {
        Field f = server.getClass().getDeclaredField("gateway");
        f.setAccessible(true);
        Gateway gateway = (Gateway)f.get(server);
        String command = "ft;org.apache.livy.repl.PySparkJobProcessor";
        return (PySparkJobProcessor)this.getPythonProxy(command, gateway);
    }

    /*
     * Loose catch block
     */
    private Object getPythonProxy(String commandPart, Gateway gateway) {
        int proxy;
        String proxyString = commandPart.substring(1, commandPart.length());
        String[] parts = proxyString.split(";");
        int length = parts.length;
        ArrayBuffer interfaces2 = (ArrayBuffer)ArrayBuffer$.MODULE$.fill(length - 1, (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Null$ apply() {
                return null;
            }
        });
        if (length < 2) {
            throw new Py4JException("Invalid Python Proxy.");
        }
        for (proxy = 1; proxy < length; ++proxy) {
            block8: {
                interfaces2.update(proxy - 1, Class.forName(parts[proxy]));
                if (!((Class)interfaces2.apply(proxy - 1)).isInterface()) break block8;
                continue;
            }
            throw new Py4JException(new StringBuilder().append((Object)"This class ").append((Object)parts[proxy]).append((Object)" is not an interface and cannot be used as a Python Proxy.").toString());
        }
        PythonProxyHandler pythonProxyHandler = (PythonProxyHandler)PythonProxyHandler.class.getConstructor(String.class, Gateway.class).newInstance(parts[0], gateway);
        catch (ClassNotFoundException classNotFoundException) {
            throw new Py4JException(new StringBuilder().append((Object)"Invalid interface name: ").append((Object)parts[proxy]).toString());
        }
        catch (Throwable throwable) {
            PythonProxyHandler pythonProxyHandler2;
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            Object cbClient = gateway.getClass().getMethod("getCallbackClient", new Class[0]).invoke((Object)gateway, new Object[0]);
            Class<?> cbClass = Class.forName("py4j.CallbackClient");
            pythonProxyHandler = pythonProxyHandler2 = (PythonProxyHandler)PythonProxyHandler.class.getConstructor(String.class, cbClass, Gateway.class).newInstance(parts[0], cbClient, gateway);
        }
        PythonProxyHandler pythonProxyHandler3 = pythonProxyHandler;
        return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), (Class[])interfaces2.toArray(ClassTag$.MODULE$.apply(Class.class)), (InvocationHandler)pythonProxyHandler3);
    }

    private PythonInterpreter$() {
        MODULE$ = this;
        Logging.class.$init$((Logging)this);
    }
}

