/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.datastructure.queue.serializer;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Objects;
import java.util.function.Function;
import org.apache.iotdb.commons.pipe.datastructure.queue.ConcurrentIterableLinkedQueue;
import org.apache.iotdb.commons.pipe.datastructure.queue.serializer.QueueSerializer;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class PlainQueueSerializer<E>
implements QueueSerializer<E> {
    @Override
    public boolean writeQueueToFile(FileOutputStream fileOutputStream, ConcurrentIterableLinkedQueue<E> queue, Function<E, ByteBuffer> elementSerializationFunction) throws IOException {
        ReadWriteIOUtils.write((long)queue.getFirstIndex(), (OutputStream)fileOutputStream);
        try (ConcurrentIterableLinkedQueue.DynamicIterator itr = queue.iterateFromEarliest();){
            Object element;
            while (!Objects.isNull(element = itr.next(0L))) {
                ByteBuffer planBuffer = elementSerializationFunction.apply(element);
                ReadWriteIOUtils.write((ByteBuffer)planBuffer, (OutputStream)fileOutputStream);
            }
        }
        fileOutputStream.getFD().sync();
        return true;
    }

    @Override
    public void loadQueueFromFile(FileInputStream inputStream, ConcurrentIterableLinkedQueue<E> queue, Function<ByteBuffer, E> elementDeserializationFunction) throws IOException {
        try (FileChannel channel = inputStream.getChannel();){
            queue.setFirstIndex(ReadWriteIOUtils.readLong((InputStream)inputStream));
        }
    }
}

