/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.schema.view.viewExpression.multi;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpression;
import org.apache.iotdb.commons.schema.view.viewExpression.ViewExpressionType;
import org.apache.iotdb.commons.schema.view.viewExpression.visitor.ViewExpressionVisitor;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class FunctionViewExpression
extends ViewExpression {
    private final String functionName;
    private final List<String> functionAttributesKeyValueList;
    private List<ViewExpression> expressions;

    public FunctionViewExpression(String functionName) {
        this.functionName = functionName;
        this.functionAttributesKeyValueList = new ArrayList<String>();
        this.expressions = new ArrayList<ViewExpression>();
    }

    public FunctionViewExpression(String functionName, List<String> functionAttributeKeys, List<String> functionAttributeValues, List<ViewExpression> expressions) {
        this.functionName = functionName;
        this.functionAttributesKeyValueList = new ArrayList<String>();
        if (functionAttributeKeys.size() == functionAttributeValues.size()) {
            for (int i = 0; i < functionAttributeKeys.size(); ++i) {
                this.functionAttributesKeyValueList.add(functionAttributeKeys.get(i));
                this.functionAttributesKeyValueList.add(functionAttributeValues.get(i));
            }
        } else {
            String errorMsg = "Illegal parameters during FunctionExpression construction. Array length mismatch.";
            throw new RuntimeException(errorMsg);
        }
        this.expressions = expressions;
    }

    public FunctionViewExpression(ByteBuffer byteBuffer) {
        this.functionName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.functionAttributesKeyValueList = ReadWriteIOUtils.readStringList((ByteBuffer)byteBuffer);
        int expressionSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.expressions = new ArrayList<ViewExpression>();
        for (int i = 0; i < expressionSize; ++i) {
            this.expressions.add(ViewExpression.deserialize(byteBuffer));
        }
    }

    public FunctionViewExpression(InputStream inputStream) {
        try {
            this.functionName = ReadWriteIOUtils.readString((InputStream)inputStream);
            this.functionAttributesKeyValueList = ReadWriteIOUtils.readStringList((InputStream)inputStream);
            int expressionSize = ReadWriteIOUtils.readInt((InputStream)inputStream);
            this.expressions = new ArrayList<ViewExpression>();
            for (int i = 0; i < expressionSize; ++i) {
                this.expressions.add(ViewExpression.deserialize(inputStream));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <R, C> R accept(ViewExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionExpression(this, context);
    }

    @Override
    public ViewExpressionType getExpressionType() {
        return ViewExpressionType.FUNCTION;
    }

    @Override
    protected boolean isLeafOperandInternal() {
        return this.expressions.isEmpty();
    }

    @Override
    public List<ViewExpression> getChildViewExpressions() {
        return this.expressions;
    }

    @Override
    public String toString(boolean isRoot) {
        int i;
        StringBuilder result = new StringBuilder(this.functionName);
        int keyValueSize = this.functionAttributesKeyValueList.size();
        result.append("(");
        for (i = 0; i < this.expressions.size(); ++i) {
            result.append(this.expressions.get(i).toString());
            if (i + 1 >= this.expressions.size()) break;
            result.append(", ");
        }
        if (this.functionAttributesKeyValueList.size() > 1) {
            if (!this.expressions.isEmpty()) {
                result.append(", ");
            }
            i = 0;
            while (i + 1 < keyValueSize) {
                result.append(this.functionAttributesKeyValueList.get(i)).append("=").append(this.functionAttributesKeyValueList.get(i + 1));
                if (i + 2 >= keyValueSize) break;
                result.append(", ");
                i += 2;
            }
        }
        result.append(")");
        return result.toString();
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.functionName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.writeStringList(this.functionAttributesKeyValueList, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.expressions.size(), (ByteBuffer)byteBuffer);
        for (ViewExpression expression : this.expressions) {
            ViewExpression.serialize(expression, byteBuffer);
        }
    }

    @Override
    protected void serialize(OutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.functionName, (OutputStream)stream);
        ReadWriteIOUtils.writeStringList(this.functionAttributesKeyValueList, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.expressions.size(), (OutputStream)stream);
        for (ViewExpression expression : this.expressions) {
            ViewExpression.serialize(expression, stream);
        }
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public LinkedHashMap<String, String> getFunctionAttributes() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        int i = 0;
        while (i + 1 < this.functionAttributesKeyValueList.size()) {
            result.put(this.functionAttributesKeyValueList.get(i), this.functionAttributesKeyValueList.get(i + 1));
            i += 2;
        }
        return result;
    }

    public List<ViewExpression> getExpressions() {
        return this.expressions;
    }
}

