/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.operator;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.read.common.TimeRange;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.basic.OperatorType;
import org.apache.tsfile.utils.Binary;

public class Not
extends Filter {
    private final Filter filter;
    public static final String CONTAIN_NOT_ERR_MSG = "This predicate contains a not! Did you forget to run this predicate through PredicateRemoveNotRewriter? ";

    public Not(Filter filter) {
        this.filter = Objects.requireNonNull(filter, "filter cannot be null");
    }

    public Not(ByteBuffer buffer) {
        this.filter = Objects.requireNonNull(Filter.deserialize(buffer), "filter cannot be null");
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return !this.filter.satisfy(time, value);
    }

    @Override
    public boolean satisfyBoolean(long time, boolean value) {
        return !this.filter.satisfyBoolean(time, value);
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        return !this.filter.satisfyInteger(time, value);
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        return !this.filter.satisfyLong(time, value);
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        return !this.filter.satisfyFloat(time, value);
    }

    @Override
    public boolean satisfyDouble(long time, double value) {
        return !this.filter.satisfyDouble(time, value);
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        return !this.filter.satisfyBinary(time, value);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return !this.filter.satisfyRow(time, values);
    }

    @Override
    public boolean satisfyBooleanRow(long time, boolean[] values) {
        return !this.filter.satisfyBooleanRow(time, values);
    }

    @Override
    public boolean satisfyIntegerRow(long time, int[] values) {
        return !this.filter.satisfyIntegerRow(time, values);
    }

    @Override
    public boolean satisfyLongRow(long time, long[] values) {
        return !this.filter.satisfyLongRow(time, values);
    }

    @Override
    public boolean satisfyFloatRow(long time, float[] values) {
        return !this.filter.satisfyFloatRow(time, values);
    }

    @Override
    public boolean satisfyDoubleRow(long time, double[] values) {
        return !this.filter.satisfyDoubleRow(time, values);
    }

    @Override
    public boolean satisfyBinaryRow(long time, Binary[] values) {
        return !this.filter.satisfyBinaryRow(time, values);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] selection = new boolean[tsBlock.getPositionCount()];
        Arrays.fill(selection, true);
        return this.satisfyTsBlock(selection, tsBlock);
    }

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        boolean[] result = this.filter.satisfyTsBlock(selection, tsBlock);
        for (int i = 0; i < result.length; ++i) {
            result[i] = result[i] != selection[i];
        }
        return result;
    }

    @Override
    public boolean canSkip(IMetadata metadata) {
        throw new IllegalArgumentException(CONTAIN_NOT_ERR_MSG + this);
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        throw new IllegalArgumentException(CONTAIN_NOT_ERR_MSG + this);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        throw new IllegalArgumentException(CONTAIN_NOT_ERR_MSG + this);
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        throw new IllegalArgumentException(CONTAIN_NOT_ERR_MSG + this);
    }

    public Filter getFilter() {
        return this.filter;
    }

    @Override
    public List<TimeRange> getTimeRanges() {
        List<TimeRange> list = this.filter.getTimeRanges();
        if (list.isEmpty()) {
            return list;
        }
        ArrayList<TimeRange> res = new ArrayList<TimeRange>();
        if (list.get(0).getMin() != Long.MIN_VALUE) {
            res.add(new TimeRange(Long.MIN_VALUE, list.get(0).getMin() - 1L));
        }
        int size = list.size();
        for (int i = 1; i < size; ++i) {
            long right;
            long left = list.get(i - 1).getMax() + 1L;
            if (left > (right = list.get(i).getMin() - 1L)) continue;
            res.add(new TimeRange(left, right));
        }
        if (list.get(list.size() - 1).getMax() != Long.MAX_VALUE) {
            res.add(new TimeRange(list.get(list.size() - 1).getMax() + 1L, Long.MAX_VALUE));
        }
        return res;
    }

    @Override
    public Filter reverse() {
        return this.filter;
    }

    @Override
    public OperatorType getOperatorType() {
        return OperatorType.NOT;
    }

    @Override
    public void serialize(DataOutputStream outputStream) throws IOException {
        super.serialize(outputStream);
        this.filter.serialize(outputStream);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Not not = (Not)o;
        return this.filter.equals(not.filter);
    }

    public int hashCode() {
        return Objects.hash(this.filter);
    }

    public String toString() {
        return "not(" + this.filter + ")";
    }
}

