/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.session.subscription.consumer;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.apache.iotdb.rpc.subscription.exception.SubscriptionException;
import org.apache.iotdb.session.subscription.consumer.AsyncCommitCallback;
import org.apache.iotdb.session.subscription.consumer.SubscriptionConsumer;
import org.apache.iotdb.session.subscription.consumer.SubscriptionExecutorServiceManager;
import org.apache.iotdb.session.subscription.consumer.SubscriptionPushConsumer;
import org.apache.iotdb.session.subscription.payload.SubscriptionMessage;
import org.apache.iotdb.session.subscription.util.CollectionUtils;
import org.apache.iotdb.session.subscription.util.IdentifierUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SubscriptionPullConsumer
extends SubscriptionConsumer {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubscriptionPullConsumer.class);
    private final boolean autoCommit;
    private final long autoCommitIntervalMs;
    private SortedMap<Long, Set<SubscriptionMessage>> uncommittedMessages;
    private final AtomicBoolean isClosed = new AtomicBoolean(true);

    @Override
    boolean isClosed() {
        return this.isClosed.get();
    }

    protected SubscriptionPullConsumer(Builder builder) {
        super(builder);
        this.autoCommit = builder.autoCommit;
        this.autoCommitIntervalMs = builder.autoCommitIntervalMs;
    }

    public SubscriptionPullConsumer(Properties properties) {
        this(properties, (Boolean)properties.getOrDefault((Object)"auto-commit", (Object)true), (Long)properties.getOrDefault((Object)"auto-commit-interval-ms", (Object)5000L));
    }

    private SubscriptionPullConsumer(Properties properties, boolean autoCommit, long autoCommitIntervalMs) {
        super(new Builder().autoCommit(autoCommit).autoCommitIntervalMs(autoCommitIntervalMs), properties);
        this.autoCommit = autoCommit;
        this.autoCommitIntervalMs = Math.max(autoCommitIntervalMs, 500L);
    }

    @Override
    public synchronized void open() throws SubscriptionException {
        if (!this.isClosed.get()) {
            return;
        }
        super.open();
        this.isClosed.set(false);
        if (this.autoCommit) {
            this.uncommittedMessages = new ConcurrentSkipListMap<Long, Set<SubscriptionMessage>>();
            this.submitAutoCommitWorker();
        }
    }

    @Override
    public synchronized void close() {
        if (this.isClosed.get()) {
            return;
        }
        if (this.autoCommit) {
            this.commitAllUncommittedMessages();
        }
        super.close();
        this.isClosed.set(true);
    }

    public List<SubscriptionMessage> poll(Duration timeout) throws SubscriptionException {
        return this.poll(Collections.emptySet(), timeout.toMillis());
    }

    public List<SubscriptionMessage> poll(long timeoutMs) throws SubscriptionException {
        return this.poll(Collections.emptySet(), timeoutMs);
    }

    public List<SubscriptionMessage> poll(Set<String> topicNames, Duration timeout) throws SubscriptionException {
        return this.poll(topicNames, timeout.toMillis());
    }

    public List<SubscriptionMessage> poll(Set<String> topicNames, long timeoutMs) throws SubscriptionException {
        Set<Object> parsedTopicNames = topicNames.stream().map(IdentifierUtils::checkAndParseIdentifier).collect(Collectors.toSet());
        if (!parsedTopicNames.isEmpty()) {
            parsedTopicNames.stream().filter(topicName -> !this.subscribedTopics.containsKey(topicName)).forEach(topicName -> LOGGER.warn("SubscriptionPullConsumer {} does not subscribe to topic {}", (Object)this, topicName));
        } else {
            parsedTopicNames = this.subscribedTopics.keySet();
        }
        if (parsedTopicNames.isEmpty()) {
            return Collections.emptyList();
        }
        List<SubscriptionMessage> messages = this.multiplePoll(parsedTopicNames, timeoutMs);
        if (messages.isEmpty()) {
            LOGGER.info("SubscriptionPullConsumer {} poll empty message from topics {} after {} millisecond(s)", new Object[]{this, CollectionUtils.getLimitedString(parsedTopicNames, 32), timeoutMs});
            return messages;
        }
        if (this.autoCommit) {
            long currentTimestamp = System.currentTimeMillis();
            long index = currentTimestamp / this.autoCommitIntervalMs;
            if (currentTimestamp % this.autoCommitIntervalMs == 0L) {
                --index;
            }
            this.uncommittedMessages.computeIfAbsent(index, o -> new ConcurrentSkipListSet()).addAll(messages);
        }
        return messages;
    }

    public void commitSync(SubscriptionMessage message) throws SubscriptionException {
        super.ack(Collections.singletonList(message));
    }

    public void commitSync(Iterable<SubscriptionMessage> messages) throws SubscriptionException {
        super.ack(messages);
    }

    public CompletableFuture<Void> commitAsync(SubscriptionMessage message) {
        return super.commitAsync(Collections.singletonList(message));
    }

    @Override
    public CompletableFuture<Void> commitAsync(Iterable<SubscriptionMessage> messages) {
        return super.commitAsync(messages);
    }

    public void commitAsync(SubscriptionMessage message, AsyncCommitCallback callback) {
        super.commitAsync(Collections.singletonList(message), callback);
    }

    @Override
    public void commitAsync(Iterable<SubscriptionMessage> messages, AsyncCommitCallback callback) {
        super.commitAsync(messages, callback);
    }

    private void submitAutoCommitWorker() {
        ScheduledFuture[] future;
        future = new ScheduledFuture[]{SubscriptionExecutorServiceManager.submitAutoCommitWorker(() -> {
            if (this.isClosed()) {
                if (Objects.nonNull(future[0])) {
                    future[0].cancel(false);
                    LOGGER.info("SubscriptionPullConsumer {} cancel auto commit worker", (Object)this);
                }
                return;
            }
            new AutoCommitWorker().run();
        }, this.autoCommitIntervalMs)};
        LOGGER.info("SubscriptionPullConsumer {} submit auto commit worker", (Object)this);
    }

    private void commitAllUncommittedMessages() {
        for (Map.Entry<Long, Set<SubscriptionMessage>> entry : this.uncommittedMessages.entrySet()) {
            try {
                this.ack((Iterable<SubscriptionMessage>)entry.getValue());
                this.uncommittedMessages.remove(entry.getKey());
            }
            catch (Exception e) {
                LOGGER.warn("something unexpected happened when commit messages during close", (Throwable)e);
            }
        }
    }

    public String toString() {
        return "SubscriptionPullConsumer" + this.coreReportMessage();
    }

    @Override
    protected Map<String, String> coreReportMessage() {
        Map<String, String> coreReportMessage = super.coreReportMessage();
        coreReportMessage.put("autoCommit", String.valueOf(this.autoCommit));
        return coreReportMessage;
    }

    @Override
    protected Map<String, String> allReportMessage() {
        Map<String, String> allReportMessage = super.allReportMessage();
        allReportMessage.put("autoCommit", String.valueOf(this.autoCommit));
        allReportMessage.put("autoCommitIntervalMs", String.valueOf(this.autoCommitIntervalMs));
        if (this.autoCommit) {
            allReportMessage.put("uncommittedMessages", this.uncommittedMessages.toString());
        }
        return allReportMessage;
    }

    public static class Builder
    extends SubscriptionConsumer.Builder {
        private boolean autoCommit = true;
        private long autoCommitIntervalMs = 5000L;

        @Override
        public Builder host(String host) {
            super.host(host);
            return this;
        }

        @Override
        public Builder port(int port) {
            super.port(port);
            return this;
        }

        @Override
        public Builder nodeUrls(List<String> nodeUrls) {
            super.nodeUrls(nodeUrls);
            return this;
        }

        @Override
        public Builder username(String username) {
            super.username(username);
            return this;
        }

        @Override
        public Builder password(String password) {
            super.password(password);
            return this;
        }

        @Override
        public Builder consumerId(String consumerId) {
            super.consumerId(consumerId);
            return this;
        }

        @Override
        public Builder consumerGroupId(String consumerGroupId) {
            super.consumerGroupId(consumerGroupId);
            return this;
        }

        @Override
        public Builder heartbeatIntervalMs(long heartbeatIntervalMs) {
            super.heartbeatIntervalMs(heartbeatIntervalMs);
            return this;
        }

        @Override
        public Builder endpointsSyncIntervalMs(long endpointsSyncIntervalMs) {
            super.endpointsSyncIntervalMs(endpointsSyncIntervalMs);
            return this;
        }

        @Override
        public Builder fileSaveDir(String fileSaveDir) {
            super.fileSaveDir(fileSaveDir);
            return this;
        }

        @Override
        public Builder fileSaveFsync(boolean fileSaveFsync) {
            super.fileSaveFsync(fileSaveFsync);
            return this;
        }

        @Override
        public Builder thriftMaxFrameSize(int thriftMaxFrameSize) {
            super.thriftMaxFrameSize(thriftMaxFrameSize);
            return this;
        }

        @Override
        public Builder maxPollParallelism(int maxPollParallelism) {
            super.maxPollParallelism(maxPollParallelism);
            return this;
        }

        public Builder autoCommit(boolean autoCommit) {
            this.autoCommit = autoCommit;
            return this;
        }

        public Builder autoCommitIntervalMs(long autoCommitIntervalMs) {
            this.autoCommitIntervalMs = Math.max(autoCommitIntervalMs, 500L);
            return this;
        }

        @Override
        public SubscriptionPullConsumer buildPullConsumer() {
            return new SubscriptionPullConsumer(this);
        }

        @Override
        public SubscriptionPushConsumer buildPushConsumer() {
            throw new SubscriptionException("SubscriptionPullConsumer.Builder do not support build push consumer.");
        }
    }

    private class AutoCommitWorker
    implements Runnable {
        private AutoCommitWorker() {
        }

        @Override
        public void run() {
            if (SubscriptionPullConsumer.this.isClosed()) {
                return;
            }
            long currentTimestamp = System.currentTimeMillis();
            long index = currentTimestamp / SubscriptionPullConsumer.this.autoCommitIntervalMs;
            if (currentTimestamp % SubscriptionPullConsumer.this.autoCommitIntervalMs == 0L) {
                --index;
            }
            for (Map.Entry entry : SubscriptionPullConsumer.this.uncommittedMessages.headMap(index).entrySet()) {
                try {
                    SubscriptionPullConsumer.this.ack((Iterable)entry.getValue());
                    SubscriptionPullConsumer.this.uncommittedMessages.remove(entry.getKey());
                }
                catch (Exception e) {
                    LOGGER.warn("something unexpected happened when auto commit messages...", (Throwable)e);
                }
            }
        }
    }
}

