/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.udf.api.relational.table.specification;

import java.util.Optional;
import org.apache.iotdb.udf.api.relational.table.specification.ParameterSpecification;

public class TableParameterSpecification
extends ParameterSpecification {
    private final boolean rowSemantics;
    private final boolean passThroughColumns;

    private TableParameterSpecification(String name, boolean rowSemantics, boolean passThroughColumns) {
        super(name, true, Optional.empty());
        this.rowSemantics = rowSemantics;
        this.passThroughColumns = passThroughColumns;
    }

    public boolean isRowSemantics() {
        return this.rowSemantics;
    }

    public boolean isPassThroughColumns() {
        return this.passThroughColumns;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String name;
        private boolean rowSemantics;
        private boolean passThroughColumns;

        private Builder() {
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public Builder setSemantics() {
            this.rowSemantics = false;
            return this;
        }

        public Builder rowSemantics() {
            this.rowSemantics = true;
            return this;
        }

        public Builder passThroughColumns() {
            this.passThroughColumns = true;
            return this;
        }

        public TableParameterSpecification build() {
            return new TableParameterSpecification(this.name, this.rowSemantics, this.passThroughColumns);
        }
    }
}

