/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tool.common;

import org.apache.iotdb.cli.utils.IoTPrinter;

public enum ImportTsFileOperation {
    NONE,
    MV,
    HARDLINK,
    CP,
    DELETE;


    public static boolean isValidOperation(String operation) {
        return "none".equalsIgnoreCase(operation) || "mv".equalsIgnoreCase(operation) || "cp".equalsIgnoreCase(operation) || "delete".equalsIgnoreCase(operation);
    }

    public static ImportTsFileOperation getOperation(String operation, boolean isFileStoreEquals) {
        switch (operation.toLowerCase()) {
            case "none": {
                return NONE;
            }
            case "mv": {
                return MV;
            }
            case "cp": {
                if (isFileStoreEquals) {
                    return HARDLINK;
                }
                return CP;
            }
            case "delete": {
                return DELETE;
            }
        }
        new IoTPrinter(System.out).println("Args error: os/of must be one of none, mv, cp, delete");
        System.exit(1);
        return null;
    }
}

