/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.pipe.source.dataregion;

import org.apache.iotdb.db.pipe.event.common.watermark.PipeWatermarkEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataRegionWatermarkInjector {
    private static final Logger LOGGER = LoggerFactory.getLogger(DataRegionWatermarkInjector.class);
    public static final long MIN_INJECTION_INTERVAL_IN_MS = 30000L;
    private final int regionId;
    private final long injectionIntervalInMs;
    private long nextInjectionTime;

    public DataRegionWatermarkInjector(int regionId, long injectionIntervalInMs) {
        this.regionId = regionId;
        this.injectionIntervalInMs = Math.max(injectionIntervalInMs, 30000L) / 30000L * 30000L;
        this.nextInjectionTime = DataRegionWatermarkInjector.calculateNextInjectionTime(this.injectionIntervalInMs);
    }

    public long getInjectionIntervalInMs() {
        return this.injectionIntervalInMs;
    }

    public PipeWatermarkEvent inject() {
        if (System.currentTimeMillis() < this.nextInjectionTime) {
            return null;
        }
        try {
            PipeWatermarkEvent watermarkEvent = new PipeWatermarkEvent(this.nextInjectionTime);
            this.nextInjectionTime = DataRegionWatermarkInjector.calculateNextInjectionTime(this.injectionIntervalInMs);
            PipeWatermarkEvent pipeWatermarkEvent = watermarkEvent;
            return pipeWatermarkEvent;
        }
        finally {
            LOGGER.info("Data region {}: Injected watermark event with timestamp: {}", (Object)this.regionId, (Object)this.nextInjectionTime);
        }
    }

    private static long calculateNextInjectionTime(long injectionIntervalInMs) {
        long currentTime = System.currentTimeMillis();
        return currentTime / injectionIntervalInMs * injectionIntervalInMs + injectionIntervalInMs;
    }
}

