/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.ProjectNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class EliminateLimitProjectWithTableScan
implements Rule<LimitNode> {
    private static final Capture<ProjectNode> PROJECT = Capture.newCapture();
    private static final Capture<TableScanNode> TABLE_SCAN_NODE = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.project().capturedAs(PROJECT).with(Patterns.source().matching(Patterns.tableScan().capturedAs(TABLE_SCAN_NODE)))));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        ProjectNode projectNode = captures.get(PROJECT);
        TableScanNode tableScanNode = captures.get(TABLE_SCAN_NODE);
        if (tableScanNode instanceof DeviceTableScanNode && ((DeviceTableScanNode)tableScanNode).isPushLimitToEachDevice()) {
            return Rule.Result.empty();
        }
        if (parent.getCount() == tableScanNode.getPushDownLimit()) {
            return Rule.Result.ofPlanNode(projectNode);
        }
        return Rule.Result.empty();
    }
}

