/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.optimizations;

import java.util.Collections;
import java.util.List;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.commons.client.exception.ClientManagerException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.confignode.rpc.thrift.TGetDataNodeLocationsResp;
import org.apache.iotdb.db.protocol.client.ConfigNodeClient;
import org.apache.iotdb.db.protocol.client.ConfigNodeClientManager;
import org.apache.iotdb.db.protocol.client.ConfigNodeInfo;
import org.apache.iotdb.db.queryengine.common.DataNodeEndPoints;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;

public class DataNodeLocationSupplierFactory {
    private DataNodeLocationSupplierFactory() {
    }

    public static DataNodeLocationSupplier getSupplier() {
        return InformationSchemaTableDataNodeLocationSupplier.getInstance();
    }

    public static List<TDataNodeLocation> getReadableDataNodeLocations() {
        ConfigNodeClient client = (ConfigNodeClient)ConfigNodeClientManager.getInstance().borrowClient((Object)ConfigNodeInfo.CONFIG_REGION_ID);
        try {
            TGetDataNodeLocationsResp showDataNodesResp = client.getReadableDataNodeLocations();
            if (showDataNodesResp.getStatus().getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                throw new IoTDBRuntimeException("An error occurred when executing getReadableDataNodeLocations():" + showDataNodesResp.getStatus().getMessage(), TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
            }
            List list = showDataNodesResp.getDataNodeLocationList();
            if (client != null) {
                client.close();
            }
            return list;
        }
        catch (Throwable throwable) {
            try {
                if (client != null) {
                    try {
                        client.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                }
                throw throwable;
            }
            catch (ClientManagerException | TException e) {
                throw new IoTDBRuntimeException("An error occurred when executing getReadableDataNodeLocations():" + e.getMessage(), TSStatusCode.QUERY_PROCESS_ERROR.getStatusCode());
            }
        }
    }

    private static class InformationSchemaTableDataNodeLocationSupplier
    implements DataNodeLocationSupplier {
        private InformationSchemaTableDataNodeLocationSupplier() {
        }

        private static InformationSchemaTableDataNodeLocationSupplier getInstance() {
            return SingletonHolder.INSTANCE;
        }

        @Override
        public List<TDataNodeLocation> getDataNodeLocations(String tableName) {
            switch (tableName) {
                case "queries": {
                    return DataNodeLocationSupplierFactory.getReadableDataNodeLocations();
                }
                case "databases": 
                case "tables": 
                case "columns": 
                case "regions": 
                case "pipes": 
                case "pipe_plugins": 
                case "topics": 
                case "subscriptions": 
                case "views": 
                case "models": 
                case "functions": 
                case "configurations": 
                case "keywords": 
                case "nodes": 
                case "config_nodes": 
                case "data_nodes": {
                    return Collections.singletonList(DataNodeEndPoints.getLocalDataNodeLocation());
                }
            }
            throw new UnsupportedOperationException("Unknown table: " + tableName);
        }

        private static class SingletonHolder {
            private static final InformationSchemaTableDataNodeLocationSupplier INSTANCE = new InformationSchemaTableDataNodeLocationSupplier();

            private SingletonHolder() {
            }
        }
    }

    public static interface DataNodeLocationSupplier {
        public List<TDataNodeLocation> getDataNodeLocations(String var1);
    }
}

