/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tsfile.read.filter.basic;

import java.io.Serializable;
import org.apache.tsfile.file.metadata.IMetadata;
import org.apache.tsfile.file.metadata.statistics.Statistics;
import org.apache.tsfile.read.common.block.TsBlock;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.utils.Binary;

public abstract class TimeFilter
extends Filter {
    protected TimeFilter() {
    }

    @Override
    public boolean satisfy(long time, Object value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyBoolean(long time, boolean value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyInteger(long time, int value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyLong(long time, long value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyFloat(long time, float value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyDouble(long time, double value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyBinary(long time, Binary value) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyRow(long time, Object[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyBooleanRow(long time, boolean[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyIntegerRow(long time, int[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyLongRow(long time, long[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyFloatRow(long time, float[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyDoubleRow(long time, double[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean satisfyBinaryRow(long time, Binary[] values) {
        return this.timeSatisfy(time);
    }

    @Override
    public boolean[] satisfyTsBlock(TsBlock tsBlock) {
        boolean[] satisfyInfo = new boolean[tsBlock.getPositionCount()];
        for (int i = 0; i < tsBlock.getPositionCount(); ++i) {
            satisfyInfo[i] = this.timeSatisfy(tsBlock.getTimeByIndex(i));
        }
        return satisfyInfo;
    }

    @Override
    public boolean[] satisfyTsBlock(boolean[] selection, TsBlock tsBlock) {
        boolean[] satisfyInfo = new boolean[selection.length];
        System.arraycopy(selection, 0, satisfyInfo, 0, selection.length);
        for (int i = 0; i < selection.length; ++i) {
            if (!selection[i]) continue;
            satisfyInfo[i] = this.timeSatisfy(tsBlock.getTimeByIndex(i));
        }
        return satisfyInfo;
    }

    public abstract boolean timeSatisfy(long var1);

    @Override
    public boolean canSkip(IMetadata metadata) {
        Statistics<? extends Serializable> timeStatistics = metadata.getTimeStatistics();
        return !this.satisfyStartEndTime(timeStatistics.getStartTime(), timeStatistics.getEndTime());
    }

    @Override
    public boolean allSatisfy(IMetadata metadata) {
        Statistics<? extends Serializable> timeStatistics = metadata.getTimeStatistics();
        return this.containStartEndTime(timeStatistics.getStartTime(), timeStatistics.getEndTime());
    }
}

