/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.buffer;

import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.iotdb.commons.schema.node.role.IDatabaseMNode;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.buffer.INodeBuffer;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.memory.cache.CacheEntry;
import org.apache.iotdb.db.schemaengine.schemaregion.mtree.impl.pbtree.mnode.ICachedMNode;

public class NodeBuffer
implements INodeBuffer {
    private static final int MAP_NUM = 17;
    private IDatabaseMNode<ICachedMNode> updatedDatabaseMNode;
    private final Map<CacheEntry, ICachedMNode>[] maps = new Map[17];

    public NodeBuffer() {
        for (int i = 0; i < 17; ++i) {
            this.maps[i] = new ConcurrentHashMap<CacheEntry, ICachedMNode>();
        }
    }

    @Override
    public IDatabaseMNode<ICachedMNode> getUpdatedDatabaseMNode() {
        return this.updatedDatabaseMNode;
    }

    @Override
    public void updateDatabaseNodeAfterStatusUpdate(IDatabaseMNode<ICachedMNode> updatedDatabaseMNode) {
        this.updatedDatabaseMNode = updatedDatabaseMNode;
    }

    @Override
    public void removeUpdatedDatabaseNode() {
        this.updatedDatabaseMNode = null;
    }

    @Override
    public void addNewNodeToBuffer(ICachedMNode node) {
        this.addNonVolatileAncestorToBuffer(node);
    }

    @Override
    public void addUpdatedNodeToBuffer(ICachedMNode node) {
        this.remove(node.getCacheEntry());
        this.addNonVolatileAncestorToBuffer(node);
    }

    @Override
    public void addBackToBufferAfterFlushFailure(ICachedMNode subTreeRoot) {
        this.put(subTreeRoot.getCacheEntry(), subTreeRoot);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNonVolatileAncestorToBuffer(ICachedMNode node) {
        CacheEntry cacheEntry;
        ICachedMNode parent = (ICachedMNode)node.getParent();
        CacheEntry cacheEntry2 = cacheEntry = parent.getCacheEntry();
        synchronized (cacheEntry2) {
            if (!cacheEntry.isVolatile()) {
                this.put(cacheEntry, parent);
            }
        }
    }

    private void put(CacheEntry cacheEntry, ICachedMNode node) {
        this.maps[this.getLoc(cacheEntry)].put(cacheEntry, node);
    }

    @Override
    public void remove(CacheEntry cacheEntry) {
        this.maps[this.getLoc(cacheEntry)].remove(cacheEntry);
    }

    @Override
    public long getBufferNodeNum() {
        long res = this.updatedDatabaseMNode == null ? 0L : 1L;
        for (int i = 0; i < 17; ++i) {
            res += (long)this.maps[i].size();
        }
        return res;
    }

    @Override
    public void clear() {
        for (Map<CacheEntry, ICachedMNode> map : this.maps) {
            map.clear();
        }
    }

    private int getLoc(CacheEntry cacheEntry) {
        int hash = cacheEntry.hashCode() % 17;
        return hash < 0 ? hash + 17 : hash;
    }

    @Override
    public Iterator<ICachedMNode> iterator() {
        return new NodeBufferIterator();
    }

    private class NodeBufferIterator
    implements Iterator<ICachedMNode> {
        volatile int mapIndex = 0;
        Iterator<ICachedMNode> currentIterator = NodeBuffer.access$100(NodeBuffer.this)[0].values().iterator();
        ICachedMNode nextNode = null;

        private NodeBufferIterator() {
        }

        @Override
        public boolean hasNext() {
            if (this.nextNode == null) {
                this.tryGetNext();
            }
            return this.nextNode != null;
        }

        @Override
        public ICachedMNode next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ICachedMNode result = this.nextNode;
            this.nextNode = null;
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void tryGetNext() {
            if (this.mapIndex >= NodeBuffer.this.maps.length) {
                return;
            }
            while (!this.currentIterator.hasNext()) {
                this.currentIterator = null;
                NodeBufferIterator nodeBufferIterator = this;
                synchronized (nodeBufferIterator) {
                    ++this.mapIndex;
                }
                if (this.mapIndex == NodeBuffer.this.maps.length) {
                    return;
                }
                this.currentIterator = NodeBuffer.this.maps[this.mapIndex].values().iterator();
            }
            this.nextNode = this.currentIterator.next();
        }
    }
}

