/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.version;

import javax.jcr.RepositoryException;
import org.apache.commons.collections4.map.AbstractReferenceMap;
import org.apache.commons.collections4.map.ReferenceMap;
import org.apache.jackrabbit.core.id.ItemId;
import org.apache.jackrabbit.core.id.NodeId;
import org.apache.jackrabbit.core.state.ChangeLog;
import org.apache.jackrabbit.core.state.ItemState;
import org.apache.jackrabbit.core.state.ItemStateException;
import org.apache.jackrabbit.core.state.ItemStateListener;
import org.apache.jackrabbit.core.state.NoSuchItemStateException;
import org.apache.jackrabbit.core.state.NodeReferences;
import org.apache.jackrabbit.core.version.VersionItemStateManager;
import org.apache.jackrabbit.core.virtual.VirtualItemStateProvider;
import org.apache.jackrabbit.core.virtual.VirtualNodeState;
import org.apache.jackrabbit.core.virtual.VirtualPropertyState;
import org.apache.jackrabbit.spi.Name;

class VersionItemStateProvider
implements VirtualItemStateProvider,
ItemStateListener {
    private final NodeId historyRootId;
    private final NodeId activitiesRootId;
    private final VersionItemStateManager stateMgr;
    private ReferenceMap<ItemId, ItemState> items = new ReferenceMap(AbstractReferenceMap.ReferenceStrength.HARD, AbstractReferenceMap.ReferenceStrength.WEAK);

    public VersionItemStateProvider(NodeId historyRootId, NodeId activitiesRootId, VersionItemStateManager stateMgr) {
        this.historyRootId = historyRootId;
        this.activitiesRootId = activitiesRootId;
        this.stateMgr = stateMgr;
        stateMgr.addListener(this);
    }

    @Override
    public boolean isVirtualRoot(ItemId id) {
        return id.equals(this.historyRootId) || id.equals(this.activitiesRootId);
    }

    @Override
    public NodeId getVirtualRootId() {
        return this.historyRootId;
    }

    @Override
    public NodeId[] getVirtualRootIds() {
        return new NodeId[]{this.historyRootId, this.activitiesRootId};
    }

    @Override
    public VirtualPropertyState createPropertyState(VirtualNodeState parent, Name name, int type, boolean multiValued) throws RepositoryException {
        throw new IllegalStateException("InternalVersionManager should never create a VirtualPropertyState");
    }

    @Override
    public VirtualNodeState createNodeState(VirtualNodeState parent, Name name, NodeId id, Name nodeTypeName) throws RepositoryException {
        throw new IllegalStateException("InternalVersionManager should never create a VirtualNodeState");
    }

    @Override
    public synchronized ItemState getItemState(ItemId id) throws NoSuchItemStateException, ItemStateException {
        ItemState item = (ItemState)this.items.get(id);
        if (item == null) {
            item = this.stateMgr.getItemState(id);
            this.items.put(id, item);
        }
        return item;
    }

    @Override
    public boolean setNodeReferences(ChangeLog references) {
        return this.stateMgr.setNodeReferences(references);
    }

    @Override
    public boolean hasItemState(ItemId id) {
        return this.items.get(id) != null || this.stateMgr.hasItemState(id);
    }

    @Override
    public NodeReferences getNodeReferences(NodeId id) throws NoSuchItemStateException, ItemStateException {
        return this.stateMgr.getNodeReferences(id);
    }

    @Override
    public boolean hasNodeReferences(NodeId id) {
        return this.stateMgr.hasNodeReferences(id);
    }

    @Override
    public void addListener(ItemStateListener listener) {
        this.stateMgr.addListener(listener);
    }

    @Override
    public void removeListener(ItemStateListener listener) {
        this.stateMgr.removeListener(listener);
    }

    @Override
    public void stateCreated(ItemState created) {
    }

    @Override
    public void stateModified(ItemState modified) {
    }

    @Override
    public void stateDestroyed(ItemState destroyed) {
        this.items.remove(destroyed.getId());
    }

    @Override
    public void stateDiscarded(ItemState discarded) {
        this.items.remove(discarded.getId());
    }
}

