/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.standalone.cli.core;

import javax.jcr.Item;
import javax.jcr.Session;
import org.apache.commons.chain.Command;
import org.apache.commons.chain.Context;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.jackrabbit.standalone.cli.CommandHelper;

public class Rename
implements Command {
    private static Log log = LogFactory.getLog(Rename.class);
    private String srcPathKey = "srcPath";
    private String destPathKey = "destPath";
    private String persistentKey = "persistent";

    @Override
    public boolean execute(Context ctx) throws Exception {
        String from = (String)ctx.get(this.srcPathKey);
        String to = (String)ctx.get(this.destPathKey);
        boolean persistent = Boolean.valueOf((String)ctx.get(this.persistentKey));
        if (log.isDebugEnabled()) {
            log.debug("renaming node from " + from + " to " + to);
        }
        Session s = CommandHelper.getSession(ctx);
        Item itemFrom = CommandHelper.getItem(ctx, from);
        if (itemFrom.getDepth() == 1) {
            if (persistent) {
                s.getWorkspace().move(itemFrom.getPath(), "/" + to);
            } else {
                s.move(itemFrom.getPath(), "/" + to);
            }
        } else if (persistent) {
            s.getWorkspace().move(itemFrom.getPath(), itemFrom.getParent().getPath() + "/" + to);
        } else {
            s.move(itemFrom.getPath(), itemFrom.getParent().getPath() + "/" + to);
        }
        return false;
    }

    public String getDestPathKey() {
        return this.destPathKey;
    }

    public void setDestPathKey(String destPathKey) {
        this.destPathKey = destPathKey;
    }

    public String getSrcPathKey() {
        return this.srcPathKey;
    }

    public void setSrcPathKey(String srcPathKey) {
        this.srcPathKey = srcPathKey;
    }

    public String getPersistentKey() {
        return this.persistentKey;
    }

    public void setPersistentKey(String persistentKey) {
        this.persistentKey = persistentKey;
    }
}

