/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.s3.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.RequiredTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.s3.model.ExpirationState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RecordExpiration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RecordExpiration> {
    private static final SdkField<String> EXPIRATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Expiration").getter(RecordExpiration.getter(RecordExpiration::expirationAsString)).setter(RecordExpiration.setter(Builder::expiration)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Expiration").unmarshallLocationName("Expiration").build(), RequiredTrait.create()}).build();
    private static final SdkField<Integer> DAYS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("Days").getter(RecordExpiration.getter(RecordExpiration::days)).setter(RecordExpiration.setter(Builder::days)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Days").unmarshallLocationName("Days").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXPIRATION_FIELD, DAYS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RecordExpiration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String expiration;
    private final Integer days;

    private RecordExpiration(BuilderImpl builder) {
        this.expiration = builder.expiration;
        this.days = builder.days;
    }

    public final ExpirationState expiration() {
        return ExpirationState.fromValue(this.expiration);
    }

    public final String expirationAsString() {
        return this.expiration;
    }

    public final Integer days() {
        return this.days;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.expirationAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.days());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RecordExpiration)) {
            return false;
        }
        RecordExpiration other = (RecordExpiration)obj;
        return Objects.equals(this.expirationAsString(), other.expirationAsString()) && Objects.equals(this.days(), other.days());
    }

    public final String toString() {
        return ToString.builder((String)"RecordExpiration").add("Expiration", (Object)this.expirationAsString()).add("Days", (Object)this.days()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Expiration": {
                return Optional.ofNullable(clazz.cast(this.expirationAsString()));
            }
            case "Days": {
                return Optional.ofNullable(clazz.cast(this.days()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("Expiration", EXPIRATION_FIELD);
        map.put("Days", DAYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RecordExpiration, T> g) {
        return obj -> g.apply((RecordExpiration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String expiration;
        private Integer days;

        private BuilderImpl() {
        }

        private BuilderImpl(RecordExpiration model) {
            this.expiration(model.expiration);
            this.days(model.days);
        }

        public final String getExpiration() {
            return this.expiration;
        }

        public final void setExpiration(String expiration) {
            this.expiration = expiration;
        }

        @Override
        public final Builder expiration(String expiration) {
            this.expiration = expiration;
            return this;
        }

        @Override
        public final Builder expiration(ExpirationState expiration) {
            this.expiration(expiration == null ? null : expiration.toString());
            return this;
        }

        public final Integer getDays() {
            return this.days;
        }

        public final void setDays(Integer days) {
            this.days = days;
        }

        @Override
        public final Builder days(Integer days) {
            this.days = days;
            return this;
        }

        public RecordExpiration build() {
            return new RecordExpiration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RecordExpiration> {
        public Builder expiration(String var1);

        public Builder expiration(ExpirationState var1);

        public Builder days(Integer var1);
    }
}

