/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.transport.mailets.jsieve;

import jakarta.mail.MessagingException;
import org.apache.james.core.MailAddress;
import org.apache.james.lifecycle.api.LifecycleUtil;
import org.apache.james.server.core.MailImpl;
import org.apache.james.transport.mailets.jsieve.ActionContext;
import org.apache.james.transport.mailets.jsieve.ActionUtils;
import org.apache.james.transport.mailets.jsieve.DiscardAction;
import org.apache.james.transport.mailets.jsieve.MailAction;
import org.apache.jsieve.mail.Action;
import org.apache.jsieve.mail.ActionRedirect;
import org.apache.mailet.Mail;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedirectAction
implements MailAction {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)RedirectAction.class.getName());

    @Override
    public void execute(Action action, Mail mail, ActionContext context) throws MessagingException {
        if (action instanceof ActionRedirect) {
            ActionRedirect actionRedirect = (ActionRedirect)action;
            this.execute(actionRedirect, mail, context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ActionRedirect anAction, Mail aMail, ActionContext context) throws MessagingException {
        ActionUtils.detectAndHandleLocalLooping(aMail, context, "redirect");
        MailImpl redirectedMail = MailImpl.builder().name("redirect-" + aMail.getName()).sender(aMail.getMaybeSender()).addRecipient(new MailAddress(anAction.getAddress())).mimeMessage(aMail.getMessage()).build();
        try {
            context.post((Mail)redirectedMail);
        }
        finally {
            LifecycleUtil.dispose((Object)redirectedMail);
        }
        LOGGER.debug("Redirected Message ID: {} to \"{}\"", (Object)aMail.getMessage().getMessageID(), (Object)anAction.getAddress());
        DiscardAction.removeRecipient(aMail, context);
    }
}

