/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wiki.tags;

import java.io.IOException;
import javax.servlet.jsp.JspWriter;
import org.apache.wiki.api.core.Attachment;
import org.apache.wiki.api.core.ContextEnum;
import org.apache.wiki.api.core.Page;
import org.apache.wiki.attachment.AttachmentManager;
import org.apache.wiki.tags.WikiLinkTag;

public class LinkToTag
extends WikiLinkTag {
    private static final long serialVersionUID = 0L;
    private String m_version;
    public String m_title = "";
    public String m_accesskey = "";

    @Override
    public void initTag() {
        super.initTag();
        this.m_version = null;
    }

    public String getVersion() {
        return this.m_version;
    }

    public void setVersion(String arg) {
        this.m_version = arg;
    }

    public void setTitle(String title) {
        this.m_title = title;
    }

    public void setAccesskey(String access) {
        this.m_accesskey = access;
    }

    @Override
    public int doWikiStartTag() throws IOException {
        String linkclass;
        String url;
        String pageName = this.m_pageName;
        boolean isattachment = false;
        if (this.m_pageName == null) {
            Page p = this.m_wikiContext.getPage();
            if (p != null) {
                pageName = p.getName();
                isattachment = p instanceof Attachment;
            } else {
                return 0;
            }
        }
        JspWriter out = this.pageContext.getOut();
        String forceDownload = "";
        if (isattachment) {
            url = this.m_wikiContext.getURL(ContextEnum.PAGE_ATTACH.getRequestContext(), pageName, this.getVersion() != null ? "version=" + this.getVersion() : null);
            linkclass = "attachment";
            if (((AttachmentManager)this.m_wikiContext.getEngine().getManager(AttachmentManager.class)).forceDownload(pageName)) {
                forceDownload = "download ";
            }
        } else {
            StringBuilder params = new StringBuilder();
            if (this.getVersion() != null) {
                params.append("version=").append(this.getVersion());
            }
            if (this.getTemplate() != null) {
                params.append(params.length() > 0 ? "&amp;" : "").append("skin=").append(this.getTemplate());
            }
            url = this.m_wikiContext.getURL(ContextEnum.PAGE_VIEW.getRequestContext(), pageName, params.toString());
            linkclass = "wikipage";
        }
        switch (this.m_format) {
            case 0: {
                out.print("<a class=\"" + linkclass + "\" href=\"" + url + "\" accesskey=\"" + this.m_accesskey + "\" title=\"" + this.m_title + "\" " + forceDownload + ">");
                break;
            }
            case 1: {
                out.print(url);
            }
        }
        return 1;
    }
}

