/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.junit.bct;

import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Future;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.juneau.commons.reflect.ReflectionUtils;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.ThrowableUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.junit.bct.BeanConverter;
import org.apache.juneau.junit.bct.Listifier;
import org.apache.juneau.junit.bct.Listifiers;
import org.apache.juneau.junit.bct.NestedTokenizer;
import org.apache.juneau.junit.bct.PropertyExtractor;
import org.apache.juneau.junit.bct.PropertyExtractors;
import org.apache.juneau.junit.bct.Sizer;
import org.apache.juneau.junit.bct.Stringifier;
import org.apache.juneau.junit.bct.Stringifiers;
import org.apache.juneau.junit.bct.Swapper;
import org.apache.juneau.junit.bct.Swappers;

public class BasicBeanConverter
implements BeanConverter {
    public static final BasicBeanConverter DEFAULT = BasicBeanConverter.builder().defaultSettings().build();
    public static final String SETTING_nullValue = "nullValue";
    public static final String SETTING_selfValue = "selfValue";
    public static final String SETTING_fieldSeparator = "fieldSeparator";
    public static final String SETTING_collectionPrefix = "collectionPrefix";
    public static final String SETTING_collectionSuffix = "collectionSuffix";
    public static final String SETTING_mapPrefix = "mapPrefix";
    public static final String SETTING_mapSuffix = "mapSuffix";
    public static final String SETTING_mapEntrySeparator = "mapEntrySeparator";
    public static final String SETTING_calendarFormat = "calendarFormat";
    public static final String SETTING_classNameFormat = "classNameFormat";
    private final List<StringifierEntry<?>> stringifiers;
    private final List<ListifierEntry<?>> listifiers;
    private final List<SizerEntry<?>> sizers;
    private final List<SwapperEntry<?>> swappers;
    private final List<PropertyExtractor> propertyExtractors;
    private final Map<String, Object> settings;
    private final ConcurrentHashMap<Class, Optional<Stringifier<?>>> stringifierMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class, Optional<Listifier<?>>> listifierMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class, Optional<Sizer<?>>> sizerMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<Class, Optional<Swapper<?>>> swapperMap = new ConcurrentHashMap();

    public static Builder builder() {
        return new Builder();
    }

    protected BasicBeanConverter(Builder b) {
        this.stringifiers = CollectionUtils.copyOf(b.stringifiers);
        this.listifiers = CollectionUtils.copyOf(b.listifiers);
        this.sizers = CollectionUtils.copyOf(b.sizers);
        this.swappers = CollectionUtils.copyOf(b.swappers);
        this.propertyExtractors = CollectionUtils.copyOf(b.propertyExtractors);
        this.settings = CollectionUtils.copyOf(b.settings);
        Collections.reverse(this.stringifiers);
        Collections.reverse(this.listifiers);
        Collections.reverse(this.swappers);
        Collections.reverse(this.propertyExtractors);
    }

    @Override
    public boolean canListify(Object o) {
        if ((o = this.swap(o)) == null) {
            return false;
        }
        Class<?> c = o.getClass();
        return o instanceof List || c.isArray() || this.listifierMap.computeIfAbsent(c, this::findListifier).isPresent();
    }

    @Override
    public String getNested(Object o, NestedTokenizer.Token token) {
        String selfValue;
        AssertionUtils.assertArgNotNull("token", token);
        if (o == null) {
            return this.getSetting(SETTING_nullValue, null);
        }
        if (Utils.eq("#", token.getValue()) && this.canListify(o)) {
            return this.listify(o).stream().map(x -> token.getNested().stream().map(x2 -> this.getNested(x, (NestedTokenizer.Token)x2)).collect(Collectors.joining(",", "{", "}"))).collect(Collectors.joining(",", "[", "]"));
        }
        String pn = token.getValue();
        Object e = pn.equals(selfValue = this.getSetting(SETTING_selfValue, "<self>")) ? o : Utils.opt(this.getProperty(o, pn)).orElse(null);
        if (e == null || !token.hasNested()) {
            return this.stringify(e);
        }
        return token.getNested().stream().map(x -> this.getNested(e, (NestedTokenizer.Token)x)).map(this::stringify).collect(Collectors.joining(",", "{", "}"));
    }

    @Override
    public Object getProperty(Object object, String name) {
        Object o = this.swap(object);
        return this.propertyExtractors.stream().filter(x -> x.canExtract(this, o, name)).findFirst().orElseThrow(() -> ThrowableUtils.rex("Could not find extractor for object of type {0}", Utils.cn(o))).extract(this, o, name);
    }

    @Override
    public <T> T getSetting(String key, T def) {
        return (T)this.settings.getOrDefault(key, def);
    }

    @Override
    public List<Object> listify(Object o) {
        AssertionUtils.assertArgNotNull("o", o);
        o = this.swap(o);
        if (o instanceof List) {
            return (List)o;
        }
        if (o.getClass().isArray()) {
            return CollectionUtils.arrayToList(o);
        }
        Class<?> c = o.getClass();
        Object o2 = o;
        return this.listifierMap.computeIfAbsent(c, this::findListifier).map(x -> x).map(x -> (List)x.apply(this, o2)).orElseThrow(() -> ThrowableUtils.illegalArg("Object of type {0} could not be converted to a list.", Utils.cns(o2)));
    }

    @Override
    public int size(Object o) {
        AssertionUtils.assertArgNotNull("o", o);
        if (o instanceof Optional) {
            Optional o2 = (Optional)o;
            return o2.isEmpty() ? 0 : 1;
        }
        if ((o = this.swap(o)) == null) {
            return 0;
        }
        if (o instanceof Collection) {
            Collection o2 = (Collection)o;
            return o2.size();
        }
        if (o instanceof Map) {
            Map o3 = (Map)o;
            return o3.size();
        }
        if (o.getClass().isArray()) {
            return Array.getLength(o);
        }
        if (o instanceof String) {
            String o2 = (String)o;
            return o2.length();
        }
        Class<?> c = o.getClass();
        Object o2 = o;
        Optional sizer = this.sizerMap.computeIfAbsent(c, this::findSizer);
        if (sizer.isPresent()) {
            return ((Sizer)sizer.get()).size(o2, this);
        }
        Optional<Integer> sizeResult = ReflectionUtils.info(c).getPublicMethods().stream().filter(m -> !m.hasParameters()).filter(m -> m.hasAnyName("size", "length")).filter(m -> m.getReturnType().isAny((Class<?>)Integer.TYPE, (Class<?>)Integer.class)).findFirst().map(m -> Utils.safe(() -> (int)((Integer)m.invoke(o2, new Object[0])))).filter(Objects::nonNull);
        if (sizeResult.isPresent()) {
            return sizeResult.get();
        }
        if (this.canListify(o)) {
            return this.listify(o).size();
        }
        Optional<Boolean> isEmpty = ReflectionUtils.info(o).getPublicMethods().stream().filter(m -> !m.hasParameters()).filter(m -> m.hasName("isEmpty")).filter(m -> m.getReturnType().isAny((Class<?>)Boolean.TYPE, (Class<?>)Boolean.class)).map(m -> Utils.safe(() -> (Boolean)m.invoke(o2, new Object[0]))).findFirst();
        if (isEmpty.isPresent()) {
            return isEmpty.get() != false ? 0 : 1;
        }
        throw ThrowableUtils.illegalArg("Object of type {0} does not have a determinable size.", Utils.cns(o));
    }

    @Override
    public String stringify(Object o) {
        if ((o = this.swap(o)) == null) {
            return this.getSetting(SETTING_nullValue, null);
        }
        Class<?> c = o.getClass();
        Optional<Stringifier> stringifier = this.stringifierMap.computeIfAbsent(c, this::findStringifier);
        if (stringifier.isEmpty()) {
            stringifier = Optional.of(this.canListify(o) ? (bc, o2) -> bc.stringify(bc.listify(o2)) : (bc, o2) -> this.safeToString(o2));
            this.stringifierMap.putIfAbsent(c, stringifier);
        }
        Object o22 = o;
        return stringifier.map(x -> x).map(x -> x.apply(this, o22)).map(this::safeToString).orElse(null);
    }

    @Override
    public Object swap(Object o) {
        if (o == null) {
            return null;
        }
        Class<?> c = o.getClass();
        Optional swapper = this.swapperMap.computeIfAbsent(c, this::findSwapper);
        if (swapper.isPresent()) {
            return this.swap(swapper.map(x -> x).map(x -> x.apply(this, o)).orElse(null));
        }
        return o;
    }

    private Optional<Listifier<?>> findListifier(Class<?> c) {
        if (c == null) {
            return Optional.empty();
        }
        ListifierEntry l = this.listifiers.stream().filter(x -> x.forClass.isAssignableFrom(c)).findFirst().orElse(null);
        if (Utils.nn(l)) {
            return Optional.of(l.function);
        }
        return this.findListifier(c.getSuperclass());
    }

    private Optional<Sizer<?>> findSizer(Class<?> c) {
        if (c == null) {
            return Optional.empty();
        }
        SizerEntry s = this.sizers.stream().filter(x -> x.forClass.isAssignableFrom(c)).findFirst().orElse(null);
        if (Utils.nn(s)) {
            return Optional.of(s.function);
        }
        return this.findSizer(c.getSuperclass());
    }

    private Optional<Stringifier<?>> findStringifier(Class<?> c) {
        if (c == null) {
            return Optional.empty();
        }
        StringifierEntry s = this.stringifiers.stream().filter(x -> x.forClass.isAssignableFrom(c)).findFirst().orElse(null);
        if (Utils.nn(s)) {
            return Optional.of(s.function);
        }
        return this.findStringifier(c.getSuperclass());
    }

    private Optional<Swapper<?>> findSwapper(Class<?> c) {
        if (c == null) {
            return Optional.empty();
        }
        SwapperEntry s = this.swappers.stream().filter(x -> x.forClass.isAssignableFrom(c)).findFirst().orElse(null);
        if (Utils.nn(s)) {
            return Optional.of(s.function);
        }
        return this.findSwapper(c.getSuperclass());
    }

    private String safeToString(Object o) {
        try {
            return o.toString();
        }
        catch (Throwable t) {
            return Utils.cns(t) + ": " + t.getMessage();
        }
    }

    public static class Builder {
        private Map<String, Object> settings = CollectionUtils.map();
        private List<StringifierEntry<?>> stringifiers = CollectionUtils.list(new StringifierEntry[0]);
        private List<ListifierEntry<?>> listifiers = CollectionUtils.list(new ListifierEntry[0]);
        private List<SizerEntry<?>> sizers = CollectionUtils.list(new SizerEntry[0]);
        private List<SwapperEntry<?>> swappers = CollectionUtils.list(new SwapperEntry[0]);
        private List<PropertyExtractor> propertyExtractors = CollectionUtils.list(new PropertyExtractor[0]);

        public <T> Builder addListifier(Class<T> c, Listifier<T> l) {
            this.listifiers.add(new ListifierEntry<T>(c, l));
            return this;
        }

        public Builder addPropertyExtractor(PropertyExtractor e) {
            this.propertyExtractors.add(e);
            return this;
        }

        public Builder addSetting(String key, Object value) {
            this.settings.put(key, value);
            return this;
        }

        public <T> Builder addSizer(Class<T> c, Sizer<T> s) {
            this.sizers.add(new SizerEntry<T>(c, s));
            return this;
        }

        public <T> Builder addStringifier(Class<T> c, Stringifier<T> s) {
            this.stringifiers.add(new StringifierEntry<T>(c, s));
            return this;
        }

        public <T> Builder addSwapper(Class<T> c, Swapper<T> s) {
            this.swappers.add(new SwapperEntry<T>(c, s));
            return this;
        }

        public BasicBeanConverter build() {
            return new BasicBeanConverter(this);
        }

        public Builder defaultSettings() {
            this.addSetting(BasicBeanConverter.SETTING_nullValue, "<null>");
            this.addSetting(BasicBeanConverter.SETTING_selfValue, "<self>");
            this.addSetting(BasicBeanConverter.SETTING_classNameFormat, "simple");
            this.addStringifier(Map.Entry.class, Stringifiers.mapEntryStringifier());
            this.addStringifier(GregorianCalendar.class, Stringifiers.calendarStringifier());
            this.addStringifier(Date.class, Stringifiers.dateStringifier());
            this.addStringifier(InputStream.class, Stringifiers.inputStreamStringifier());
            this.addStringifier(byte[].class, Stringifiers.byteArrayStringifier());
            this.addStringifier(char[].class, Stringifiers.charArrayStringifier());
            this.addStringifier(Reader.class, Stringifiers.readerStringifier());
            this.addStringifier(File.class, Stringifiers.fileStringifier());
            this.addStringifier(Enum.class, Stringifiers.enumStringifier());
            this.addStringifier(Class.class, Stringifiers.classStringifier());
            this.addStringifier(Constructor.class, Stringifiers.constructorStringifier());
            this.addStringifier(Method.class, Stringifiers.methodStringifier());
            this.addStringifier(List.class, Stringifiers.listStringifier());
            this.addStringifier(Map.class, Stringifiers.mapStringifier());
            this.addListifier(Iterable.class, Listifiers.iterableListifier());
            this.addListifier(Collection.class, Listifiers.collectionListifier());
            this.addListifier(Iterator.class, Listifiers.iteratorListifier());
            this.addListifier(Enumeration.class, Listifiers.enumerationListifier());
            this.addListifier(Stream.class, Listifiers.streamListifier());
            this.addListifier(Map.class, Listifiers.mapListifier());
            this.addSwapper(Optional.class, Swappers.optionalSwapper());
            this.addSwapper(Supplier.class, Swappers.supplierSwapper());
            this.addSwapper(Future.class, Swappers.futureSwapper());
            this.addPropertyExtractor(new PropertyExtractors.ObjectPropertyExtractor());
            this.addPropertyExtractor(new PropertyExtractors.ListPropertyExtractor());
            this.addPropertyExtractor(new PropertyExtractors.MapPropertyExtractor());
            return this;
        }
    }

    static class ListifierEntry<T> {
        private Class<T> forClass;
        private Listifier<T> function;

        private ListifierEntry(Class<T> forClass, Listifier<T> function) {
            this.forClass = forClass;
            this.function = function;
        }
    }

    static class SizerEntry<T> {
        private Class<T> forClass;
        private Sizer<T> function;

        private SizerEntry(Class<T> forClass, Sizer<T> function) {
            this.forClass = forClass;
            this.function = function;
        }
    }

    static class StringifierEntry<T> {
        private Class<T> forClass;
        private Stringifier<T> function;

        private StringifierEntry(Class<T> forClass, Stringifier function) {
            this.forClass = forClass;
            this.function = function;
        }
    }

    static class SwapperEntry<T> {
        private Class<T> forClass;
        private Swapper<T> function;

        private SwapperEntry(Class<T> forClass, Swapper<T> function) {
            this.forClass = forClass;
            this.function = function;
        }
    }
}

