/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.bean.swagger;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.MediaType;
import org.apache.juneau.bean.swagger.ExternalDocumentation;
import org.apache.juneau.bean.swagger.ParameterInfo;
import org.apache.juneau.bean.swagger.ResponseInfo;
import org.apache.juneau.bean.swagger.SwaggerElement;
import org.apache.juneau.commons.collections.MultiSet;
import org.apache.juneau.commons.utils.AssertionUtils;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.Utils;
import org.apache.juneau.internal.ConverterUtils;

public class Operation
extends SwaggerElement {
    private String summary;
    private String description;
    private String operationId;
    private Boolean deprecated;
    private ExternalDocumentation externalDocs;
    private Set<String> tags = new LinkedHashSet<String>();
    private Set<String> schemes = new LinkedHashSet<String>();
    private Set<MediaType> consumes = new LinkedHashSet<MediaType>();
    private Set<MediaType> produces = new LinkedHashSet<MediaType>();
    private List<ParameterInfo> parameters = CollectionUtils.list((Object[])new ParameterInfo[0]);
    private List<Map<String, List<String>>> security = CollectionUtils.list((Object[])new Map[0]);
    private Map<String, ResponseInfo> responses = CollectionUtils.map();

    public Operation() {
    }

    public Operation(Operation copyFrom) {
        super(copyFrom);
        if (Utils.nn(copyFrom.consumes)) {
            this.consumes.addAll(CollectionUtils.copyOf(copyFrom.consumes));
        }
        this.deprecated = copyFrom.deprecated;
        this.description = copyFrom.description;
        this.externalDocs = copyFrom.externalDocs == null ? null : copyFrom.externalDocs.copy();
        this.operationId = copyFrom.operationId;
        if (Utils.nn(copyFrom.produces)) {
            this.produces.addAll(CollectionUtils.copyOf(copyFrom.produces));
        }
        if (Utils.nn(copyFrom.schemes)) {
            this.schemes.addAll(CollectionUtils.copyOf(copyFrom.schemes));
        }
        this.summary = copyFrom.summary;
        if (Utils.nn(copyFrom.tags)) {
            this.tags.addAll(CollectionUtils.copyOf(copyFrom.tags));
        }
        if (Utils.nn(copyFrom.parameters)) {
            this.parameters.addAll(CollectionUtils.copyOf(copyFrom.parameters, ParameterInfo::copy));
        }
        if (Utils.nn(copyFrom.responses)) {
            copyFrom.responses.forEach((k, v) -> this.responses.put((String)k, v.copy()));
        }
        if (Utils.nn(copyFrom.security)) {
            copyFrom.security.forEach(x -> {
                LinkedHashMap m2 = CollectionUtils.map();
                x.forEach((k, v) -> m2.put(k, CollectionUtils.copyOf((List)v)));
                this.security.add(m2);
            });
        }
    }

    public Operation addConsumes(Collection<MediaType> values) {
        if (Utils.nn(values)) {
            this.consumes.addAll(values);
        }
        return this;
    }

    public Operation addConsumes(MediaType ... value) {
        if (Utils.nn((Object)value)) {
            for (MediaType v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.consumes.add(v);
            }
        }
        return this;
    }

    public Operation addParameters(Collection<ParameterInfo> values) {
        if (Utils.nn(values)) {
            this.parameters.addAll(values);
        }
        return this;
    }

    public Operation addParameters(ParameterInfo ... value) {
        if (Utils.nn((Object)value)) {
            for (ParameterInfo v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.parameters.add(v);
            }
        }
        return this;
    }

    public Operation addProduces(Collection<MediaType> values) {
        if (Utils.nn(values)) {
            this.produces.addAll(values);
        }
        return this;
    }

    public Operation addProduces(MediaType ... value) {
        if (Utils.nn((Object)value)) {
            for (MediaType v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.produces.add(v);
            }
        }
        return this;
    }

    public Operation addResponse(String statusCode, ResponseInfo response) {
        AssertionUtils.assertArgNotNull((String)"statusCode", (Object)statusCode);
        AssertionUtils.assertArgNotNull((String)"response", (Object)response);
        this.responses.put(statusCode, response);
        return this;
    }

    public Operation addSchemes(Collection<String> values) {
        if (Utils.nn(values)) {
            this.schemes.addAll(values);
        }
        return this;
    }

    public Operation addSchemes(String ... value) {
        if (Utils.nn((Object)value)) {
            for (String v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.schemes.add(v);
            }
        }
        return this;
    }

    public Operation addSecurity(Collection<Map<String, List<String>>> value) {
        AssertionUtils.assertArgNotNull((String)"value", value);
        this.security.addAll(value);
        return this;
    }

    public Operation addSecurity(String scheme, String ... alternatives) {
        AssertionUtils.assertArgNotNull((String)"scheme", (Object)scheme);
        LinkedHashMap m = CollectionUtils.map();
        m.put(scheme, CollectionUtils.l((Object[])alternatives));
        this.security.add(m);
        return this;
    }

    public Operation addTags(Collection<String> values) {
        if (Utils.nn(values)) {
            this.tags.addAll(values);
        }
        return this;
    }

    public Operation addTags(String ... value) {
        if (Utils.nn((Object)value)) {
            for (String v : value) {
                if (!Utils.nn((Object)v)) continue;
                this.tags.add(v);
            }
        }
        return this;
    }

    public Operation copy() {
        return new Operation(this);
    }

    @Override
    public <T> T get(String property, Class<T> type) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return (T)(switch (property) {
            case "consumes" -> ConverterUtils.toType(this.getConsumes(), type);
            case "deprecated" -> ConverterUtils.toType((Object)this.getDeprecated(), type);
            case "description" -> ConverterUtils.toType((Object)this.getDescription(), type);
            case "externalDocs" -> ConverterUtils.toType((Object)this.getExternalDocs(), type);
            case "operationId" -> ConverterUtils.toType((Object)this.getOperationId(), type);
            case "parameters" -> ConverterUtils.toType(this.getParameters(), type);
            case "produces" -> ConverterUtils.toType(this.getProduces(), type);
            case "responses" -> ConverterUtils.toType(this.getResponses(), type);
            case "schemes" -> ConverterUtils.toType(this.getSchemes(), type);
            case "security" -> ConverterUtils.toType(this.getSecurity(), type);
            case "summary" -> ConverterUtils.toType((Object)this.getSummary(), type);
            case "tags" -> ConverterUtils.toType(this.getTags(), type);
            default -> super.get(property, type);
        });
    }

    public Set<MediaType> getConsumes() {
        return Utils.nullIfEmpty(this.consumes);
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public String getDescription() {
        return this.description;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public ParameterInfo getParameter(String in, String name) {
        AssertionUtils.assertArgNotNull((String)"in", (Object)in);
        for (ParameterInfo pi : this.parameters) {
            if (!Utils.eq((Object)pi.getIn(), (Object)in) || !Utils.eq((Object)pi.getName(), (Object)name) && !"body".equals(pi.getIn())) continue;
            return pi;
        }
        return null;
    }

    public List<ParameterInfo> getParameters() {
        return Utils.nullIfEmpty(this.parameters);
    }

    public Set<MediaType> getProduces() {
        return Utils.nullIfEmpty(this.produces);
    }

    public ResponseInfo getResponse(int status) {
        return this.getResponse(String.valueOf(status));
    }

    public ResponseInfo getResponse(String status) {
        AssertionUtils.assertArgNotNull((String)"status", (Object)status);
        return this.responses.get(status);
    }

    public Map<String, ResponseInfo> getResponses() {
        return Utils.nullIfEmpty(this.responses);
    }

    public Set<String> getSchemes() {
        return Utils.nullIfEmpty(this.schemes);
    }

    public List<Map<String, List<String>>> getSecurity() {
        return Utils.nullIfEmpty(this.security);
    }

    public String getSummary() {
        return this.summary;
    }

    public Set<String> getTags() {
        return Utils.nullIfEmpty(this.tags);
    }

    public boolean isDeprecated() {
        return Utils.nn((Object)this.deprecated) && this.deprecated != false;
    }

    @Override
    public Set<String> keySet() {
        Set s = CollectionUtils.setb(String.class).addIf(Utils.ne(this.consumes), (Object)"consumes").addIf(Utils.nn((Object)this.deprecated), (Object)"deprecated").addIf(Utils.nn((Object)this.description), (Object)"description").addIf(Utils.nn((Object)this.externalDocs), (Object)"externalDocs").addIf(Utils.nn((Object)this.operationId), (Object)"operationId").addIf(Utils.ne(this.parameters), (Object)"parameters").addIf(Utils.ne(this.produces), (Object)"produces").addIf(Utils.ne(this.responses), (Object)"responses").addIf(Utils.ne(this.schemes), (Object)"schemes").addIf(Utils.ne(this.security), (Object)"security").addIf(Utils.nn((Object)this.summary), (Object)"summary").addIf(Utils.ne(this.tags), (Object)"tags").build();
        return new MultiSet(new Collection[]{s, super.keySet()});
    }

    @Override
    public Operation set(String property, Object value) {
        AssertionUtils.assertArgNotNull((String)"property", (Object)property);
        return switch (property) {
            case "consumes" -> this.setConsumes(ConverterUtils.toListBuilder((Object)value, MediaType.class).sparse().build());
            case "deprecated" -> this.setDeprecated(ConverterUtils.toBoolean((Object)value));
            case "description" -> this.setDescription(Utils.s((Object)value));
            case "externalDocs" -> this.setExternalDocs((ExternalDocumentation)ConverterUtils.toType((Object)value, ExternalDocumentation.class));
            case "operationId" -> this.setOperationId(Utils.s((Object)value));
            case "parameters" -> this.setParameters(ConverterUtils.toListBuilder((Object)value, ParameterInfo.class).sparse().build());
            case "produces" -> this.setProduces(ConverterUtils.toListBuilder((Object)value, MediaType.class).sparse().build());
            case "responses" -> this.setResponses(ConverterUtils.toMapBuilder((Object)value, String.class, ResponseInfo.class).sparse().build());
            case "schemes" -> this.setSchemes(ConverterUtils.toListBuilder((Object)value, String.class).sparse().addAny(new Object[]{value}).build());
            case "security" -> this.setSecurity(ConverterUtils.toListBuilder((Object)value, MapStringList.class).sparse().build());
            case "summary" -> this.setSummary(Utils.s((Object)value));
            case "tags" -> this.setTags(ConverterUtils.toListBuilder((Object)value, String.class).sparse().build());
            default -> {
                super.set(property, value);
                yield this;
            }
        };
    }

    public Operation setConsumes(Collection<MediaType> value) {
        this.consumes.clear();
        if (Utils.nn(value)) {
            this.consumes.addAll(value);
        }
        return this;
    }

    public Operation setConsumes(MediaType ... value) {
        return this.setConsumes(CollectionUtils.l((Object[])value));
    }

    public Operation setDeprecated(Boolean value) {
        this.deprecated = value;
        return this;
    }

    public Operation setDescription(String value) {
        this.description = value;
        return this;
    }

    public Operation setExternalDocs(ExternalDocumentation value) {
        this.externalDocs = value;
        return this;
    }

    public Operation setOperationId(String value) {
        this.operationId = value;
        return this;
    }

    public Operation setParameters(Collection<ParameterInfo> value) {
        this.parameters = CollectionUtils.toList(value);
        return this;
    }

    public Operation setParameters(ParameterInfo ... value) {
        return this.setParameters(CollectionUtils.l((Object[])value));
    }

    public Operation setProduces(Collection<MediaType> value) {
        this.produces.clear();
        if (Utils.nn(value)) {
            this.produces.addAll(value);
        }
        return this;
    }

    public Operation setProduces(MediaType ... value) {
        return this.setProduces(CollectionUtils.l((Object[])value));
    }

    public Operation setResponses(Map<String, ResponseInfo> value) {
        this.responses.clear();
        if (Utils.nn(value)) {
            this.responses.putAll(value);
        }
        return this;
    }

    public Operation setSchemes(Collection<String> value) {
        this.schemes.clear();
        if (Utils.nn(value)) {
            this.schemes.addAll(value);
        }
        return this;
    }

    public Operation setSchemes(String ... value) {
        this.setSchemes(CollectionUtils.setb(String.class).sparse().add((Object[])value).build());
        return this;
    }

    public Operation setSecurity(Collection<Map<String, List<String>>> value) {
        this.security = CollectionUtils.toList(value);
        return this;
    }

    @SafeVarargs
    public final Operation setSecurity(Map<String, List<String>> ... value) {
        this.security = CollectionUtils.l((Object[])value);
        return this;
    }

    public Operation setSummary(String value) {
        this.summary = value;
        return this;
    }

    public Operation setTags(Collection<String> value) {
        this.tags.clear();
        if (Utils.nn(value)) {
            this.tags.addAll(value);
        }
        return this;
    }

    public Operation setTags(String ... value) {
        this.setTags(CollectionUtils.setb(String.class).sparse().add((Object[])value).build());
        return this;
    }

    @Override
    public Operation strict() {
        super.strict();
        return this;
    }

    @Override
    public Operation strict(Object value) {
        super.strict(value);
        return this;
    }

    private static interface MapStringList
    extends Map<String, List<String>> {
    }
}

