/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.guard;

import java.text.ParseException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.regex.Pattern;
import org.apache.juneau.commons.lang.AsciiSet;
import org.apache.juneau.commons.lang.StateEnum;
import org.apache.juneau.commons.utils.CollectionUtils;
import org.apache.juneau.commons.utils.StringUtils;
import org.apache.juneau.commons.utils.Utils;

public class RoleMatcher {
    private static final AsciiSet WS = AsciiSet.of((String)" \t");
    private static final AsciiSet OP = AsciiSet.of((String)",|&");
    private static final AsciiSet META = AsciiSet.of((String)"*?");
    private final Exp exp;

    private static Exp parseOperand(String operand) {
        char c;
        boolean hasMeta = false;
        for (int i = 0; i < operand.length() && !hasMeta; hasMeta |= META.contains(c), ++i) {
            c = operand.charAt(i);
        }
        return hasMeta ? new Match(operand) : new Eq(operand);
    }

    public RoleMatcher(String expression) throws ParseException {
        this.exp = this.parse(expression);
    }

    public Set<String> getRolesInExpression() {
        TreeSet<String> set = new TreeSet<String>();
        this.exp.appendTokens(set);
        return set;
    }

    public boolean matches(Set<String> roles) {
        return Utils.nn(roles) && this.exp.matches(roles);
    }

    public String toString() {
        return this.exp.toString();
    }

    private Exp parse(String expression) throws ParseException {
        if (StringUtils.isBlank((CharSequence)expression)) {
            return new Never();
        }
        expression = expression.trim();
        List ors = CollectionUtils.list((Object[])new Exp[0]);
        List ands = CollectionUtils.list((Object[])new Exp[0]);
        StateEnum state = StateEnum.S1;
        int i = 0;
        int mark = -1;
        int pDepth = 0;
        boolean error = false;
        for (i = 0; i < expression.length(); ++i) {
            char c = expression.charAt(i);
            if (state == StateEnum.S1) {
                if (WS.contains(c)) continue;
                if (c == '(') {
                    state = StateEnum.S2;
                    pDepth = 0;
                    mark = i + 1;
                    continue;
                }
                if (OP.contains(c)) {
                    error = true;
                    break;
                }
                state = StateEnum.S3;
                mark = i;
                continue;
            }
            if (state == StateEnum.S2) {
                if (c == '(') {
                    ++pDepth;
                }
                if (c != ')') continue;
                if (pDepth > 0) {
                    --pDepth;
                    continue;
                }
                ands.add(this.parse(expression.substring(mark, i)));
                mark = -1;
                state = StateEnum.S4;
                continue;
            }
            if (state == StateEnum.S3) {
                if (!WS.contains(c) && !OP.contains(c)) continue;
                ands.add(RoleMatcher.parseOperand(expression.substring(mark, i)));
                mark = -1;
                if (WS.contains(c)) {
                    state = StateEnum.S4;
                    continue;
                }
                --i;
                state = StateEnum.S5;
                continue;
            }
            if (state == StateEnum.S4) {
                if (WS.contains(c)) continue;
                if (OP.contains(c)) {
                    --i;
                    state = StateEnum.S5;
                    continue;
                }
                error = true;
                break;
            }
            if (state == StateEnum.S5) {
                if (c == '&') {
                    state = StateEnum.S6;
                    continue;
                }
                if (ands.size() == 1) {
                    ors.add((Exp)ands.get(0));
                } else {
                    ors.add(new And(ands));
                }
                ands.clear();
                if (c == '|') {
                    state = StateEnum.S7;
                    continue;
                }
                state = StateEnum.S1;
                continue;
            }
            if (state == StateEnum.S6) {
                if (WS.contains(c)) continue;
                if (c != '&') {
                    --i;
                }
                state = StateEnum.S1;
                continue;
            }
            if (WS.contains(c)) continue;
            if (c != '|') {
                --i;
            }
            state = StateEnum.S1;
        }
        if (error) {
            throw new ParseException("Invalid character in expression '" + expression + "' at position " + i + ". state=" + String.valueOf(state), i);
        }
        if (state == StateEnum.S1) {
            throw new ParseException("Could not find beginning of clause in '" + expression + "'", i);
        }
        if (state == StateEnum.S2) {
            throw new ParseException("Could not find matching parenthesis in expression '" + expression + "'", i);
        }
        if (state == StateEnum.S5 || state == StateEnum.S6 || state == StateEnum.S7) {
            throw new ParseException("Dangling clause in expression '" + expression + "'", i);
        }
        if (mark != -1) {
            ands.add(RoleMatcher.parseOperand(expression.substring(mark, expression.length())));
        }
        if (ands.size() == 1) {
            ors.add((Exp)ands.get(0));
        } else {
            ors.add(new And(ands));
        }
        if (ors.size() == 1) {
            return (Exp)ors.get(0);
        }
        return new Or(ors);
    }

    static class Match
    extends Exp {
        final Pattern p;
        final String operand;

        Match(String operand) {
            this.operand = operand;
            this.p = StringUtils.getMatchPattern((String)operand);
        }

        public String toString() {
            return "[* " + this.p.pattern().replaceAll("\\\\[QE]", "") + "]";
        }

        @Override
        void appendTokens(Set<String> set) {
            set.add(this.operand);
        }

        @Override
        boolean matches(Set<String> roles) {
            for (String role : roles) {
                if (!this.p.matcher(role).matches()) continue;
                return true;
            }
            return false;
        }
    }

    static class Eq
    extends Exp {
        final String operand;

        Eq(String operand) {
            this.operand = operand;
        }

        public String toString() {
            return "[= " + this.operand + "]";
        }

        @Override
        void appendTokens(Set<String> set) {
            set.add(this.operand);
        }

        @Override
        boolean matches(Set<String> roles) {
            for (String role : roles) {
                if (!this.operand.equals(role)) continue;
                return true;
            }
            return false;
        }
    }

    static abstract class Exp {
        Exp() {
        }

        void appendTokens(Set<String> set) {
        }

        abstract boolean matches(Set<String> var1);
    }

    static class Never
    extends Exp {
        Never() {
        }

        public String toString() {
            return "(NEVER)";
        }

        @Override
        boolean matches(Set<String> roles) {
            return false;
        }
    }

    static class And
    extends Exp {
        Exp[] clauses;

        And(List<Exp> clauses) {
            this.clauses = clauses.toArray(new Exp[clauses.size()]);
        }

        public String toString() {
            return "(& " + StringUtils.join((Object[])this.clauses, (String)" ") + ")";
        }

        @Override
        void appendTokens(Set<String> set) {
            for (Exp clause : this.clauses) {
                clause.appendTokens(set);
            }
        }

        @Override
        boolean matches(Set<String> roles) {
            for (Exp e : this.clauses) {
                if (e.matches(roles)) continue;
                return false;
            }
            return true;
        }
    }

    static class Or
    extends Exp {
        Exp[] clauses;

        Or(List<Exp> clauses) {
            this.clauses = clauses.toArray(new Exp[clauses.size()]);
        }

        public String toString() {
            return "(| " + StringUtils.join((Object[])this.clauses, (String)" ") + ")";
        }

        @Override
        void appendTokens(Set<String> set) {
            for (Exp clause : this.clauses) {
                clause.appendTokens(set);
            }
        }

        @Override
        boolean matches(Set<String> roles) {
            for (Exp e : this.clauses) {
                if (!e.matches(roles)) continue;
                return true;
            }
            return false;
        }
    }
}

