/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.svcregfunc.impl;

import java.util.ArrayList;
import java.util.List;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteContext;
import org.apache.knox.gateway.filter.rewrite.spi.UrlRewriteFunctionProcessor;
import org.apache.knox.gateway.svcregfunc.api.ServiceSchemeFunctionDescriptor;
import org.apache.knox.gateway.svcregfunc.impl.ServiceRegistryFunctionProcessorBase;
import org.apache.knox.gateway.util.urltemplate.Parser;
import org.apache.knox.gateway.util.urltemplate.Scheme;
import org.apache.knox.gateway.util.urltemplate.Template;

public class ServiceSchemeFunctionProcessor
extends ServiceRegistryFunctionProcessorBase<ServiceSchemeFunctionDescriptor>
implements UrlRewriteFunctionProcessor<ServiceSchemeFunctionDescriptor> {
    public String name() {
        return "serviceScheme";
    }

    public List<String> resolve(UrlRewriteContext context, List<String> parameters) throws Exception {
        ArrayList<String> results = null;
        if (parameters != null) {
            results = new ArrayList<String>(parameters.size());
            for (String parameter : parameters) {
                Template template;
                Scheme scheme;
                String url = this.lookupServiceUrl(parameter);
                if (url != null && !url.equals(parameter) && (scheme = (template = Parser.parseLiteral((String)url)).getScheme()) != null) {
                    parameter = scheme.getFirstValue().getPattern();
                }
                results.add(parameter);
            }
        }
        return results;
    }
}

