/*
 * Decompiled with CFR 0.152.
 */
package org.apache.knox.gateway.service.auth;

import java.util.Locale;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;

@Path(value="auth/api/v1/bearer")
public class AuthBearerResource {
    static final String RESOURCE_PATH = "auth/api/v1/bearer";
    static final String BEARER_AUTH_TOKEN_ENV_CONFIG = "auth.bearer.token.env";
    static final String DEFAULT_BEARER_AUTH_TOKEN_ENV = "BEARER_AUTH_TOKEN";
    static final String HEADER_FORMAT = "Bearer %s";
    private String token;
    @Context
    HttpServletResponse response;
    @Context
    ServletContext context;

    @PostConstruct
    public void init() throws ServletException {
        String bearerTokenEnvVariableName = this.context.getInitParameter(BEARER_AUTH_TOKEN_ENV_CONFIG);
        if (bearerTokenEnvVariableName == null) {
            bearerTokenEnvVariableName = DEFAULT_BEARER_AUTH_TOKEN_ENV;
        }
        this.token = System.getenv(bearerTokenEnvVariableName);
        if (this.token == null) {
            throw new ServletException(String.format(Locale.ROOT, "Token environment variable '%s' is not set", bearerTokenEnvVariableName));
        }
    }

    @GET
    public Response doGet() {
        this.response.addHeader("Authorization", String.format(Locale.ROOT, HEADER_FORMAT, this.token));
        return Response.ok().build();
    }
}

