/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
*/

package org.apache.kylin.stream.source.kafka;

import java.io.IOException;

import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.source.hive.HiveSource;
import org.apache.kylin.stream.core.source.StreamingSourceConfig;
import org.apache.kylin.stream.core.source.StreamingSourceConfigManager;

public class KafkaBatchSourceAdaptor extends HiveSource {
    public KafkaBatchSourceAdaptor(KylinConfig config) {
        super(config);
    }

    @Override
    public void unloadTable(String tableName, String project) throws IOException {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        StreamingSourceConfigManager sourceConfigManager = StreamingSourceConfigManager.getInstance(kylinConfig);
        StreamingSourceConfig config = sourceConfigManager.getConfig(tableName, project);
        if (config == null) {
            return;
        }
        sourceConfigManager.removeStreamingConfig(config);
    }
}
