--
-- Licensed to the Apache Software Foundation (ASF) under one
-- or more contributor license agreements.  See the NOTICE file
-- distributed with this work for additional information
-- regarding copyright ownership.  The ASF licenses this file
-- to you under the Apache License, Version 2.0 (the
-- "License"); you may not use this file except in compliance
-- with the License.  You may obtain a copy of the License at
--
--     http://www.apache.org/licenses/LICENSE-2.0
--
-- Unless required by applicable law or agreed to in writing, software
-- distributed under the License is distributed on an "AS IS" BASIS,
-- WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
-- See the License for the specific language governing permissions and
-- limitations under the License.
--

SELECT "db_3"."F_NAME" AS "F_NAME_3", "db_3"."P_NAME" AS "P_NAME_3", "db_3"."VERSION" AS "VERSION_3", "db_3"."COUNT" AS "COUNT_3", "db_3"."COST" AS "COST_3" FROM (SELECT COUNT(*) AS count_all, SUM(cost) AS cost, test_d_factory.F_NAME AS F_NAME
    , test_d_product.P_NAME AS P_NAME, descrip_c AS version
FROM t_demo_.t_demo_data t_demo_data
    LEFT JOIN t_test.test_d_date test_d_date ON t_demo_data.date_id = test_d_date.date_id
    LEFT JOIN t_test.test_d_media test_d_media ON t_demo_data.media_id = test_d_media.media_id
    LEFT JOIN t_test.test_d_media_cate test_d_media_cate ON test_d_media.media_cate_id = test_d_media_cate.media_cate_id
    LEFT JOIN t_test.test_d_location test_d_location ON test_d_media.location_id = test_d_location.location_id
    LEFT JOIN t_test.test_d_product test_d_product ON test_d_product.product_id = t_demo_data.prod_id
    LEFT JOIN t_test.test_d_brand test_d_brand ON test_d_product.brand_id = test_d_brand.brand_id
    LEFT JOIN t_test.test_d_factory test_d_factory ON test_d_product.factory_id = test_d_factory.factory_id
    LEFT JOIN t_test.test_d_prod_cate test_d_prod_cate ON test_d_product.prod_cate_id = test_d_prod_cate.prod_cate_id
    LEFT JOIN t_test.test_d_program pre_pg ON pre_pg.prog_id = t_demo_data.pre_pg_id
    LEFT JOIN t_test.test_d_program post_pg ON post_pg.prog_id = t_demo_data.post_pg_id
    LEFT JOIN t_test.test_d_prog_cate pre_prog_cate ON pre_prog_cate.prog_cate_id = pre_pg.prog_cate_id
    LEFT JOIN t_test.test_d_prog_cate post_prog_cate ON post_prog_cate.prog_cate_id = post_pg.prog_cate_id
    LEFT JOIN t_test.test_d_brd_cate test_d_brd_cate ON test_d_brd_cate.brd_cate_id = t_demo_data.cate_brd_id
    LEFT JOIN t_test.ov_media_alias ov_media_alias ON ov_media_alias.media_id = test_d_media.media_id
WHERE (test_d_media.media_type = 7
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (7)
                AND test_d_media.monitor_type = 0
                AND test_d_media.media_id IN (20001, 20002, 20003, 20004, 20005, 20006, 20007, 20008, 20009, 20010, 20011, 20012, 20013, 20014, 20015, 20016, 20017, 20018, 20019, 20020, 20021, 20022, 20023, 20024, 20025, 20026, 20027, 20028, 20029, 20030, 20031, 20032, 20033, 20034, 20035, 20036, 20037, 20038, 20039, 20040, 20041, 20042, 20043, 20044, 20045, 20046, 20047, 20048, 20049, 20050, 20051, 20052, 20053, 20054, 20055, 20056, 20057, 20058, 20059, 20060, 20061, 20062, 20063, 20064, 20065, 20066, 20067, 20068, 20069, 20070, 20071, 20072, 20073, 20074, 20075, 20076, 20077, 20078, 20079, 20080, 20081, 20082, 20083, 20084, 20085, 20086, 20087, 20088, 20089, 20090, 20091, 20092, 20093, 20094, 20095, 20096, 20097, 20098, 20099, 20100, 20101, 20102, 20103, 20104, 20105, 20106, 20107, 20108, 20109, 20110, 20111, 20112, 20113, 20114, 20115, 20116, 20117, 20118, 20119, 20120, 20121, 20122, 20123, 20124, 20125, 20126, 20127, 20128, 20129, 20130, 20131, 20132, 20133, 20134, 20135, 20136, 20137, 20138, 20139, 20140, 20141, 20142, 20143, 20144, 20145, 20146, 20147, 20148, 20149, 20150, 20151, 20152, 20153, 20154, 20155, 20156, 20157, 20158, 20159, 20160, 20161, 20162, 20163, 20164, 20165, 20166, 20167, 20168, 20169, 20170, 20171, 20172, 20173, 20174, 20175, 20176, 20177, 20178, 20179, 20180, 20181, 20182, 20183, 20184, 20185, 20186, 20187, 20188, 20189, 20190, 20191, 20192, 20193, 20194, 20195, 20196, 20197, 20198, 20199, 20200, 20201, 20202, 20203, 20204, 20205, 20206, 20207, 20208, 20209, 20210, 20211, 20212, 20213, 20214, 20215, 20216, 20217, 20218, 20219, 20220, 20221, 20222, 20223, 20224, 20225, 20226, 20227, 20228, 20229, 20230, 20231, 20232, 20233, 20234, 20235, 20236, 20237, 20238, 20239, 20240, 20241, 20242, 20243, 20244, 20245, 20246, 20247, 20248, 20249, 20250, 20251, 20252, 20253, 20254, 20255, 20256, 20257, 20258, 20259, 20260, 20261, 20262, 20263, 20264, 20265, 20266, 20267, 20268, 20269, 20270, 20271, 20272, 20273, 20274, 20275, 20276, 20277, 20278, 20279, 20280, 20281, 20282, 20283, 20284, 20285, 20286, 20287, 20301, 20302, 20303, 20304, 20305, 20306, 20307, 20308, 20309, 20310, 20311, 20312, 20313, 20314, 20315, 20316, 20317, 20318, 20319, 20320, 20321, 20322, 20323, 20324, 20325, 20326, 20327, 20328, 20329, 20330, 20331, 20332, 20333, 20334, 20335, 20336, 20337, 20338, 20339, 20340, 20341, 20342, 20343, 20344, 20345, 20346, 20347, 20348, 20349, 20350, 20351, 20352, 20353, 20354, 20355, 20356, 20357, 20358, 20359, 20360, 20361, 20362, 20363, 20364, 20365, 20366, 20367, 20368, 20369, 20370, 20371, 20372, 20373, 20374, 20375, 20376, 20377, 20378, 20379, 20380, 20381, 20382, 20383, 20384, 20385, 20386, 20387, 20388, 20389, 20390, 20391, 20392, 20393, 20394, 20395, 20396, 20397, 20398, 20399, 20400, 20401, 20402, 20403, 20404, 20405, 20406, 20407, 20408, 20409, 20410, 20411, 20412, 20413, 20414, 20415, 20416, 20417, 20418, 20419, 20420, 20421, 20422, 20423, 20424, 20425, 20426, 20427, 20428, 20429, 20430, 20431, 20432, 20433, 20434, 20435, 20436, 20437, 20438, 20439, 20440, 20441, 20442, 20443, 20444, 20445, 20446, 20447, 20448)
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
    OR (test_d_media.media_type IN (5, 10, 11)
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (5, 10, 11)
                AND test_d_media.monitor_type = 1
                AND (test_d_media.media_id IN (9139, 9159, 9342, 9356, 9358, 9360, 9364)
                    OR test_d_media.media_id IN (9145, 9147, 9178, 9396, 9401, 9402, 9403, 9404, 9405, 9406, 9407, 9408, 9409, 9413, 9415, 9416)
                    OR test_d_media.media_id IN (9137, 9141, 9163)
                    OR test_d_media.media_id IN (9346)
                    OR test_d_media.media_id IN (9134, 9143, 9146, 9156, 9160, 9167, 9184, 9186, 9338, 9340, 9365, 9397, 9399, 9414)
                    OR test_d_media.media_id IN (9140, 9180, 9335)
                    OR test_d_media.media_id IN (9337, 9345)
                    OR test_d_media.media_id IN (9135, 9149, 9153, 9157, 9172, 9339, 9344)
                    OR test_d_media.media_id IN (9148, 9182)
                    OR test_d_media.media_id IN (9142, 9155, 9162, 9166, 9174)
                    OR test_d_media.media_id IN (9138, 9150, 9151, 9169, 9171, 9176)
                    OR test_d_media.media_id IN (9333, 9355, 9359, 9410, 9417)
                    OR test_d_media.media_id IN (9334, 9341, 9343, 9357, 9361, 9362, 9398)
                    OR test_d_media.media_id IN (9161, 9164, 9168)
                    OR test_d_media.media_id IN (9177)
                    OR test_d_media.media_id IN (9154, 9165, 9173)
                    OR test_d_media.media_id IN (9336, 9411, 9412)
                    OR test_d_media.media_id IN (9136, 9144, 9152, 9158, 9170, 9175, 9179, 9181, 9183, 9185, 9187, 9188, 9363, 9400)
                    OR test_d_media.media_id IN (9130, 9131, 9132, 9133, 9347))
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230630)))
            OR (test_d_media.media_type IN (5, 10, 11)
                AND test_d_media.monitor_type = 0
                AND (test_d_media.media_id IN (9030, 9367, 9385)
                    OR test_d_media.media_id IN (9006, 9020, 9027, 9028, 9041)
                    OR test_d_media.media_id IN (9039, 9082, 9201, 9318, 9368, 9378, 9387)
                    OR test_d_media.media_id IN (9036, 9037, 9038, 9042)
                    OR test_d_media.media_id IN (9197)
                    OR test_d_media.media_id IN (9035, 9083, 9350, 9351)
                    OR test_d_media.media_id IN (9212)
                    OR test_d_media.media_id IN (9034)
                    OR test_d_media.media_id IN (9246, 9314, 9371)
                    OR test_d_media.media_id IN (9119, 9123, 9189, 9208, 9234, 9248, 9252, 9273, 9297, 9308, 9349, 9352, 9372, 9374, 9384)
                    OR test_d_media.media_id IN (9029, 9116, 9209)
                    OR test_d_media.media_id IN (9031, 9108, 9192, 9381)
                    OR test_d_media.media_id IN (9099, 9100, 9103, 9104, 9107, 9117, 9125, 9129, 9223, 9309, 9317, 9382)
                    OR test_d_media.media_id IN (9002, 9013, 9021, 9059, 9073, 9084, 9091, 9112, 9114, 9126, 9198, 9235, 9328, 9354, 9375, 9391)
                    OR test_d_media.media_id IN (9046, 9047, 9048, 9049, 9050, 9051, 9052, 9053, 9054, 9092, 9111, 9113, 9115, 9120, 9128, 9191, 9202, 9206, 9216, 9261, 9268, 9269, 9270, 9285, 9288, 9373, 9377, 9383)
                    OR test_d_media.media_id IN (9074, 9080, 9081, 9213, 9219, 9267, 9366, 9370, 9376, 9379, 9380, 9386, 9392, 9393, 9395)
                    OR test_d_media.media_id IN (9032, 9033, 9094, 9095, 9105, 9199, 9200, 9205, 9265, 9277, 9304, 9316, 9323, 9348, 9369)
                    OR test_d_media.media_id IN (9022, 9124, 9215, 9227, 9230, 9241, 9243, 9244, 9258, 9275, 9295, 9305, 9310, 9312, 9315)
                    OR test_d_media.media_id IN (9040, 9043, 9044, 9045, 9085, 9101, 9110, 9190, 9204, 9220, 9228, 9229, 9231, 9250, 9251, 9264, 9293, 9303)
                    OR test_d_media.media_id IN (9089, 9109, 9122, 9207, 9271, 9389, 9390)
                    OR test_d_media.media_id IN (9023, 9024, 9025, 9055, 9056, 9057, 9058, 9060, 9061, 9062, 9063, 9064, 9065, 9066, 9067, 9068, 9069, 9071, 9072, 9077, 9078, 9096, 9098, 9102, 9121, 9194, 9203, 9221, 9222, 9232, 9238, 9247, 9254, 9255, 9272, 9287, 9298, 9307, 9319, 9320, 9324, 9388)
                    OR test_d_media.media_id IN (9009, 9090, 9097)
                    OR test_d_media.media_id IN (9070, 9076, 9093, 9118, 9233, 9257, 9291, 9353, 9394)
                    OR test_d_media.media_id IN (9010, 9011, 9012, 9015, 9016, 9210, 9211, 9218, 9224, 9226, 9237, 9240, 9249, 9253, 9256, 9260, 9262, 9263, 9266, 9274, 9276, 9278, 9279, 9280, 9281, 9282, 9283, 9284, 9286, 9289, 9290, 9292, 9294, 9296, 9299, 9300, 9301, 9302, 9306, 9311, 9313, 9321, 9322, 9327, 9329, 9330, 9331, 9332)
                    OR test_d_media.media_id IN (9001, 9003, 9004, 9005, 9007, 9008, 9014, 9017, 9018, 9019, 9075, 9086, 9087, 9106, 9239)
                    OR test_d_media.media_id IN (9026, 9079, 9088, 9127, 9193, 9195, 9196, 9214, 9217, 9225, 9236, 9242, 9245, 9259))
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))
            OR (test_d_media.media_type IN (5, 10, 11)
                AND test_d_media.monitor_type = 1
                AND (test_d_media.media_id IN (9139, 9159, 9342, 9356, 9358, 9360, 9364)
                    OR test_d_media.media_id IN (9145, 9147, 9178, 9396, 9401, 9402, 9403, 9404, 9405, 9406, 9407, 9408, 9409, 9413, 9415, 9416)
                    OR test_d_media.media_id IN (9137, 9141, 9163)
                    OR test_d_media.media_id IN (9346)
                    OR test_d_media.media_id IN (9134, 9143, 9146, 9156, 9160, 9167, 9184, 9186, 9338, 9340, 9365, 9397, 9399, 9414)
                    OR test_d_media.media_id IN (9140, 9180, 9335)
                    OR test_d_media.media_id IN (9337, 9345)
                    OR test_d_media.media_id IN (9135, 9149, 9153, 9157, 9172, 9339, 9344)
                    OR test_d_media.media_id IN (9148, 9182)
                    OR test_d_media.media_id IN (9142, 9155, 9162, 9166, 9174)
                    OR test_d_media.media_id IN (9138, 9150, 9151, 9169, 9171, 9176)
                    OR test_d_media.media_id IN (9333, 9355, 9359, 9410, 9417)
                    OR test_d_media.media_id IN (9334, 9341, 9343, 9357, 9361, 9362, 9398)
                    OR test_d_media.media_id IN (9161, 9164, 9168)
                    OR test_d_media.media_id IN (9177)
                    OR test_d_media.media_id IN (9154, 9165, 9173)
                    OR test_d_media.media_id IN (9336, 9411, 9412)
                    OR test_d_media.media_id IN (9136, 9144, 9152, 9158, 9170, 9175, 9179, 9181, 9183, 9185, 9187, 9188, 9363, 9400)
                    OR test_d_media.media_id IN (9130, 9131, 9132, 9133, 9347))
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
    OR (test_d_media.media_type = 4
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (4)
                AND test_d_media.monitor_type = 0
                AND test_d_location.region_id IN (
                     '1',
                     '2',
                     '3',
                     '4',
                     '5',
                     '6',
                     '7',
                     '8',
                     '9'
                )
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
    OR (test_d_media.media_type = 6
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (6)
                AND test_d_media.monitor_type = 0
                AND (test_d_media.media_id IN (10008, 11043, 11062, 11117, 11782, 11855, 11864, 11865, 11866, 11880, 11916, 11925, 11926, 11927, 11930, 11931)
                    OR test_d_media.media_id IN (10773, 11282, 11493, 12470)
                    OR test_d_media.media_id IN (12329)
                    OR test_d_media.media_id IN (11650)
                    OR test_d_media.media_id IN (11754)
                    OR test_d_media.media_id IN (13047)
                    OR test_d_media.media_id IN (11076)
                    OR test_d_media.media_id IN (11542)
                    OR test_d_media.media_id IN (10984)
                    OR test_d_media.media_id IN (10972)
                    OR test_d_media.media_id IN (12853)
                    OR test_d_media.media_id IN (11612)
                    OR test_d_media.media_id IN (10989)
                    OR test_d_media.media_id IN (11541)
                    OR test_d_media.media_id IN (10995, 11024)
                    OR test_d_media.media_id IN (12698, 12964)
                    OR test_d_media.media_id IN (12232)
                    OR test_d_media.media_id IN (10996)
                    OR test_d_media.media_id IN (10801)
                    OR test_d_media.media_id IN (11531)
                    OR test_d_media.media_id IN (11586)
                    OR test_d_media.media_id IN (13028)
                    OR test_d_media.media_id IN (10485)
                    OR test_d_media.media_id IN (11632)
                    OR test_d_media.media_id IN (12437)
                    OR test_d_media.media_id IN (10927)
                    OR test_d_media.media_id IN (11883)
                    OR test_d_media.media_id IN (12304, 12320)
                    OR test_d_media.media_id IN (11563)
                    OR test_d_media.media_id IN (12185)
                    OR test_d_media.media_id IN (11550)
                    OR test_d_media.media_id IN (12292)
                    OR test_d_media.media_id IN (10793)
                    OR test_d_media.media_id IN (10770, 10784, 10789, 10799, 10803, 10821, 10823, 10828, 10894, 10901, 10924, 10963, 10964, 10965, 10966, 10982, 11000, 11049, 11063, 11101, 11107, 11153, 11190, 11535, 11536, 11551, 11557, 11574, 11580, 11582, 11583, 11589, 11638, 11646, 11657, 11672, 11678, 11763, 11772, 11777, 11779, 11780, 11781, 11786, 11787, 11788, 11793, 11794, 11797, 11798, 11799, 11801, 11802, 11807, 11808, 11809, 11810, 11811, 11812, 11813, 11814, 11816, 11823, 11824, 11825, 11826, 11828, 11830, 11831, 11832, 11833, 11844, 11846, 11848, 11849, 11851, 11863, 11868, 11869, 11870, 11872, 11874, 11875, 11876, 11890, 11893, 11896, 11897, 11903, 11904, 11928, 11934, 11935, 11936, 11937, 11938, 11939, 11940, 11941, 11942, 11947, 11948, 11951, 11956, 11958, 11959, 11968, 11969, 11972, 11973, 11974, 11977, 11984, 11985, 11986, 11987, 11989, 11990, 12002, 12005, 12006, 12007, 12008, 12011, 12016, 12019, 12020, 12022, 12023, 12024, 12030, 12031, 12040, 12044, 12045, 12069, 12087, 12175, 12200, 12219, 12220, 12250, 12255, 12261, 12263, 12282, 12443, 12493)
                    OR test_d_media.media_id IN (11549, 11613)
                    OR test_d_media.media_id IN (11651)
                    OR test_d_media.media_id IN (12490)
                    OR test_d_media.media_id IN (11728, 12010, 12034, 12440)
                    OR test_d_media.media_id IN (11719)
                    OR test_d_media.media_id IN (11775, 11776, 12013, 12015)
                    OR test_d_media.media_id IN (11547)
                    OR test_d_media.media_id IN (11817, 12922)
                    OR test_d_media.media_id IN (11758)
                    OR test_d_media.media_id IN (10500, 10818, 10889, 10890, 10946, 11011, 11382, 11428, 11523, 11526, 11532, 11555, 11573, 11577, 11590, 11624, 11649, 11673, 11683, 11691, 11795, 11803, 11835, 11836, 11837, 11838, 11906, 11907, 11920, 11921, 11922, 11993, 11994, 11998, 12036, 12041, 12702, 12713, 12952, 12956)
                    OR test_d_media.media_id IN (12315)
                    OR test_d_media.media_id IN (12101)
                    OR test_d_media.media_id IN (10002, 10985, 13008, 13009)
                    OR test_d_media.media_id IN (10206, 10267, 10270, 11805)
                    OR test_d_media.media_id IN (12648)
                    OR test_d_media.media_id IN (12487)
                    OR test_d_media.media_id IN (12481, 13104)
                    OR test_d_media.media_id IN (10484, 10783, 12248)
                    OR test_d_media.media_id IN (12436)
                    OR test_d_media.media_id IN (12962)
                    OR test_d_media.media_id IN (12966)
                    OR test_d_media.media_id IN (10447, 11829, 11970)
                    OR test_d_media.media_id IN (10916, 12242)
                    OR test_d_media.media_id IN (11558)
                    OR test_d_media.media_id IN (11046, 12438)
                    OR test_d_media.media_id IN (11578)
                    OR test_d_media.media_id IN (10486, 11556)
                    OR test_d_media.media_id IN (10453)
                    OR test_d_media.media_id IN (11995, 12183)
                    OR test_d_media.media_id IN (11689)
                    OR test_d_media.media_id IN (12451)
                    OR test_d_media.media_id IN (10250, 11059, 11616)
                    OR test_d_media.media_id IN (11688, 12230, 12427)
                    OR test_d_media.media_id IN (12311, 12959)
                    OR test_d_media.media_id IN (11524)
                    OR test_d_media.media_id IN (11621, 13105)
                    OR test_d_media.media_id IN (11567, 11682)
                    OR test_d_media.media_id IN (12262)
                    OR test_d_media.media_id IN (11284)
                    OR test_d_media.media_id IN (10191, 10273, 11042, 12048)
                    OR test_d_media.media_id IN (10032, 10051, 10052, 10202, 11067, 11891, 12119)
                    OR test_d_media.media_id IN (11538)
                    OR test_d_media.media_id IN (12337, 12343)
                    OR test_d_media.media_id IN (10998)
                    OR test_d_media.media_id IN (11486)
                    OR test_d_media.media_id IN (12919)
                    OR test_d_media.media_id IN (12313)
                    OR test_d_media.media_id IN (10997)
                    OR test_d_media.media_id IN (11439)
                    OR test_d_media.media_id IN (12324, 12334, 12338, 13089, 13090, 13091)
                    OR test_d_media.media_id IN (11114)
                    OR test_d_media.media_id IN (10817, 12302)
                    OR test_d_media.media_id IN (12297, 12310)
                    OR test_d_media.media_id IN (11576)
                    OR test_d_media.media_id IN (12339)
                    OR test_d_media.media_id IN (10792, 11587)
                    OR test_d_media.media_id IN (12325)
                    OR test_d_media.media_id IN (11615, 11819, 11820, 11821, 11852, 12152, 12226, 12235, 12268)
                    OR test_d_media.media_id IN (10481, 12157, 12160, 13100, 13101, 13102, 13106, 13107, 13109)
                    OR test_d_media.media_id IN (11529)
                    OR test_d_media.media_id IN (11581)
                    OR test_d_media.media_id IN (10429, 11687, 12458, 13103)
                    OR test_d_media.media_id IN (12810)
                    OR test_d_media.media_id IN (10794, 12429)
                    OR test_d_media.media_id IN (12305)
                    OR test_d_media.media_id IN (10782)
                    OR test_d_media.media_id IN (11658)
                    OR test_d_media.media_id IN (12424)
                    OR test_d_media.media_id IN (12457)
                    OR test_d_media.media_id IN (12737, 12927)
                    OR test_d_media.media_id IN (11591)
                    OR test_d_media.media_id IN (11032, 11142)
                    OR test_d_media.media_id IN (10873, 10994, 11037, 11094, 11095, 11500, 11514, 11597, 11677, 11943, 12038, 12066, 12143, 12251, 12960)
                    OR test_d_media.media_id IN (11652)
                    OR test_d_media.media_id IN (12428, 12456)
                    OR test_d_media.media_id IN (12659, 12837)
                    OR test_d_media.media_id IN (11599)
                    OR test_d_media.media_id IN (11009)
                    OR test_d_media.media_id IN (11421)
                    OR test_d_media.media_id IN (12293, 12347)
                    OR test_d_media.media_id IN (10510)
                    OR test_d_media.media_id IN (12121, 13018)
                    OR test_d_media.media_id IN (10779)
                    OR test_d_media.media_id IN (11411)
                    OR test_d_media.media_id IN (12067)
                    OR test_d_media.media_id IN (11961, 11997)
                    OR test_d_media.media_id IN (10100, 10446, 10765, 11029, 11770, 11895, 11898, 12035, 12039)
                    OR test_d_media.media_id IN (12072)
                    OR test_d_media.media_id IN (11003, 12071, 12299, 12300, 12312, 12317, 12323, 12340, 12344)
                    OR test_d_media.media_id IN (12430)
                    OR test_d_media.media_id IN (11614)
                    OR test_d_media.media_id IN (12970)
                    OR test_d_media.media_id IN (11026)
                    OR test_d_media.media_id IN (11028, 11513)
                    OR test_d_media.media_id IN (10790, 13113)
                    OR test_d_media.media_id IN (11871, 11963, 11991, 11992)
                    OR test_d_media.media_id IN (12856)
                    OR test_d_media.media_id IN (12878, 12926)
                    OR test_d_media.media_id IN (10763, 11002)
                    OR test_d_media.media_id IN (12156)
                    OR test_d_media.media_id IN (11256, 11680, 13096, 13097, 13098, 13099)
                    OR test_d_media.media_id IN (12423)
                    OR test_d_media.media_id IN (10511)
                    OR test_d_media.media_id IN (11804, 12170)
                    OR test_d_media.media_id IN (11908)
                    OR test_d_media.media_id IN (11601)
                    OR test_d_media.media_id IN (12836)
                    OR test_d_media.media_id IN (11012)
                    OR test_d_media.media_id IN (10772, 11053, 11516, 12037)
                    OR test_d_media.media_id IN (12345)
                    OR test_d_media.media_id IN (12999)
                    OR test_d_media.media_id IN (11404)
                    OR test_d_media.media_id IN (12301)
                    OR test_d_media.media_id IN (12835)
                    OR test_d_media.media_id IN (10508, 11877)
                    OR test_d_media.media_id IN (12736)
                    OR test_d_media.media_id IN (11459)
                    OR test_d_media.media_id IN (11464)
                    OR test_d_media.media_id IN (11432)
                    OR test_d_media.media_id IN (12100)
                    OR test_d_media.media_id IN (10099)
                    OR test_d_media.media_id IN (12014)
                    OR test_d_media.media_id IN (10911, 10919, 10940)
                    OR test_d_media.media_id IN (12610)
                    OR test_d_media.media_id IN (12838)
                    OR test_d_media.media_id IN (10959)
                    OR test_d_media.media_id IN (12823)
                    OR test_d_media.media_id IN (10269, 10806, 10852, 10855, 10858, 10872, 10895, 10896, 10897, 10902, 10912, 10914, 10915, 10921, 10922, 10932, 10958, 10969, 10975, 10976, 10977, 10978, 11039, 11058, 11060, 11073, 11082, 11111, 11414, 11416, 11475, 11525, 11560, 11579, 11598, 11603, 11654, 11675, 11676, 11679, 11767, 11774, 11899, 12134, 12176, 12193, 12194, 12196, 12203, 12204, 12223, 12225, 12228, 12231, 12236, 12284, 13031, 13084)
                    OR test_d_media.media_id IN (12426, 12454, 12472)
                    OR test_d_media.media_id IN (11670)
                    OR test_d_media.media_id IN (10501)
                    OR test_d_media.media_id IN (11066)
                    OR test_d_media.media_id IN (12492)
                    OR test_d_media.media_id IN (11250)
                    OR test_d_media.media_id IN (11647)
                    OR test_d_media.media_id IN (12291, 12298, 13085)
                    OR test_d_media.media_id IN (11737)
                    OR test_d_media.media_id IN (12491)
                    OR test_d_media.media_id IN (12431)
                    OR test_d_media.media_id IN (12144)
                    OR test_d_media.media_id IN (11607, 11967, 12237)
                    OR test_d_media.media_id IN (12425)
                    OR test_d_media.media_id IN (11253)
                    OR test_d_media.media_id IN (12750)
                    OR test_d_media.media_id IN (12463)
                    OR test_d_media.media_id IN (12965)
                    OR test_d_media.media_id IN (11008, 12459)
                    OR test_d_media.media_id IN (11633)
                    OR test_d_media.media_id IN (11684)
                    OR test_d_media.media_id IN (11718)
                    OR test_d_media.media_id IN (10509)
                    OR test_d_media.media_id IN (12951)
                    OR test_d_media.media_id IN (11950, 13087, 13088)
                    OR test_d_media.media_id IN (11641)
                    OR test_d_media.media_id IN (11949)
                    OR test_d_media.media_id IN (11457)
                    OR test_d_media.media_id IN (12483)
                    OR test_d_media.media_id IN (11643)
                    OR test_d_media.media_id IN (12306)
                    OR test_d_media.media_id IN (11648, 13108)
                    OR test_d_media.media_id IN (11242, 11476, 12221)
                    OR test_d_media.media_id IN (11625)
                    OR test_d_media.media_id IN (11761)
                    OR test_d_media.media_id IN (10004, 10033, 10800, 10992, 11001, 11022, 11031, 11033, 11429, 11527, 11528, 11530, 11534, 11539, 11545, 11553, 11559, 11569, 11592, 11595, 11596, 11606, 11635, 11636, 11640, 11642, 11661, 11666, 11686, 11711, 11714, 11783, 11784, 11785, 11789, 11790, 11791, 11792, 11796, 11815, 11857, 11858, 11884, 11892, 11894, 11901, 11902, 11909, 11932, 11933, 11946, 11960, 12017, 12032, 12158, 12164, 12186, 12197, 12227, 12740, 12892, 12924, 12955, 12957, 12958, 12963)
                    OR test_d_media.media_id IN (11656)
                    OR test_d_media.media_id IN (10272, 11639)
                    OR test_d_media.media_id IN (11622, 11996)
                    OR test_d_media.media_id IN (11626, 12234, 12953)
                    OR test_d_media.media_id IN (12296, 12314, 12322)
                    OR test_d_media.media_id IN (11380, 11415, 11669)
                    OR test_d_media.media_id IN (12078, 12079)
                    OR test_d_media.media_id IN (11756)
                    OR test_d_media.media_id IN (11611, 11860, 11861, 11862, 11954, 11955, 11962, 11971)
                    OR test_d_media.media_id IN (11279)
                    OR test_d_media.media_id IN (12259)
                    OR test_d_media.media_id IN (12446)
                    OR test_d_media.media_id IN (11216, 11757, 12209)
                    OR test_d_media.media_id IN (11600)
                    OR test_d_media.media_id IN (10990)
                    OR test_d_media.media_id IN (12761)
                    OR test_d_media.media_id IN (11016)
                    OR test_d_media.media_id IN (11570)
                    OR test_d_media.media_id IN (11668)
                    OR test_d_media.media_id IN (11515)
                    OR test_d_media.media_id IN (12182)
                    OR test_d_media.media_id IN (12309, 12893)
                    OR test_d_media.media_id IN (11252)
                    OR test_d_media.media_id IN (11014)
                    OR test_d_media.media_id IN (12145)
                    OR test_d_media.media_id IN (12326)
                    OR test_d_media.media_id IN (11806)
                    OR test_d_media.media_id IN (11041, 11045, 11243, 11487, 11564, 12205)
                    OR test_d_media.media_id IN (12954)
                    OR test_d_media.media_id IN (12049)
                    OR test_d_media.media_id IN (12287)
                    OR test_d_media.media_id IN (12192)
                    OR test_d_media.media_id IN (12168)
                    OR test_d_media.media_id IN (11604)
                    OR test_d_media.media_id IN (11533)
                    OR test_d_media.media_id IN (12163)
                    OR test_d_media.media_id IN (10795)
                    OR test_d_media.media_id IN (11634)
                    OR test_d_media.media_id IN (11918)
                    OR test_d_media.media_id IN (12303)
                    OR test_d_media.media_id IN (12319)
                    OR test_d_media.media_id IN (12321)
                    OR test_d_media.media_id IN (11644)
                    OR test_d_media.media_id IN (12834)
                    OR test_d_media.media_id IN (11015)
                    OR test_d_media.media_id IN (12826)
                    OR test_d_media.media_id IN (10771)
                    OR test_d_media.media_id IN (10809)
                    OR test_d_media.media_id IN (12128)
                    OR test_d_media.media_id IN (11552)
                    OR test_d_media.media_id IN (12762)
                    OR test_d_media.media_id IN (10820)
                    OR test_d_media.media_id IN (11659)
                    OR test_d_media.media_id IN (10505, 10514, 10612, 10629, 10705, 10712, 11273, 11307, 11313)
                    OR test_d_media.media_id IN (10255, 10753, 10756, 11976)
                    OR test_d_media.media_id IN (12110)
                    OR test_d_media.media_id IN (10687)
                    OR test_d_media.media_id IN (10574, 10628)
                    OR test_d_media.media_id IN (10627)
                    OR test_d_media.media_id IN (12416)
                    OR test_d_media.media_id IN (10668)
                    OR test_d_media.media_id IN (10565, 10581, 10616, 10691, 12700)
                    OR test_d_media.media_id IN (10074)
                    OR test_d_media.media_id IN (10577)
                    OR test_d_media.media_id IN (12130)
                    OR test_d_media.media_id IN (11034)
                    OR test_d_media.media_id IN (11981)
                    OR test_d_media.media_id IN (10530, 10729)
                    OR test_d_media.media_id IN (10050, 10588, 10639)
                    OR test_d_media.media_id IN (11769)
                    OR test_d_media.media_id IN (12127)
                    OR test_d_media.media_id IN (10650)
                    OR test_d_media.media_id IN (10027, 10028, 10030, 10095, 10529, 10721, 12941)
                    OR test_d_media.media_id IN (10567, 10618)
                    OR test_d_media.media_id IN (10737)
                    OR test_d_media.media_id IN (10056)
                    OR test_d_media.media_id IN (10304, 11979, 12270)
                    OR test_d_media.media_id IN (10619, 10621, 10754)
                    OR test_d_media.media_id IN (10656)
                    OR test_d_media.media_id IN (11013)
                    OR test_d_media.media_id IN (10045, 10490, 10605, 10652, 10755, 10836, 10837, 10856, 10874, 10945, 10961, 11247, 11274, 11847, 11879, 11881, 11882, 11900, 11966, 12043)
                    OR test_d_media.media_id IN (11005)
                    OR test_d_media.media_id IN (10017, 10026, 10054, 10055, 10075, 10082, 10132, 10139, 10434, 10646, 10669, 10673, 10674, 10685, 10735, 10745, 11267, 11840, 11841, 11842, 11843, 11888, 12898, 12971)
                    OR test_d_media.media_id IN (12095)
                    OR test_d_media.media_id IN (10491)
                    OR test_d_media.media_id IN (10053, 10599, 10695, 10730, 11006)
                    OR test_d_media.media_id IN (11290)
                    OR test_d_media.media_id IN (13004)
                    OR test_d_media.media_id IN (10543, 11265)
                    OR test_d_media.media_id IN (10664, 10665, 10666, 10694)
                    OR test_d_media.media_id IN (12096)
                    OR test_d_media.media_id IN (10031, 10551, 10617, 10657, 10667, 10684)
                    OR test_d_media.media_id IN (10602)
                    OR test_d_media.media_id IN (10305, 10595)
                    OR test_d_media.media_id IN (10242)
                    OR test_d_media.media_id IN (10303, 10469, 12275, 12644)
                    OR test_d_media.media_id IN (11878)
                    OR test_d_media.media_id IN (10252, 10525, 10545, 10609, 10715, 10722)
                    OR test_d_media.media_id IN (10760)
                    OR test_d_media.media_id IN (12694)
                    OR test_d_media.media_id IN (10592)
                    OR test_d_media.media_id IN (10468, 10610)
                    OR test_d_media.media_id IN (12697)
                    OR test_d_media.media_id IN (10742)
                    OR test_d_media.media_id IN (10658)
                    OR test_d_media.media_id IN (10637, 10651)
                    OR test_d_media.media_id IN (10642, 10655, 10677)
                    OR test_d_media.media_id IN (10682)
                    OR test_d_media.media_id IN (10533)
                    OR test_d_media.media_id IN (10622, 10725)
                    OR test_d_media.media_id IN (10076, 10596, 10606)
                    OR test_d_media.media_id IN (10683)
                    OR test_d_media.media_id IN (12080)
                    OR test_d_media.media_id IN (10614, 10640)
                    OR test_d_media.media_id IN (10097)
                    OR test_d_media.media_id IN (12254)
                    OR test_d_media.media_id IN (10522)
                    OR test_d_media.media_id IN (10087)
                    OR test_d_media.media_id IN (10040, 10047, 10104, 10119, 10516, 10518, 10520, 10524, 10532, 10535, 10537, 10538, 10539, 10541, 10542, 10547, 10549, 10552, 10554, 10555, 10556, 10557, 10560, 10563, 10564, 10573, 10582, 10583, 10584, 10585, 10586, 10587, 10600, 10604, 10607, 10608, 10613, 10624, 10625, 10626, 10631, 10632, 10633, 10635, 10636, 10641, 10645, 10647, 10653, 10659, 10660, 10661, 10662, 10670, 10671, 10678, 10680, 10689, 10692, 10698, 10699, 10703, 10706, 10711, 10714, 10719, 10724, 10727, 10728, 10731, 10741, 10746, 10747, 10749, 10751, 10925, 10986, 11023, 11027, 11044, 11850, 11867, 11929, 11953, 11957, 11978, 11980, 11983, 11988, 12000, 12001, 12004, 12009, 12025, 12033, 12042, 12365, 12398, 12678, 12679, 12987)
                    OR test_d_media.media_id IN (10713)
                    OR test_d_media.media_id IN (10649, 10733)
                    OR test_d_media.media_id IN (10593, 10598, 10603, 10620, 10648, 10702)
                    OR test_d_media.media_id IN (10686)
                    OR test_d_media.media_id IN (12671)
                    OR test_d_media.media_id IN (10744)
                    OR test_d_media.media_id IN (10531)
                    OR test_d_media.media_id IN (10566)
                    OR test_d_media.media_id IN (12695)
                    OR test_d_media.media_id IN (10572)
                    OR test_d_media.media_id IN (10752)
                    OR test_d_media.media_id IN (10548)
                    OR test_d_media.media_id IN (10644)
                    OR test_d_media.media_id IN (10561)
                    OR test_d_media.media_id IN (10576)
                    OR test_d_media.media_id IN (10536)
                    OR test_d_media.media_id IN (10734)
                    OR test_d_media.media_id IN (10029, 10084, 10515, 10517, 10519, 10540, 10553, 10589, 10663, 10676, 10681, 10700, 10720, 10723, 10732, 10750, 12617, 12689, 12690, 12771, 12876)
                    OR test_d_media.media_id IN (12135)
                    OR test_d_media.media_id IN (10697)
                    OR test_d_media.media_id IN (10634, 12716)
                    OR test_d_media.media_id IN (12692)
                    OR test_d_media.media_id IN (10688, 10696)
                    OR test_d_media.media_id IN (10248)
                    OR test_d_media.media_id IN (12677)
                    OR test_d_media.media_id IN (11018)
                    OR test_d_media.media_id IN (10748)
                    OR test_d_media.media_id IN (10559, 10615)
                    OR test_d_media.media_id IN (10534)
                    OR test_d_media.media_id IN (10098, 10102, 10120, 11975)
                    OR test_d_media.media_id IN (10526)
                    OR test_d_media.media_id IN (10005, 10049, 10061, 10064, 10309, 10571, 10590, 10594, 10690, 10704)
                    OR test_d_media.media_id IN (10521, 10550, 10575)
                    OR test_d_media.media_id IN (10710)
                    OR test_d_media.media_id IN (10570, 11915)
                    OR test_d_media.media_id IN (10672)
                    OR test_d_media.media_id IN (10739)
                    OR test_d_media.media_id IN (12272)
                    OR test_d_media.media_id IN (12280)
                    OR test_d_media.media_id IN (10527)
                    OR test_d_media.media_id IN (10701)
                    OR test_d_media.media_id IN (12094)
                    OR test_d_media.media_id IN (10623, 10630, 10675, 10708, 10709, 10736, 10738)
                    OR test_d_media.media_id IN (10580, 10707)
                    OR test_d_media.media_id IN (10591)
                    OR test_d_media.media_id IN (10740)
                    OR test_d_media.media_id IN (10143, 10144, 10569, 10601, 10638, 10716, 10717, 10718, 10726, 10892, 11585)
                    OR test_d_media.media_id IN (10204, 10274)
                    OR test_d_media.media_id IN (11007)
                    OR test_d_media.media_id IN (10523)
                    OR test_d_media.media_id IN (11010)
                    OR test_d_media.media_id IN (10654)
                    OR test_d_media.media_id IN (12093)
                    OR test_d_media.media_id IN (10425, 10426, 10578, 10848)
                    OR test_d_media.media_id IN (11289)
                    OR test_d_media.media_id IN (10433, 10579, 11258, 11268, 11283)
                    OR test_d_media.media_id IN (10757, 10758, 10759)
                    OR test_d_media.media_id IN (10743, 12691)
                    OR test_d_media.media_id IN (10558)
                    OR test_d_media.media_id IN (11035)
                    OR test_d_media.media_id IN (10568)
                    OR test_d_media.media_id IN (10170, 10987)
                    OR test_d_media.media_id IN (10993)
                    OR test_d_media.media_id IN (10562)
                    OR test_d_media.media_id IN (12124)
                    OR test_d_media.media_id IN (11019)
                    OR test_d_media.media_id IN (12104)
                    OR test_d_media.media_id IN (12125)
                    OR test_d_media.media_id IN (12126)
                    OR test_d_media.media_id IN (12855)
                    OR test_d_media.media_id IN (12264)
                    OR test_d_media.media_id IN (12784)
                    OR test_d_media.media_id IN (12639)
                    OR test_d_media.media_id IN (11269)
                    OR test_d_media.media_id IN (10063)
                    OR test_d_media.media_id IN (12063)
                    OR test_d_media.media_id IN (10955)
                    OR test_d_media.media_id IN (10546)
                    OR test_d_media.media_id IN (10643)
                    OR test_d_media.media_id IN (10225)
                    OR test_d_media.media_id IN (10611)
                    OR test_d_media.media_id IN (10679)
                    OR test_d_media.media_id IN (10544)
                    OR test_d_media.media_id IN (12098)
                    OR test_d_media.media_id IN (10528)
                    OR test_d_media.media_id IN (10597)
                    OR test_d_media.media_id IN (11030)
                    OR test_d_media.media_id IN (10009, 10012, 10057, 10060, 10088, 10096, 10103, 10107, 10121, 10141, 10145, 10146, 10167, 10187, 10211, 10279, 10286, 10422, 10423, 10424, 10428, 10450, 10451, 11025, 11048, 11102, 11291, 11294, 11302, 11303, 11304, 11306, 11309, 11310, 11316, 11317, 11327, 11334, 11336, 11337, 11338, 11339, 11343, 11345, 11346, 11349, 11350, 11353, 11354, 11355, 11356, 11357, 11362, 11364, 11365, 11368, 11371, 11373, 11374, 11376, 11379, 11562, 11575, 11610, 11653, 11660, 11710, 11713, 11765, 11766, 11853, 12059, 12419, 12420, 12421, 12422, 12500, 12502, 12507, 12527, 12534, 12573, 12590, 12649, 12746, 12770, 12874, 12943)
                    OR test_d_media.media_id IN (11315, 12229, 12538, 13049, 13054)
                    OR test_d_media.media_id IN (12871)
                    OR test_d_media.media_id IN (10385)
                    OR test_d_media.media_id IN (12854, 12981)
                    OR test_d_media.media_id IN (11295)
                    OR test_d_media.media_id IN (12654, 12726, 12805, 12829, 12935, 12949, 12979, 13036)
                    OR test_d_media.media_id IN (11504, 12625, 12652, 12858, 12891)
                    OR test_d_media.media_id IN (12598)
                    OR test_d_media.media_id IN (10086, 12531, 12614, 12782, 12901)
                    OR test_d_media.media_id IN (10917, 11106, 11173, 11281, 11324, 12046, 12212, 12213, 12243, 12418, 12520, 12526)
                    OR test_d_media.media_id IN (10394, 10504)
                    OR test_d_media.media_id IN (12866)
                    OR test_d_media.media_id IN (12105)
                    OR test_d_media.media_id IN (10393)
                    OR test_d_media.media_id IN (12052)
                    OR test_d_media.media_id IN (10877, 10943)
                    OR test_d_media.media_id IN (10999)
                    OR test_d_media.media_id IN (11352, 12390)
                    OR test_d_media.media_id IN (11017)
                    OR test_d_media.media_id IN (12576)
                    OR test_d_media.media_id IN (10209, 11056, 11079, 11103, 11133, 11135, 11136, 11203, 11228, 11234, 11519)
                    OR test_d_media.media_id IN (12867)
                    OR test_d_media.media_id IN (10388)
                    OR test_d_media.media_id IN (10127, 12743, 12811, 12859)
                    OR test_d_media.media_id IN (11344)
                    OR test_d_media.media_id IN (10365, 10412)
                    OR test_d_media.media_id IN (10042, 10043, 10193, 11308)
                    OR test_d_media.media_id IN (12704)
                    OR test_d_media.media_id IN (10351, 10414)
                    OR test_d_media.media_id IN (10149, 11134)
                    OR test_d_media.media_id IN (12288)
                    OR test_d_media.media_id IN (12414)
                    OR test_d_media.media_id IN (10369, 10403)
                    OR test_d_media.media_id IN (10327)
                    OR test_d_media.media_id IN (10324, 10421)
                    OR test_d_media.media_id IN (10808)
                    OR test_d_media.media_id IN (10475)
                    OR test_d_media.media_id IN (12908)
                    OR test_d_media.media_id IN (10007, 10011, 10014, 10015, 10018, 10020, 10021, 10035, 10039, 10044, 10046, 10058, 10062, 10070, 10073, 10078, 10079, 10081, 10083, 10085, 10089, 10093, 10109, 10111, 10112, 10114, 10115, 10136, 10138, 10142, 10147, 10154, 10156, 10157, 10158, 10159, 10160, 10161, 10162, 10163, 10166, 10172, 10173, 10180, 10181, 10182, 10184, 10194, 10195, 10199, 10203, 10205, 10208, 10210, 10213, 10216, 10217, 10220, 10222, 10223, 10230, 10233, 10234, 10235, 10237, 10241, 10243, 10257, 10258, 10259, 10265, 10266, 10276, 10280, 10281, 10282, 10285, 10288, 10289, 10290, 10291, 10292, 10296, 10297, 10299, 10310, 10311, 10312, 10313, 10314, 10315, 10316, 10317, 10441, 10445, 10449, 10455, 10456, 10459, 10460, 10463, 10464, 10465, 10466, 10477, 10479, 10482, 10496, 10507, 10766, 10768, 10769, 10787, 10805, 10811, 10824, 10861, 10893, 10933, 10938, 11036, 11040, 11078, 11099, 11119, 11120, 11121, 11122, 11123, 11124, 11125, 11128, 11129, 11130, 11131, 11132, 11137, 11139, 11140, 11141, 11143, 11144, 11145, 11146, 11147, 11148, 11149, 11150, 11151, 11154, 11155, 11157, 11158, 11159, 11160, 11161, 11162, 11163, 11164, 11165, 11167, 11172, 11174, 11175, 11176, 11177, 11178, 11179, 11181, 11183, 11184, 11187, 11188, 11189, 11191, 11192, 11193, 11194, 11196, 11198, 11199, 11200, 11202, 11205, 11206, 11208, 11210, 11211, 11212, 11213, 11217, 11219, 11220, 11222, 11223, 11224, 11225, 11226, 11227, 11230, 11231, 11233, 11235, 11236, 11237, 11296, 11297, 11298, 11299, 11300, 11311, 11322, 11326, 11329, 11332, 11341, 11342, 11358, 11367, 11383, 11405, 11407, 11417, 11437, 11440, 11441, 11442, 11445, 11467, 11470, 11473, 11482, 11694, 11698, 11724, 11739, 11741, 11742, 11746, 11747, 11751, 11753, 11755, 11873, 12055, 12056, 12057, 12058, 12065, 12068, 12073, 12074, 12075, 12076, 12086, 12089, 12091, 12099, 12102, 12103, 12109, 12111, 12112, 12113, 12132, 12133, 12136, 12138, 12147, 12148, 12151, 12167, 12174, 12179, 12181, 12184, 12187, 12189, 12190, 12198, 12199, 12202, 12224, 12239, 12245, 12246, 12256, 12260, 12266, 12274, 12276, 12277, 12279, 12350, 12351, 12352, 12353, 12354, 12355, 12356, 12359, 12360, 12361, 12363, 12368, 12370, 12372, 12377, 12380, 12381, 12382, 12383, 12384, 12386, 12387, 12388, 12389, 12391, 12394, 12395, 12396, 12397, 12399, 12400, 12403, 12404, 12405, 12406, 12407, 12408, 12410, 12411, 12412, 12413, 12417, 12434, 12445, 12455, 12486, 12495, 12498, 12501, 12503, 12505, 12506, 12510, 12513, 12514, 12515, 12516, 12517, 12528, 12535, 12539, 12549, 12553, 12564, 12572, 12574, 12578, 12579, 12588, 12592, 12596, 12600, 12602, 12604, 12609, 12613, 12622, 12657, 12661, 12662, 12664, 12681, 12684, 12723, 12727, 12729, 12734, 12742, 12755, 12776, 12798, 12819, 12843, 12847, 12905, 12912, 12931, 12937, 12948, 12974, 12984, 12993, 13003, 13027, 13037, 13038, 13039, 13060, 13073)
                    OR test_d_media.media_id IN (10383)
                    OR test_d_media.media_id IN (10483, 10804)
                    OR test_d_media.media_id IN (12522)
                    OR test_d_media.media_id IN (10398, 10427, 11700, 11740, 11744)
                    OR test_d_media.media_id IN (10367, 10382, 10387, 10402, 10405, 10406, 10419, 10775, 11480, 12877, 12967)
                    OR test_d_media.media_id IN (10016, 10287, 11152, 12793, 12913, 12997, 13063)
                    OR test_d_media.media_id IN (10407)
                    OR test_d_media.media_id IN (10400, 10404, 12794)
                    OR test_d_media.media_id IN (10399)
                    OR test_d_media.media_id IN (10380)
                    OR test_d_media.media_id IN (10175, 10343, 12765, 12890)
                    OR test_d_media.media_id IN (10325)
                    OR test_d_media.media_id IN (12860, 12982)
                    OR test_d_media.media_id IN (11729)
                    OR test_d_media.media_id IN (10010, 10036, 10048, 10077, 10090, 10091, 10092, 10117, 10128, 10129, 10133, 10134, 10140, 10155, 10164, 10169, 10174, 10179, 10192, 10196, 10198, 10218, 10219, 10256, 10264, 10275, 10277, 10278, 10283, 10307, 10480, 11126, 11399, 11412, 11418, 11419, 11436, 11449, 11450, 11722, 12367, 12373, 12374, 12378, 12401, 12509, 12565, 12567, 12589, 12597, 12603, 12611, 12626, 12628, 12629, 12646, 12647, 12656, 12672, 12675, 12696, 12703, 12707, 12711, 12714, 12725, 12728, 12730, 12739, 12747, 12756, 12763, 12764, 12766, 12767, 12781, 12786, 12787, 12790, 12801, 12803, 12808, 12813, 12845, 12850, 12880, 12884, 12896, 12903, 12904, 12906, 12920, 12933, 12936, 12947, 12969, 12983, 12985, 12990, 12991, 12992, 13002, 13052)
                    OR test_d_media.media_id IN (12467)
                    OR test_d_media.media_id IN (12663)
                    OR test_d_media.media_id IN (10361, 10410)
                    OR test_d_media.media_id IN (10354)
                    OR test_d_media.media_id IN (10392)
                    OR test_d_media.media_id IN (10438, 10443, 11701, 11731, 11762, 12586, 12591, 12593, 12862)
                    OR test_d_media.media_id IN (10006, 10034, 10185, 10186, 12814)
                    OR test_d_media.media_id IN (11408)
                    OR test_d_media.media_id IN (10499)
                    OR test_d_media.media_id IN (10409, 10440, 10452, 12544, 12665, 12807, 12852, 12865, 12940, 13006, 13019, 13064)
                    OR test_d_media.media_id IN (10260)
                    OR test_d_media.media_id IN (10431)
                    OR test_d_media.media_id IN (10072, 10178, 11138, 12536, 12571, 12581, 12724)
                    OR test_d_media.media_id IN (12718, 12881)
                    OR test_d_media.media_id IN (10375)
                    OR test_d_media.media_id IN (10308, 10487, 12751, 12944)
                    OR test_d_media.media_id IN (10013, 11703, 11707)
                    OR test_d_media.media_id IN (12804)
                    OR test_d_media.media_id IN (10416)
                    OR test_d_media.media_id IN (10326, 10332, 10346, 10348, 10353, 10358, 10363, 10366, 10368, 10370, 10389, 10391, 10415, 10417, 12336, 12371, 12376, 12637, 12857, 12921, 12934)
                    OR test_d_media.media_id IN (10386)
                    OR test_d_media.media_id IN (10338)
                    OR test_d_media.media_id IN (10379)
                    OR test_d_media.media_id IN (10472)
                    OR test_d_media.media_id IN (10236, 12911)
                    OR test_d_media.media_id IN (10376)
                    OR test_d_media.media_id IN (12357)
                    OR test_d_media.media_id IN (12295, 12789)
                    OR test_d_media.media_id IN (10489)
                    OR test_d_media.media_id IN (10322, 10330, 10339, 10350, 10352, 10357, 10364)
                    OR test_d_media.media_id IN (10337, 10341, 10355, 10359, 10372, 10395, 10396, 10397, 10411)
                    OR test_d_media.media_id IN (10105, 10124, 10168, 10183, 10188, 10232, 10238, 10247, 10284, 10887, 11301, 11377, 11381, 11455, 11466, 11468, 11477, 11478, 11483, 11501, 11502, 11695, 11696, 11697, 11699, 11702, 11704, 11705, 11712, 11715, 11716, 11720, 11725, 11726, 11732, 11735, 11738, 11745, 11748, 11759, 11760, 12029, 12082, 12083, 12097, 12149, 12150, 12177, 12201, 12214, 12215, 12217, 12218, 12222, 12278, 12379, 12385, 12447, 12461, 12521, 12570, 12650, 12680, 12701, 12777, 12802, 12902, 12930, 12946, 13035, 13065, 13077, 13083)
                    OR test_d_media.media_id IN (12569)
                    OR test_d_media.media_id IN (10125, 11471)
                    OR test_d_media.media_id IN (12479)
                    OR test_d_media.media_id IN (13033)
                    OR test_d_media.media_id IN (10349, 12584, 12674, 13067, 13071)
                    OR test_d_media.media_id IN (12342)
                    OR test_d_media.media_id IN (11505, 11727, 12612, 12616, 12791, 12995)
                    OR test_d_media.media_id IN (10329, 12233, 12872, 13034, 13046)
                    OR test_d_media.media_id IN (13076)
                    OR test_d_media.media_id IN (10435, 12349, 12815, 12978)
                    OR test_d_media.media_id IN (12155)
                    OR test_d_media.media_id IN (12432)
                    OR test_d_media.media_id IN (10244, 12585)
                    OR test_d_media.media_id IN (11496, 11733, 12595, 12682)
                    OR test_d_media.media_id IN (12627)
                    OR test_d_media.media_id IN (10796)
                    OR test_d_media.media_id IN (11734)
                    OR test_d_media.media_id IN (12545)
                    OR test_d_media.media_id IN (12754, 12846)
                    OR test_d_media.media_id IN (12253, 12797)
                    OR test_d_media.media_id IN (10131)
                    OR test_d_media.media_id IN (12732, 12783)
                    OR test_d_media.media_id IN (10135, 12945)
                    OR test_d_media.media_id IN (10318)
                    OR test_d_media.media_id IN (13032)
                    OR test_d_media.media_id IN (10177, 12480)
                    OR test_d_media.media_id IN (12720)
                    OR test_d_media.media_id IN (11854)
                    OR test_d_media.media_id IN (10321, 12863)
                    OR test_d_media.media_id IN (10025, 10080, 10130, 10151, 10152, 10176, 10201, 10254, 10467, 11170, 11229, 11406, 11426, 11438, 11497, 11508, 11509, 11693, 11730, 11736, 11749, 11750, 11764, 12012, 12159, 12161, 12165, 12166, 12169, 12171, 12172, 12180, 12210, 12211, 12216, 12364, 12375, 12488, 12504, 12511, 12543, 12547, 12551, 12552, 12557, 12560, 12568, 12577, 12635, 12651, 12731, 12741, 12842, 12868, 12895, 12932, 12968, 12975, 12977, 12994, 13005, 13013, 13016, 13056, 13059, 13062, 13069, 13075, 13082)
                    OR test_d_media.media_id IN (10436)
                    OR test_d_media.media_id IN (10226, 10293, 10301)
                    OR test_d_media.media_id IN (10295)
                    OR test_d_media.media_id IN (10071)
                    OR test_d_media.media_id IN (12683)
                    OR test_d_media.media_id IN (10067, 10231, 12582, 12849)
                    OR test_d_media.media_id IN (12290)
                    OR test_d_media.media_id IN (10094, 10785)
                    OR test_d_media.media_id IN (12249)
                    OR test_d_media.media_id IN (10068, 10240, 10249, 10418, 10918, 11020, 12054, 12114, 12139, 12140, 12142, 12247, 12257, 12265, 12271, 12554, 13048, 13066)
                    OR test_d_media.media_id IN (12402)
                    OR test_d_media.media_id IN (12308)
                    OR test_d_media.media_id IN (12523)
                    OR test_d_media.media_id IN (10331, 12775)
                    OR test_d_media.media_id IN (12887)
                    OR test_d_media.media_id IN (12003)
                    OR test_d_media.media_id IN (12605, 12988)
                    OR test_d_media.media_id IN (10227)
                    OR test_d_media.media_id IN (10197, 10334, 10420)
                    OR test_d_media.media_id IN (10878, 10971, 11038, 11594, 11773, 12191, 12269, 12494, 12542, 12640, 12641, 12642, 12643, 13010, 13081)
                    OR test_d_media.media_id IN (12562)
                    OR test_d_media.media_id IN (10377)
                    OR test_d_media.media_id IN (12393)
                    OR test_d_media.media_id IN (13017)
                    OR test_d_media.media_id IN (13011)
                    OR test_d_media.media_id IN (12449)
                    OR test_d_media.media_id IN (12620)
                    OR test_d_media.media_id IN (10378)
                    OR test_d_media.media_id IN (10320)
                    OR test_d_media.media_id IN (10384)
                    OR test_d_media.media_id IN (12392, 12537, 12851)
                    OR test_d_media.media_id IN (10148)
                    OR test_d_media.media_id IN (12885)
                    OR test_d_media.media_id IN (12195, 12207, 12208)
                    OR test_d_media.media_id IN (12294)
                    OR test_d_media.media_id IN (10323)
                    OR test_d_media.media_id IN (13055)
                    OR test_d_media.media_id IN (12830)
                    OR test_d_media.media_id IN (10764)
                    OR test_d_media.media_id IN (12267)
                    OR test_d_media.media_id IN (10106, 10246, 10261, 10262, 10506, 10777, 10827, 11169, 11171, 11186, 11427, 11537, 11566, 12252, 12258, 12524, 12525, 12540, 12541, 12546, 12548, 12580, 12587, 12599, 12601)
                    OR test_d_media.media_id IN (12332)
                    OR test_d_media.media_id IN (10810, 12238, 12328, 12346, 13058)
                    OR test_d_media.media_id IN (10333, 10335)
                    OR test_d_media.media_id IN (11021, 12115)
                    OR test_d_media.media_id IN (10347)
                    OR test_d_media.media_id IN (10788)
                    OR test_d_media.media_id IN (10797)
                    OR test_d_media.media_id IN (10110, 12670)
                    OR test_d_media.media_id IN (12084)
                    OR test_d_media.media_id IN (10345)
                    OR test_d_media.media_id IN (10776)
                    OR test_d_media.media_id IN (12561)
                    OR test_d_media.media_id IN (13051)
                    OR test_d_media.media_id IN (12821)
                    OR test_d_media.media_id IN (12583)
                    OR test_d_media.media_id IN (12316)
                    OR test_d_media.media_id IN (12518)
                    OR test_d_media.media_id IN (10437, 12563)
                    OR test_d_media.media_id IN (12710)
                    OR test_d_media.media_id IN (12123)
                    OR test_d_media.media_id IN (12129, 12146)
                    OR test_d_media.media_id IN (12715)
                    OR test_d_media.media_id IN (12108)
                    OR test_d_media.media_id IN (10900, 12061, 12606, 12607, 12608)
                    OR test_d_media.media_id IN (12090)
                    OR test_d_media.media_id IN (11347, 11366, 12450)
                    OR test_d_media.media_id IN (12900)
                    OR test_d_media.media_id IN (12575)
                    OR test_d_media.media_id IN (10476)
                    OR test_d_media.media_id IN (10495, 11127, 11156, 12489, 12556, 12558, 12559, 12749)
                    OR test_d_media.media_id IN (12658)
                    OR test_d_media.media_id IN (11721)
                    OR test_d_media.media_id IN (10845)
                    OR test_d_media.media_id IN (10336)
                    OR test_d_media.media_id IN (12717)
                    OR test_d_media.media_id IN (12942)
                    OR test_d_media.media_id IN (12117, 12241, 12712)
                    OR test_d_media.media_id IN (12619)
                    OR test_d_media.media_id IN (10812)
                    OR test_d_media.media_id IN (10430, 11218, 11706, 12362, 12366, 12369, 12748)
                    OR test_d_media.media_id IN (12861)
                    OR test_d_media.media_id IN (10381)
                    OR test_d_media.media_id IN (12433)
                    OR test_d_media.media_id IN (10502)
                    OR test_d_media.media_id IN (10813, 10841)
                    OR test_d_media.media_id IN (12188, 12673, 12886)
                    OR test_d_media.media_id IN (12768)
                    OR test_d_media.media_id IN (10413)
                    OR test_d_media.media_id IN (10038, 10122, 10123, 10253, 11118, 11319, 11335, 11370, 12283, 12998)
                    OR test_d_media.media_id IN (12409)
                    OR test_d_media.media_id IN (11361)
                    OR test_d_media.media_id IN (10373)
                    OR test_d_media.media_id IN (12341)
                    OR test_d_media.media_id IN (10118)
                    OR test_d_media.media_id IN (12348)
                    OR test_d_media.media_id IN (12053)
                    OR test_d_media.media_id IN (12092, 12722)
                    OR test_d_media.media_id IN (10401)
                    OR test_d_media.media_id IN (12594)
                    OR test_d_media.media_id IN (12719)
                    OR test_d_media.media_id IN (10101)
                    OR test_d_media.media_id IN (12330, 12333, 12335)
                    OR test_d_media.media_id IN (12327)
                    OR test_d_media.media_id IN (11166, 11221)
                    OR test_d_media.media_id IN (10374)
                    OR test_d_media.media_id IN (12331)
                    OR test_d_media.media_id IN (10116)
                    OR test_d_media.media_id IN (10019, 10300, 11197, 11207, 12566, 12645)
                    OR test_d_media.media_id IN (10408)
                    OR test_d_media.media_id IN (10263)
                    OR test_d_media.media_id IN (11369)
                    OR test_d_media.media_id IN (11617)
                    OR test_d_media.media_id IN (11800)
                    OR test_d_media.media_id IN (10979)
                    OR test_d_media.media_id IN (12925)
                    OR test_d_media.media_id IN (12475, 12555)
                    OR test_d_media.media_id IN (12533)
                    OR test_d_media.media_id IN (12508)
                    OR test_d_media.media_id IN (10342)
                    OR test_d_media.media_id IN (10340)
                    OR test_d_media.media_id IN (12735, 12976)
                    OR test_d_media.media_id IN (13070)
                    OR test_d_media.media_id IN (10815)
                    OR test_d_media.media_id IN (10371)
                    OR test_d_media.media_id IN (10356)
                    OR test_d_media.media_id IN (12785)
                    OR test_d_media.media_id IN (10825, 11068, 11074, 11204, 12081, 12120, 12206)
                    OR test_d_media.media_id IN (13022)
                    OR test_d_media.media_id IN (12623)
                    OR test_d_media.media_id IN (11004)
                    OR test_d_media.media_id IN (10229)
                    OR test_d_media.media_id IN (10991, 11168, 11209, 11717, 12618)
                    OR test_d_media.media_id IN (13007, 13023, 13024, 13025)
                    OR test_d_media.media_id IN (13026)
                    OR test_d_media.media_id IN (10189)
                    OR test_d_media.media_id IN (10328)
                    OR test_d_media.media_id IN (10200)
                    OR test_d_media.media_id IN (10069)
                    OR test_d_media.media_id IN (10857)
                    OR test_d_media.media_id IN (12822)
                    OR test_d_media.media_id IN (10814, 10826, 10888, 10947, 11215, 13001)
                    OR test_d_media.media_id IN (12827)
                    OR test_d_media.media_id IN (12778, 12795)
                    OR test_d_media.media_id IN (12173)
                    OR test_d_media.media_id IN (10778)
                    OR test_d_media.media_id IN (12281)
                    OR test_d_media.media_id IN (12550)
                    OR test_d_media.media_id IN (12289)
                    OR test_d_media.media_id IN (10891, 11110, 11333, 11887, 12512)
                    OR test_d_media.media_id IN (10988, 12496)
                    OR test_d_media.media_id IN (11330)
                    OR test_d_media.media_id IN (12444)
                    OR test_d_media.media_id IN (10344)
                    OR test_d_media.media_id IN (10360)
                    OR test_d_media.media_id IN (10442)
                    OR test_d_media.media_id IN (10022, 10024, 12240, 12519)
                    OR test_d_media.media_id IN (12358)
                    OR test_d_media.media_id IN (10478, 11201, 12497)
                    OR test_d_media.media_id IN (11182, 11195)
                    OR test_d_media.media_id IN (12499)
                    OR test_d_media.media_id IN (11743)
                    OR test_d_media.media_id IN (10171)
                    OR test_d_media.media_id IN (12796)
                    OR test_d_media.media_id IN (11214)
                    OR test_d_media.media_id IN (12318)
                    OR test_d_media.media_id IN (12466)
                    OR test_d_media.media_id IN (12162)
                    OR test_d_media.media_id IN (10319)
                    OR test_d_media.media_id IN (10494, 11180, 12529, 12530, 12532)
                    OR test_d_media.media_id IN (10153, 10362)
                    OR test_d_media.media_id IN (12415)
                    OR test_d_media.media_id IN (11232)
                    OR test_d_media.media_id IN (10390)
                    OR test_d_media.media_id IN (11072, 11081, 11096, 11249, 11254, 11275, 11287, 11312, 11351, 11360, 11363, 11372, 11378, 11859)
                    OR test_d_media.media_id IN (10190)
                    OR test_d_media.media_id IN (10126)
                    OR test_d_media.media_id IN (12667)
                    OR test_d_media.media_id IN (12758)
                    OR test_d_media.media_id IN (10513)
                    OR test_d_media.media_id IN (10960)
                    OR test_d_media.media_id IN (12122)
                    OR test_d_media.media_id IN (12107)
                    OR test_d_media.media_id IN (10928, 11071, 11093, 11912, 11913, 11914)
                    OR test_d_media.media_id IN (10503)
                    OR test_d_media.media_id IN (10023)
                    OR test_d_media.media_id IN (11251, 13110)
                    OR test_d_media.media_id IN (12131)
                    OR test_d_media.media_id IN (10886, 10939, 11064, 11069, 11272, 11278, 11401, 11451, 11490, 11965, 12141, 13041, 13042, 13053, 13111, 13112)
                    OR test_d_media.media_id IN (11083, 11115)
                    OR test_d_media.media_id IN (11602)
                    OR test_d_media.media_id IN (11400, 11402, 11489)
                    OR test_d_media.media_id IN (10001, 10065, 10207, 10798, 11386, 11546, 11554, 11565, 11568, 11588, 11608, 11609, 11618, 11619, 11620, 11623, 11627, 11628, 11629, 11637, 11645, 11655, 11663, 11685, 11690, 12685, 12721, 13012)
                    OR test_d_media.media_id IN (11431)
                    OR test_d_media.media_id IN (13045)
                    OR test_d_media.media_id IN (12051, 12106, 12474, 13057)
                    OR test_d_media.media_id IN (11403, 11499)
                    OR test_d_media.media_id IN (12153, 12154)
                    OR test_d_media.media_id IN (12178)
                    OR test_d_media.media_id IN (10473)
                    OR test_d_media.media_id IN (11391)
                    OR test_d_media.media_id IN (10956, 11507, 12833)
                    OR test_d_media.media_id IN (11285)
                    OR test_d_media.media_id IN (12064)
                    OR test_d_media.media_id IN (13030)
                    OR test_d_media.media_id IN (12471)
                    OR test_d_media.media_id IN (13050)
                    OR test_d_media.media_id IN (11662)
                    OR test_d_media.media_id IN (12848)
                    OR test_d_media.media_id IN (12435)
                    OR test_d_media.media_id IN (11264)
                    OR test_d_media.media_id IN (10474)
                    OR test_d_media.media_id IN (11084, 12883)
                    OR test_d_media.media_id IN (11671)
                    OR test_d_media.media_id IN (13074)
                    OR test_d_media.media_id IN (11681)
                    OR test_d_media.media_id IN (12686)
                    OR test_d_media.media_id IN (10951, 11395)
                    OR test_d_media.media_id IN (11259, 13094, 13095)
                    OR test_d_media.media_id IN (12621)
                    OR test_d_media.media_id IN (10493)
                    OR test_d_media.media_id IN (12788)
                    OR test_d_media.media_id IN (11664)
                    OR test_d_media.media_id IN (11359, 11375, 11709)
                    OR test_d_media.media_id IN (10693, 11340)
                    OR test_d_media.media_id IN (11665)
                    OR test_d_media.media_id IN (10907, 10929, 11085, 11091, 11097, 13044)
                    OR test_d_media.media_id IN (12800, 12915)
                    OR test_d_media.media_id IN (10448)
                    OR test_d_media.media_id IN (12477)
                    OR test_d_media.media_id IN (11392)
                    OR test_d_media.media_id IN (12484, 12485)
                    OR test_d_media.media_id IN (10432)
                    OR test_d_media.media_id IN (12478)
                    OR test_d_media.media_id IN (10228, 10271, 10807, 11245, 13086)
                    OR test_d_media.media_id IN (10967)
                    OR test_d_media.media_id IN (12655, 12780)
                    OR test_d_media.media_id IN (12816)
                    OR test_d_media.media_id IN (11485)
                    OR test_d_media.media_id IN (10863, 10920, 11320)
                    OR test_d_media.media_id IN (12840)
                    OR test_d_media.media_id IN (10786)
                    OR test_d_media.media_id IN (11286)
                    OR test_d_media.media_id IN (12116)
                    OR test_d_media.media_id IN (11631)
                    OR test_d_media.media_id IN (10843)
                    OR test_d_media.media_id IN (11077, 11561, 11834)
                    OR test_d_media.media_id IN (13014)
                    OR test_d_media.media_id IN (11051)
                    OR test_d_media.media_id IN (12773)
                    OR test_d_media.media_id IN (10214)
                    OR test_d_media.media_id IN (10860, 10930, 10970)
                    OR test_d_media.media_id IN (12914)
                    OR test_d_media.media_id IN (12653)
                    OR test_d_media.media_id IN (12757)
                    OR test_d_media.media_id IN (11116)
                    OR test_d_media.media_id IN (10221, 11605, 11839, 11919)
                    OR test_d_media.media_id IN (12824)
                    OR test_d_media.media_id IN (11080, 11086)
                    OR test_d_media.media_id IN (11348)
                    OR test_d_media.media_id IN (11331)
                    OR test_d_media.media_id IN (11394, 11422, 11460)
                    OR test_d_media.media_id IN (10492)
                    OR test_d_media.media_id IN (11667)
                    OR test_d_media.media_id IN (12050)
                    OR test_d_media.media_id IN (11262)
                    OR test_d_media.media_id IN (10454, 12693)
                    OR test_d_media.media_id IN (12118)
                    OR test_d_media.media_id IN (11305)
                    OR test_d_media.media_id IN (12832)
                    OR test_d_media.media_id IN (13000)
                    OR test_d_media.media_id IN (12441)
                    OR test_d_media.media_id IN (10037, 10847, 10952, 11260, 12137, 12839, 12996)
                    OR test_d_media.media_id IN (10833, 10904, 12760, 13020)
                    OR test_d_media.media_id IN (10791)
                    OR test_d_media.media_id IN (12972)
                    OR test_d_media.media_id IN (12799)
                    OR test_d_media.media_id IN (11240)
                    OR test_d_media.media_id IN (13072)
                    OR test_d_media.media_id IN (11481)
                    OR test_d_media.media_id IN (10512)
                    OR test_d_media.media_id IN (10215, 10816, 11109, 11822)
                    OR test_d_media.media_id IN (10488)
                    OR test_d_media.media_id IN (12897)
                    OR test_d_media.media_id IN (11572)
                    OR test_d_media.media_id IN (12950)
                    OR test_d_media.media_id IN (10041, 10059, 10150, 10224, 10239, 10245, 10298, 10306, 10767, 10774, 10802, 10819, 10822, 10844, 10851, 10853, 10854, 10864, 10865, 10898, 10903, 10905, 10908, 10910, 10923, 10931, 10942, 10950, 10953, 10954, 10983, 11050, 11054, 11055, 11061, 11065, 11070, 11075, 11088, 11092, 11104, 11108, 11112, 11241, 11271, 11325, 11384, 11385, 11387, 11388, 11389, 11390, 11397, 11409, 11410, 11413, 11420, 11423, 11430, 11434, 11443, 11444, 11448, 11452, 11453, 11454, 11458, 11461, 11462, 11463, 11465, 11474, 11484, 11488, 11492, 11498, 11503, 11506, 11511, 11512, 11521, 11540, 11543, 11548, 11593, 11768, 11845, 11856, 11889, 11911, 11917, 11923, 11924, 11945, 11999, 12018, 12021, 12027, 12453, 12744)
                    OR test_d_media.media_id IN (10003, 11425, 12738, 12986)
                    OR test_d_media.media_id IN (11886)
                    OR test_d_media.media_id IN (10066, 10875, 10876, 10884, 10934, 11280, 11398, 11456, 11491, 11827, 12630, 12631, 12632, 12668, 12687, 12699, 12772, 12818, 12879, 12894, 12938, 12989)
                    OR test_d_media.media_id IN (12909)
                    OR test_d_media.media_id IN (10458)
                    OR test_d_media.media_id IN (12870)
                    OR test_d_media.media_id IN (12806)
                    OR test_d_media.media_id IN (12709, 12917)
                    OR test_d_media.media_id IN (12452, 12462, 12465)
                    OR test_d_media.media_id IN (11630)
                    OR test_d_media.media_id IN (11818)
                    OR test_d_media.media_id IN (11057, 11510, 11778, 12817)
                    OR test_d_media.media_id IN (12961)
                    OR test_d_media.media_id IN (11052)
                    OR test_d_media.media_id IN (10294)
                    OR test_d_media.media_id IN (10439)
                    OR test_d_media.media_id IN (10457, 11495)
                    OR test_d_media.media_id IN (12873)
                    OR test_d_media.media_id IN (12676, 12705, 12706)
                    OR test_d_media.media_id IN (10137, 11944)
                    OR test_d_media.media_id IN (11472)
                    OR test_d_media.media_id IN (11314, 11318)
                    OR test_d_media.media_id IN (10981)
                    OR test_d_media.media_id IN (11255)
                    OR test_d_media.media_id IN (12476)
                    OR test_d_media.media_id IN (11396)
                    OR test_d_media.media_id IN (11910)
                    OR test_d_media.media_id IN (11246)
                    OR test_d_media.media_id IN (12916)
                    OR test_d_media.media_id IN (11113)
                    OR test_d_media.media_id IN (11270)
                    OR test_d_media.media_id IN (11263)
                    OR test_d_media.media_id IN (12273)
                    OR test_d_media.media_id IN (10113, 10165, 10212, 13092, 13093)
                    OR test_d_media.media_id IN (11257, 11266)
                    OR test_d_media.media_id IN (12769)
                    OR test_d_media.media_id IN (10268, 10829, 10830, 10831, 10832, 10834, 10838, 10839, 10840, 10842, 10846, 10849, 10850, 10859, 10862, 10866, 10867, 10868, 10870, 10879, 10880, 10881, 10882, 10883, 10899, 10906, 10909, 10913, 10926, 10935, 10936, 10937, 10941, 10948, 10949, 10957, 10962, 10968, 10973, 10974, 10980, 11047, 11087, 11090, 11098, 11100, 11276, 11277, 11293, 11321, 11328, 11424, 11433, 11435, 11446, 11447, 11469, 11520, 11522, 11723, 11752, 11982, 12026, 12028, 12085, 12088, 12439, 12753, 12809, 13015, 13061, 13078, 13079, 13080)
                    OR test_d_media.media_id IN (12460)
                    OR test_d_media.media_id IN (12864)
                    OR test_d_media.media_id IN (11885, 11952, 12939)
                    OR test_d_media.media_id IN (11238)
                    OR test_d_media.media_id IN (10869, 10885, 10944)
                    OR test_d_media.media_id IN (10302)
                    OR test_d_media.media_id IN (13021)
                    OR test_d_media.media_id IN (11571)
                    OR test_d_media.media_id IN (10498)
                    OR test_d_media.media_id IN (12469)
                    OR test_d_media.media_id IN (12077)
                    OR test_d_media.media_id IN (11261)
                    OR test_d_media.media_id IN (10471)
                    OR test_d_media.media_id IN (11292)
                    OR test_d_media.media_id IN (10461)
                    OR test_d_media.media_id IN (10108, 10871, 11089, 11288, 11393, 11479, 11517, 11518, 11544, 11674, 11771, 11905, 11964, 12062, 12660, 12774, 12844, 12918, 12980, 13040, 13043, 13068)
                    OR test_d_media.media_id IN (13029)
                    OR test_d_media.media_id IN (12464, 12473, 12482, 12882, 12923)
                    OR test_d_media.media_id IN (10462)
                    OR test_d_media.media_id IN (10470)
                    OR test_d_media.media_id IN (12468, 12633, 12820)
                    OR test_d_media.media_id IN (10780, 11239, 11244)
                    OR test_d_media.media_id IN (11248)
                    OR test_d_media.media_id IN (11692)
                    OR test_d_media.media_id IN (12688, 12973)
                    OR test_d_media.media_id IN (12841)
                    OR test_d_media.media_id IN (12745)
                    OR test_d_media.media_id IN (12624)
                    OR test_d_media.media_id IN (10444)
                    OR test_d_media.media_id IN (12442)
                    OR test_d_media.media_id IN (12669, 12779)
                    OR test_d_media.media_id IN (12759)
                    OR test_d_media.media_id IN (11323)
                    OR test_d_media.media_id IN (12666)
                    OR test_d_media.media_id IN (12825)
                    OR test_d_media.media_id IN (12831)
                    OR test_d_media.media_id IN (10497)
                    OR test_d_media.media_id IN (11708)
                    OR test_d_media.media_id IN (11105, 11494, 12047, 12285, 12286, 12448)
                    OR test_d_media.media_id IN (12307)
                    OR test_d_media.media_id IN (11185)
                    OR test_d_media.media_id IN (10781)
                    OR test_d_media.media_id IN (10835)
                    OR test_d_media.media_id IN (12070)
                    OR test_d_media.media_id IN (12244)
                    OR test_d_media.media_id IN (10762)
                    OR test_d_media.media_id IN (10761))
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
    OR (test_d_media.media_type = 3
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (3)
                AND test_d_media.monitor_type = 0
                AND test_d_location.region_id IN (
                     '1',
                     '2',
                     '3',
                     '4',
                     '5',
                     '6',
                     '7',
                     '8'
                )
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
    OR (test_d_media.media_type = 1
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (1)
                AND test_d_media.monitor_type = 0
                AND test_d_location.region_id IN (
                     '1',
                     '2',
                     '3',
                     '4',
                     '5',
                     '6',
                     '7',
                     '8',
                     '9'
                )
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
    OR (test_d_media.media_type = 2
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (2)
                AND test_d_media.monitor_type = 0
                AND test_d_location.region_id IN (
                     '1',
                     '2',
                     '3',
                     '4',
                     '5',
                     '6',
                     '7',
                     '8'
                )
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
    OR (test_d_media.media_type = 8
        AND test_d_product.product_id IN (482564, 546502, 404267, 746028, 1078887, 1943037, 1931836, 1516681, 341303, 1202341, 751563, 1816436, 143205, 1198519, 1697443, 361595, 1754910, 128278, 774081, 1898014, 1970407, 523601, 1689143, 1985584, 1968860, 1918564, 29862, 1783860, 1777146, 1989779, 1984341, 947512, 826628, 1902410, 1756155, 1871956, 408649, 25229, 1116980, 1973437, 1943133, 1928001, 1984380, 1968741, 1611319, 1603969, 1442896, 1330761, 1569446, 1451115, 1565697, 1143377, 834419, 1971089, 1977524, 1972599, 132992, 121223, 500367, 774563, 11773, 296661, 1990151, 381597, 706881, 948031, 743249, 774315, 644628, 340275, 936702, 340909, 238319, 1881573, 24436, 978954, 1809954, 889742, 800006, 809017, 125601, 1938072, 1971137, 24701, 1931270, 1956404, 126020, 428930, 523344, 1756842, 1825172, 345481, 1688986, 1689128, 340479, 263223, 1705710)
        AND test_d_date.date_id >= 20220101
        AND test_d_date.date_id <= 20220131
        AND day_of_week IN (1, 2, 3, 4, 5, 6, 7)
        AND (1 = 2
            OR (test_d_media.media_type IN (8)
                AND test_d_media.monitor_type = 0
                AND (test_d_media.media_id IN (40077, 40078, 40079, 40080, 40081, 40082, 40083, 40084, 40085, 40086, 40087, 40088, 40089, 40091, 40092, 40093, 40094, 40095, 40096, 40097, 40099, 40100, 40101, 40102, 40103, 40104, 40105, 40106, 40107, 40108, 40109, 40110, 40111, 40112, 40113, 40114, 40115, 40116, 40117, 40119, 40120, 40121, 40122, 40123, 40124, 40126, 40127, 40128, 40129, 40130, 40131, 40132, 40133, 40134, 40135, 40136, 40137, 40138, 40139, 40140, 40141, 40142, 40143, 40144, 40145, 40272, 40276, 40278, 40303, 40310, 40311, 40434)
                    OR test_d_media.media_id IN (40011, 40020, 40039, 40158, 40165, 40309, 40317, 40365, 40432, 40433))
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))
            OR (test_d_media.media_type IN (8)
                AND test_d_media.monitor_type = 1
                AND (test_d_media.media_id IN (40173, 40174, 40175, 40176, 40177, 40178, 40179, 40180, 40181, 40182, 40183, 40184, 40185, 40186, 40187, 40188, 40189, 40190, 40191, 40192, 40193, 40194, 40195, 40196, 40197, 40198, 40199, 40200, 40201, 40202, 40203, 40204, 40205, 40206, 40207, 40208, 40209, 40210, 40211, 40212, 40213, 40214, 40215, 40216, 40217, 40218, 40219, 40220, 40221, 40222, 40223, 40224, 40225, 40226, 40227, 40228, 40229, 40230, 40231, 40232, 40233, 40234, 40235, 40236, 40237, 40238, 40239, 40240, 40241, 40242, 40243, 40244, 40245, 40246, 40247, 40248, 40249, 40250, 40251, 40252, 40253, 40254, 40255, 40256, 40257, 40258, 40259, 40260, 40261, 40262, 40263, 40264, 40265, 40266, 40267, 40268, 40269, 40270, 40271, 40273, 40274, 40275, 40279, 40280, 40281, 40282, 40283, 40284, 40285, 40286, 40287, 40288, 40289, 40290, 40291, 40292, 40293, 40294, 40295, 40296, 40297, 40298, 40299, 40300, 40301, 40302, 40304, 40305, 40306, 40307, 40308, 40312, 40313, 40314, 40315, 40316, 40319, 40320, 40321, 40322, 40323, 40324, 40325, 40326, 40327, 40328, 40329, 40330, 40331, 40332, 40333, 40334, 40335, 40336, 40337, 40338, 40339, 40340, 40341, 40342, 40343, 40344, 40345, 40346, 40347, 40348, 40349, 40350, 40351, 40352, 40353, 40354, 40355, 40356, 40357, 40358, 40359, 40360, 40361, 40362, 40363, 40366, 40367, 40368, 40369, 40370, 40371, 40372, 40373, 40374, 40375, 40376, 40377, 40378, 40379, 40380, 40381, 40382, 40383, 40384, 40385, 40386, 40387, 40388, 40389, 40390, 40391, 40392, 40393, 40394, 40395, 40396, 40397, 40398, 40399, 40400, 40401, 40402, 40403, 40404, 40405, 40406, 40407, 40408, 40409, 40410, 40411, 40412, 40413, 40414, 40415, 40416, 40417, 40418, 40419, 40420, 40421, 40422, 40423, 40424, 40425, 40426, 40427, 40428, 40429, 40430, 40431, 40435, 40436, 40437, 40438, 40439, 40440, 40441, 40442, 40443, 40444, 40445, 40446, 40447, 40448, 40449, 40450, 40451, 40452, 40453, 40454, 40455, 40456, 40457, 40458, 40493, 40494, 40495, 40496, 40497, 40498, 40499, 40500, 40501, 40502, 40503, 40504, 40505, 40506, 40507, 40508, 40509, 40510, 40511, 40512, 40513, 40514, 40515, 40516, 40517, 40518, 40519, 40520, 40521, 40522, 40523, 40524, 40525, 40526, 40529, 40530, 40531, 40532, 40533, 40534, 40535, 40536, 40537, 40538, 40539, 40540, 40541, 40542, 40543, 40544, 40545, 40546, 40547, 40548, 40549, 40550, 40560, 40561, 40562, 40563, 40564, 40565, 40566, 40567, 40568, 40569, 40570, 40571)
                    OR test_d_media.media_id IN (40002, 40006, 40007, 40015, 40016, 40018, 40023, 40028, 40030, 40034, 40041, 40045, 40051, 40054, 40062, 40063, 40066, 40071, 40072, 40076, 40146, 40147, 40148, 40149, 40150, 40151, 40152, 40153, 40154, 40155, 40552, 40553, 40554, 40555, 40557, 40558)
                    OR test_d_media.media_id IN (40001, 40003, 40005, 40010, 40012, 40013, 40017, 40019, 40021, 40025, 40026, 40027, 40029, 40032, 40038, 40042, 40043, 40044, 40046, 40047, 40048, 40056, 40058, 40060, 40061, 40064, 40068, 40070, 40073, 40074, 40551, 40556, 40559))
                AND (1 = 2
                    OR test_d_prod_cate.big_cate_id IN (
                         'T',
                         'Q',
                         'K',
                         'B',
                         'L',
                         'H',
                         'E',
                         'N',
                         'S',
                         'G',
                         'J',
                         'C',
                         'P',
                         'F',
                         'Z',
                         'D',
                         'M',
                         'R',
                         'A',
                         'U',
                         'V',
                         'Y'
                    )
                    OR test_d_prod_cate.mid_cate_id IN (
                         'Ty',
                         'Tz',
                         'Tx',
                         'T2',
                         'T3',
                         'Qz',
                         'Q7',
                         'Q2',
                         'Q4',
                         'Q1',
                         'Q5',
                         'Q3',
                         'Qx',
                         'Q8',
                         'Q6',
                         'Qy',
                         'Ky',
                         'K1',
                         'Kz',
                         'K4',
                         'Kx',
                         'K7',
                         'K6',
                         'K2',
                         'K9',
                         'K5',
                         'K3',
                         'Bz',
                         'B4',
                         'Bx',
                         'BA',
                         'B6',
                         'B2',
                         'BE',
                         'BB',
                         'B5',
                         'B3',
                         'B8',
                         'By',
                         'BD',
                         'BC',
                         'B9',
                         'B1',
                         'L6',
                         'L5',
                         'L9',
                         'L7',
                         'L8',
                         'Ly',
                         'Lz',
                         'L1',
                         'Lx',
                         'L3',
                         'L2',
                         'L4',
                         'H7',
                         'H4',
                         'Hy',
                         'H1',
                         'H6',
                         'H2',
                         'HA',
                         'H3',
                         'H5',
                         'HB',
                         'Hx',
                         'H8',
                         'Hz',
                         'H9',
                         'E2',
                         'E7',
                         'EA',
                         'E5',
                         'E9',
                         'E4',
                         'EC',
                         'Ey',
                         'Ez',
                         'Ex',
                         'E1',
                         'E6',
                         'E8',
                         'Ny',
                         'NC',
                         'N3',
                         'N8',
                         'N9',
                         'ND',
                         'NA',
                         'N7',
                         'Nz',
                         'Nx',
                         'S1',
                         'Sx',
                         'Sz',
                         'S4',
                         'Sy',
                         'GE',
                         'GB',
                         'G5',
                         'GD',
                         'GC',
                         'GA',
                         'Gz',
                         'Gx',
                         'G1',
                         'G6',
                         'G3',
                         'G2',
                         'G9',
                         'G7',
                         'Gy',
                         'G8',
                         'G4',
                         'J2',
                         'J6',
                         'Jx',
                         'JC',
                         'J7',
                         'J8',
                         'JA',
                         'JG',
                         'Jz',
                         'JE',
                         'J4',
                         'JB',
                         'J1',
                         'J3',
                         'J9',
                         'Jy',
                         'JH',
                         'J5',
                         'JF',
                         'C4',
                         'C3',
                         'C1',
                         'C2',
                         'Cx',
                         'Cz',
                         'Cy',
                         'P2',
                         'P8',
                         'P7',
                         'PA',
                         'P6',
                         'P5',
                         'PB',
                         'PZ',
                         'P1',
                         'P9',
                         'P4',
                         'F3',
                         'Fy',
                         'F1',
                         'Fz',
                         'F4',
                         'F2',
                         'Fx',
                         'F5',
                         'Zy',
                         'Z5',
                         'Z1',
                         'Z4',
                         'D3',
                         'D5',
                         'Dx',
                         'Dy',
                         'Dz',
                         'D2',
                         'D1',
                         'D4',
                         'My',
                         'M4',
                         'M1',
                         'M6',
                         'Mx',
                         'Mz',
                         'M5',
                         'R3',
                         'R1',
                         'R2',
                         'Rz',
                         'Rx',
                         'Ry',
                         'A2',
                         'A1',
                         'AY',
                         'AA',
                         'AD',
                         'AG',
                         'Ay',
                         'AC',
                         'AP',
                         'AN',
                         'Az',
                         'AE',
                         'Ax',
                         'AB',
                         'AF',
                         'A4',
                         'A7',
                         'A6',
                         'A3',
                         'A8',
                         'AJ',
                         'AK',
                         'A5',
                         'AH',
                         'Ux',
                         'U1',
                         'Uz',
                         'U5',
                         'U3',
                         'U6',
                         'U4',
                         'Uy',
                         'U2',
                         'V1',
                         'Vy',
                         'Yz',
                         'Y3',
                         'Y1',
                         'Y2'
                    )
                    OR test_d_prod_cate.small_cate_id IN (
                         'T22',
                         'T24',
                         'T23',
                         'T21',
                         'Q7Z',
                         'Q71',
                         'Q73',
                         'Q74',
                         'Q72',
                         'Q7Y',
                         'Q2Z',
                         'Q21',
                         'Q22',
                         'Q4z',
                         'Q43',
                         'Q4Z',
                         'Q44',
                         'Q42',
                         'Q41',
                         'Q45',
                         'Q1y',
                         'Q11',
                         'Q33',
                         'Q32',
                         'Q31',
                         'Q3z',
                         'Q62',
                         'Q6z',
                         'Q61',
                         'Q6Z',
                         'K16',
                         'K17',
                         'K1Z',
                         'K11',
                         'K15',
                         'K1Y',
                         'K14',
                         'K71',
                         'K73',
                         'B41',
                         'B42',
                         'B43',
                         'B44',
                         'B4Z',
                         'B45',
                         'B46',
                         'B47',
                         'BA6',
                         'BA7',
                         'BA3',
                         'BA8',
                         'BAZ',
                         'BA2',
                         'BA9',
                         'BA4',
                         'B63',
                         'B64',
                         'B6Z',
                         'B61',
                         'B62',
                         'B23',
                         'B22',
                         'B21',
                         'B25',
                         'B24',
                         'B26',
                         'B33',
                         'B31',
                         'B32',
                         'H42',
                         'H4Z',
                         'H44',
                         'H4A',
                         'H45',
                         'H4B',
                         'H43',
                         'H4E',
                         'H41',
                         'H4C',
                         'H48',
                         'H4D',
                         'H49',
                         'H15',
                         'H14',
                         'H12',
                         'H13',
                         'H11',
                         'H61',
                         'H62',
                         'H65',
                         'H64',
                         'H25',
                         'H23',
                         'H21',
                         'H24',
                         'H26',
                         'H22',
                         'HA3',
                         'HA1',
                         'HA5',
                         'HA4',
                         'HA2',
                         'HAZ',
                         'H33',
                         'H35',
                         'H34',
                         'H31',
                         'H32',
                         'H52',
                         'H54',
                         'H53',
                         'H51',
                         'HB2',
                         'HB9',
                         'HB3',
                         'HB4',
                         'HBB',
                         'HB7',
                         'HB5',
                         'HBA',
                         'HB1',
                         'HB8',
                         'HB6',
                         'E24',
                         'E25',
                         'E2Z',
                         'E27',
                         'E21',
                         'E23',
                         'E22',
                         'E71',
                         'E72',
                         'E73',
                         'E51',
                         'E52',
                         'E42',
                         'E43',
                         'E4Z',
                         'E41',
                         'E11',
                         'E12',
                         'N32',
                         'N31',
                         'N33',
                         'N9Y',
                         'N91',
                         'N9Z',
                         'N92',
                         'ND2',
                         'ND1',
                         'ND5',
                         'ND6',
                         'ND3',
                         'ND4',
                         'S11',
                         'S16',
                         'S1x',
                         'S14',
                         'S13',
                         'S12',
                         'S15',
                         'S1y',
                         'GE9',
                         'GE7',
                         'GE8',
                         'GEA',
                         'GE3',
                         'GE1',
                         'GE2',
                         'GE5',
                         'GE6',
                         'GE4',
                         'GEB',
                         'GB2',
                         'GB0',
                         'GB1',
                         'GB9',
                         'G5Z',
                         'G51',
                         'G52',
                         'GD3',
                         'GDZ',
                         'GD1',
                         'GC1',
                         'GC3',
                         'GCZ',
                         'G16',
                         'G12',
                         'G14',
                         'G11',
                         'G15',
                         'G13',
                         'G64',
                         'G61',
                         'G63',
                         'G62',
                         'G32',
                         'G31',
                         'G3Z',
                         'G22',
                         'G24',
                         'G21',
                         'G2x',
                         'J63',
                         'J62',
                         'J6Y',
                         'J65',
                         'J6Z',
                         'JC1',
                         'JC2',
                         'JC3',
                         'JAZ',
                         'JA1',
                         'C41',
                         'C42',
                         'C4Z',
                         'C35',
                         'C3Z',
                         'C31',
                         'C32',
                         'C33',
                         'C34',
                         'C14',
                         'C12',
                         'C11',
                         'C15',
                         'C17',
                         'C13',
                         'C26',
                         'C24',
                         'C28',
                         'C27',
                         'C22',
                         'C21',
                         'P28',
                         'P2B',
                         'P2A',
                         'P21',
                         'P27',
                         'P29',
                         'P26',
                         'P2Z',
                         'P25',
                         'P24',
                         'P2D',
                         'P22',
                         'P2C',
                         'F32',
                         'F31',
                         'F3Z',
                         'Zy1',
                         'Z12',
                         'Z15',
                         'Z11',
                         'Z14',
                         'Z13',
                         'D33',
                         'D32',
                         'D31',
                         'D22',
                         'D21',
                         'M17',
                         'M12',
                         'M13',
                         'M14',
                         'M11',
                         'M15',
                         'M16',
                         'M18',
                         'M63',
                         'M61',
                         'M62',
                         'R32',
                         'R31',
                         'R33',
                         'R13',
                         'R1Z',
                         'R16',
                         'R1B',
                         'R1C',
                         'R1A',
                         'R19',
                         'R11',
                         'R1H',
                         'R12',
                         'R15',
                         'R14',
                         'R1E',
                         'R1G',
                         'R18',
                         'R1J',
                         'R1F',
                         'R22',
                         'R26',
                         'R23',
                         'R25',
                         'R21',
                         'R24',
                         'AA2',
                         'AA3',
                         'AA1'
                    ))
                AND (1 = 2
                    OR (test_d_date.date_id >= 20150101
                        AND test_d_date.date_id <= 20230228)))))
GROUP BY test_d_factory.F_NAME, test_d_product.P_NAME, descrip_c) "db_3" WHERE ("db_3"."F_NAME" IN ('测试F')) AND ("db_3"."P_NAME" IN ('测试P')) limit 1000
