/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.handler.dataimport;

import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.InputStream;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.io.IOUtils;
import org.apache.lucene.analysis.util.ResourceLoader;
import org.apache.solr.common.util.XMLErrorLogger;
import org.apache.solr.core.SolrCore;
import org.apache.solr.core.SolrResourceLoader;
import org.apache.solr.handler.dataimport.Context;
import org.apache.solr.handler.dataimport.DataImportHandlerException;
import org.apache.solr.handler.dataimport.DataSource;
import org.apache.solr.handler.dataimport.EntityProcessorBase;
import org.apache.solr.handler.dataimport.VariableResolver;
import org.apache.solr.handler.dataimport.XPathRecordReader;
import org.apache.solr.util.SystemIdResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XPathEntityProcessor
extends EntityProcessorBase {
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final XMLErrorLogger xmllog = new XMLErrorLogger(log);
    private static final Map<String, Object> END_MARKER = new HashMap<String, Object>();
    protected List<String> placeHolderVariables;
    protected List<String> commonFields;
    private String pk;
    private XPathRecordReader xpathReader;
    protected DataSource<Reader> dataSource;
    protected Transformer xslTransformer;
    protected boolean useSolrAddXml = false;
    protected boolean streamRows = false;
    protected int blockingQueueTimeOut = 10;
    protected TimeUnit blockingQueueTimeOutUnits = TimeUnit.SECONDS;
    protected int blockingQueueSize = 1000;
    protected Thread publisherThread;
    protected boolean reinitXPathReader = true;
    public static final String URL = "url";
    public static final String HAS_MORE = "$hasMore";
    public static final String NEXT_URL = "$nextUrl";
    public static final String XPATH_FIELD_NAME = "$forEach";
    public static final String FOR_EACH = "forEach";
    public static final String XPATH = "xpath";
    public static final String COMMON_FIELD = "commonField";
    public static final String USE_SOLR_ADD_SCHEMA = "useSolrAddSchema";
    public static final String XSL = "xsl";
    public static final String STREAM = "stream";

    @Override
    public void init(Context context) {
        super.init(context);
        if (this.reinitXPathReader) {
            this.initXpathReader(context.getVariableResolver());
        }
        this.pk = context.getEntityAttribute("pk");
        this.dataSource = context.getDataSource();
        this.rowIterator = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private void initXpathReader(VariableResolver resolver) {
        String xslt;
        this.reinitXPathReader = false;
        this.useSolrAddXml = Boolean.parseBoolean(this.context.getEntityAttribute(USE_SOLR_ADD_SCHEMA));
        this.streamRows = Boolean.parseBoolean(this.context.getEntityAttribute(STREAM));
        if (this.context.getResolvedEntityAttribute("batchSize") != null) {
            this.blockingQueueSize = Integer.parseInt(this.context.getEntityAttribute("batchSize"));
        }
        if (this.context.getResolvedEntityAttribute("readTimeOut") != null) {
            this.blockingQueueTimeOut = Integer.parseInt(this.context.getEntityAttribute("readTimeOut"));
        }
        if ((xslt = this.context.getEntityAttribute(XSL)) != null) {
            xslt = this.context.replaceTokens(xslt);
            try {
                void var5_13;
                TransformerFactory transFact = TransformerFactory.newInstance();
                SolrCore core = this.context.getSolrCore();
                if (core != null) {
                    SolrResourceLoader solrResourceLoader = core.getResourceLoader();
                    transFact.setURIResolver(new SystemIdResolver((ResourceLoader)solrResourceLoader).asURIResolver());
                    StreamSource streamSource = new StreamSource(solrResourceLoader.openResource(xslt), SystemIdResolver.createSystemIdFromResourceName((String)xslt));
                } else {
                    StreamSource streamSource = new StreamSource(xslt);
                }
                transFact.setErrorListener((ErrorListener)xmllog);
                try {
                    this.xslTransformer = transFact.newTransformer((Source)var5_13);
                }
                finally {
                    IOUtils.closeQuietly((InputStream)var5_13.getInputStream());
                }
                if (log.isInfoEnabled()) {
                    log.info("Using xslTransformer: {}", (Object)this.xslTransformer.getClass().getName());
                }
            }
            catch (Exception e) {
                throw new DataImportHandlerException(500, "Error initializing XSL ", e);
            }
        }
        if (this.useSolrAddXml) {
            this.xpathReader = new XPathRecordReader("/add/doc");
            this.xpathReader.addField("name", "/add/doc/field/@name", true);
            this.xpathReader.addField("value", "/add/doc/field", true);
        } else {
            String forEachXpath = this.context.getResolvedEntityAttribute(FOR_EACH);
            if (forEachXpath == null) {
                throw new DataImportHandlerException(500, "Entity : " + this.context.getEntityAttribute("name") + " must have a 'forEach' attribute");
            }
            if (forEachXpath.equals(this.context.getEntityAttribute(FOR_EACH))) {
                this.reinitXPathReader = true;
            }
            try {
                this.xpathReader = new XPathRecordReader(forEachXpath);
                for (Map map : this.context.getAllEntityFields()) {
                    if (map.get(XPATH) == null) continue;
                    int n = 0;
                    if ("true".equals(map.get("flatten"))) {
                        n = 1;
                    }
                    String xpath = (String)map.get(XPATH);
                    if (!(xpath = this.context.replaceTokens(xpath)).equals(map.get(XPATH)) && !this.context.isRootEntity()) {
                        this.reinitXPathReader = true;
                    }
                    this.xpathReader.addField((String)map.get("column"), xpath, Boolean.parseBoolean((String)map.get("multiValued")), n);
                }
            }
            catch (RuntimeException e) {
                throw new DataImportHandlerException(500, "Exception while reading xpaths for fields", e);
            }
        }
        String url = this.context.getEntityAttribute(URL);
        List<String> l = url == null ? Collections.emptyList() : resolver.getVariables(url);
        for (String string : l) {
            if (!string.startsWith(this.entityName + ".")) continue;
            if (this.placeHolderVariables == null) {
                this.placeHolderVariables = new ArrayList<String>();
            }
            this.placeHolderVariables.add(string.substring(this.entityName.length() + 1));
        }
        for (Map<String, String> map : this.context.getAllEntityFields()) {
            if (map.get(COMMON_FIELD) == null || !"true".equals(map.get(COMMON_FIELD))) continue;
            if (this.commonFields == null) {
                this.commonFields = new ArrayList<String>();
            }
            this.commonFields.add(map.get("column"));
        }
    }

    @Override
    public Map<String, Object> nextRow() {
        Map<String, Object> result;
        if (!this.context.isRootEntity()) {
            return this.fetchNextRow();
        }
        do {
            if ((result = this.fetchNextRow()) != null) continue;
            return null;
        } while (this.pk != null && result.get(this.pk) == null);
        return result;
    }

    @Override
    public void postTransform(Map<String, Object> r) {
        this.readUsefulVars(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Object> fetchNextRow() {
        Map<String, Object> r;
        block9: {
            r = null;
            if (this.rowIterator == null) {
                this.initQuery(this.context.replaceTokens(this.context.getEntityAttribute(URL)));
            }
            if ((r = this.getNext()) == null) {
                Object hasMore = this.context.getSessionAttribute(HAS_MORE, "entity");
                try {
                    if ("true".equals(hasMore) || Boolean.TRUE.equals(hasMore)) {
                        String url = (String)this.context.getSessionAttribute(NEXT_URL, "entity");
                        if (url == null) {
                            url = this.context.getEntityAttribute(URL);
                        }
                        this.addNamespace();
                        this.initQuery(this.context.replaceTokens(url));
                        r = this.getNext();
                        if (r == null) {
                            Map<String, Object> map = null;
                            return map;
                        }
                        break block9;
                    }
                    Map<String, Object> map = null;
                    return map;
                }
                finally {
                    this.context.setSessionAttribute(HAS_MORE, null, "entity");
                    this.context.setSessionAttribute(NEXT_URL, null, "entity");
                }
            }
        }
        this.addCommonFields(r);
        return r;
    }

    private void addNamespace() {
        HashMap<String, Object> namespace = new HashMap<String, Object>();
        HashSet<String> allNames = new HashSet<String>();
        if (this.commonFields != null) {
            allNames.addAll(this.commonFields);
        }
        if (this.placeHolderVariables != null) {
            allNames.addAll(this.placeHolderVariables);
        }
        if (allNames.isEmpty()) {
            return;
        }
        for (String name : allNames) {
            Object val = this.context.getSessionAttribute(name, "entity");
            if (val == null) continue;
            namespace.put(name, val);
        }
        this.context.getVariableResolver().addNamespace(this.entityName, namespace);
    }

    private void addCommonFields(Map<String, Object> r) {
        if (this.commonFields != null) {
            for (String commonField : this.commonFields) {
                Object val;
                if (r.get(commonField) != null || (val = this.context.getSessionAttribute(commonField, "entity")) == null) continue;
                r.put(commonField, val);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initQuery(String s) {
        ArrayList rows;
        Reader data;
        block24: {
            data = null;
            try {
                rows = new ArrayList();
                try {
                    data = this.dataSource.getData(s);
                }
                catch (Exception e) {
                    if ("abort".equals(this.onError)) {
                        DataImportHandlerException.wrapAndThrow(500, e);
                    }
                    if ("skip".equals(this.onError)) {
                        if (log.isDebugEnabled()) {
                            log.debug("Skipping url : {}", (Object)s, (Object)e);
                        }
                        DataImportHandlerException.wrapAndThrow(300, e);
                    }
                    log.warn("Failed for url : {}", (Object)s, (Object)e);
                    this.rowIterator = Collections.EMPTY_LIST.iterator();
                    if (!this.streamRows) {
                        this.closeIt(data);
                    }
                    return;
                }
            }
            catch (Throwable throwable) {
                if (!this.streamRows) {
                    this.closeIt(data);
                }
                throw throwable;
            }
            if (this.xslTransformer == null) break block24;
            try {
                SimpleCharArrayReader caw = new SimpleCharArrayReader();
                this.xslTransformer.transform(new StreamSource(data), new StreamResult(caw));
                data = caw.getReader();
            }
            catch (TransformerException e) {
                if ("abort".equals(this.onError)) {
                    DataImportHandlerException.wrapAndThrow(500, e, "Exception in applying XSL Transformation");
                }
                if ("skip".equals(this.onError)) {
                    DataImportHandlerException.wrapAndThrow(300, e);
                }
                log.warn("Failed for url : {}", (Object)s, (Object)e);
                this.rowIterator = Collections.EMPTY_LIST.iterator();
                if (!this.streamRows) {
                    this.closeIt(data);
                }
                return;
            }
        }
        if (this.streamRows) {
            this.rowIterator = this.getRowIterator(data, s);
        } else {
            block25: {
                try {
                    this.xpathReader.streamRecords(data, (record, xpath) -> rows.add(this.readRow(record, xpath)));
                }
                catch (Exception e) {
                    String msg = "Parsing failed for xml, url:" + s + " rows processed:" + rows.size();
                    if (rows.size() > 0) {
                        msg = msg + " last row: " + rows.get(rows.size() - 1);
                    }
                    if ("abort".equals(this.onError)) {
                        DataImportHandlerException.wrapAndThrow(500, e, msg);
                    }
                    if ("skip".equals(this.onError)) {
                        log.warn(msg, (Throwable)e);
                        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
                        map.put("$skipDoc", Boolean.TRUE);
                        rows.add(map);
                    }
                    if (!"continue".equals(this.onError)) break block25;
                    log.warn(msg, (Throwable)e);
                }
            }
            this.rowIterator = rows.iterator();
        }
        if (!this.streamRows) {
            this.closeIt(data);
        }
    }

    private void closeIt(Reader data) {
        try {
            data.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected Map<String, Object> readRow(Map<String, Object> record, String xpath) {
        if (this.useSolrAddXml) {
            List names = (List)record.get("name");
            List values = (List)record.get("value");
            HashMap<String, Object> row = new HashMap<String, Object>();
            for (int i = 0; i < names.size() && i < values.size(); ++i) {
                if (row.containsKey(names.get(i))) {
                    ArrayList<Object> list;
                    Object existing = row.get(names.get(i));
                    if (existing instanceof List) {
                        list = (ArrayList<Object>)existing;
                        list.add(values.get(i));
                        continue;
                    }
                    list = new ArrayList<Object>();
                    list.add(existing);
                    list.add(values.get(i));
                    row.put((String)names.get(i), list);
                    continue;
                }
                row.put((String)names.get(i), values.get(i));
            }
            return row;
        }
        record.put(XPATH_FIELD_NAME, xpath);
        return record;
    }

    private Map<String, Object> readUsefulVars(Map<String, Object> r) {
        Object val = r.get(HAS_MORE);
        if (val != null) {
            this.context.setSessionAttribute(HAS_MORE, val, "entity");
        }
        if ((val = r.get(NEXT_URL)) != null) {
            this.context.setSessionAttribute(NEXT_URL, val, "entity");
        }
        if (this.placeHolderVariables != null) {
            for (String s : this.placeHolderVariables) {
                val = r.get(s);
                this.context.setSessionAttribute(s, val, "entity");
            }
        }
        if (this.commonFields != null) {
            for (String s : this.commonFields) {
                Object commonVal = r.get(s);
                if (commonVal == null) continue;
                this.context.setSessionAttribute(s, commonVal, "entity");
            }
        }
        return r;
    }

    private Iterator<Map<String, Object>> getRowIterator(final Reader data, final String s) {
        final AtomicReference exp = new AtomicReference();
        final ArrayBlockingQueue blockingQueue = new ArrayBlockingQueue(this.blockingQueueSize);
        final AtomicBoolean isEnd = new AtomicBoolean(false);
        final AtomicBoolean throwExp = new AtomicBoolean(true);
        this.publisherThread = new Thread(){

            @Override
            public void run() {
                try {
                    XPathEntityProcessor.this.xpathReader.streamRecords(data, (record, xpath) -> {
                        Map<String, Object> row;
                        if (isEnd.get()) {
                            throwExp.set(false);
                            throw new RuntimeException("BREAK");
                        }
                        try {
                            row = XPathEntityProcessor.this.readRow(record, xpath);
                        }
                        catch (Exception e) {
                            isEnd.set(true);
                            return;
                        }
                        this.offer(row);
                    });
                }
                catch (Exception e) {
                    if (throwExp.get()) {
                        exp.set(e);
                    }
                }
                finally {
                    XPathEntityProcessor.this.closeIt(data);
                    if (!isEnd.get()) {
                        this.offer(END_MARKER);
                    }
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void offer(Map<String, Object> row) {
                try {
                    while (!blockingQueue.offer(row, XPathEntityProcessor.this.blockingQueueTimeOut, XPathEntityProcessor.this.blockingQueueTimeOutUnits)) {
                        if (isEnd.get()) {
                            return;
                        }
                        log.debug("Timeout elapsed writing records.  Perhaps buffer size should be increased.");
                    }
                }
                catch (InterruptedException e) {
                    return;
                }
                finally {
                    1 var2_2 = this;
                    synchronized (var2_2) {
                        this.notifyAll();
                    }
                }
            }
        };
        this.publisherThread.start();
        return new Iterator<Map<String, Object>>(){
            private Map<String, Object> lastRow;
            int count = 0;

            @Override
            public boolean hasNext() {
                return !isEnd.get();
            }

            @Override
            public Map<String, Object> next() {
                Map row;
                do {
                    try {
                        row = (Map)blockingQueue.poll(XPathEntityProcessor.this.blockingQueueTimeOut, XPathEntityProcessor.this.blockingQueueTimeOutUnits);
                        if (row != null) continue;
                        log.debug("Timeout elapsed reading records.");
                    }
                    catch (InterruptedException e) {
                        log.debug("Caught InterruptedException while waiting for row.  Aborting.");
                        isEnd.set(true);
                        return null;
                    }
                } while (row == null);
                if (row == END_MARKER) {
                    isEnd.set(true);
                    if (exp.get() != null) {
                        String msg = "Parsing failed for xml, url:" + s + " rows processed in this xml:" + this.count;
                        if (this.lastRow != null) {
                            msg = msg + " last row in this xml:" + this.lastRow;
                        }
                        if ("abort".equals(XPathEntityProcessor.this.onError)) {
                            DataImportHandlerException.wrapAndThrow(500, (Exception)exp.get(), msg);
                        } else if ("skip".equals(XPathEntityProcessor.this.onError)) {
                            DataImportHandlerException.wrapAndThrow(300, (Exception)exp.get());
                        } else {
                            log.warn(msg, (Throwable)exp.get());
                        }
                    }
                    return null;
                }
                ++this.count;
                this.lastRow = row;
                return this.lastRow;
            }

            @Override
            public void remove() {
            }
        };
    }

    private static class SimpleCharArrayReader
    extends CharArrayWriter {
        private SimpleCharArrayReader() {
        }

        public Reader getReader() {
            return new CharArrayReader(this.buf, 0, this.count);
        }
    }
}

