/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.compliance.reporting;

import com.sun.mirror.apt.AnnotationProcessor;
import com.sun.mirror.apt.AnnotationProcessorEnvironment;
import com.sun.mirror.apt.AnnotationProcessorFactory;
import com.sun.mirror.apt.Filer;
import com.sun.mirror.declaration.AnnotationTypeDeclaration;
import com.sun.mirror.declaration.ClassDeclaration;
import com.sun.mirror.declaration.Declaration;
import com.sun.mirror.declaration.FieldDeclaration;
import com.sun.mirror.declaration.MemberDeclaration;
import com.sun.mirror.declaration.MethodDeclaration;
import com.sun.mirror.declaration.TypeDeclaration;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.vysper.compliance.SpecCompliance;
import org.apache.vysper.compliance.SpecCompliant;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentSpecCompliantAnnotationFactory
implements AnnotationProcessorFactory {
    private static final Collection<String> supportedAnnotations = Collections.unmodifiableCollection(Arrays.asList("org.apache.vysper.compliance.*"));
    private static final Collection<String> supportedOptions = Collections.emptySet();

    public Collection<String> supportedAnnotationTypes() {
        return supportedAnnotations;
    }

    public Collection<String> supportedOptions() {
        return supportedOptions;
    }

    public AnnotationProcessor getProcessorFor(Set<AnnotationTypeDeclaration> atds, AnnotationProcessorEnvironment env) {
        return new SpecCompliantClassAP(env);
    }

    static class SpecDoc {
        Declaration declaration;
        SpecCompliant specCompliant;

        SpecDoc(Declaration declaration, SpecCompliant specCompliant) {
            this.declaration = declaration;
            this.specCompliant = specCompliant;
        }

        public String getClassName() {
            if (this.declaration instanceof FieldDeclaration || this.declaration instanceof MethodDeclaration) {
                MemberDeclaration memberDeclaration = (MemberDeclaration)this.declaration;
                return memberDeclaration.getDeclaringType().getQualifiedName();
            }
            return this.declaration.getSimpleName();
        }

        public String getFQClassName() {
            if (this.declaration instanceof FieldDeclaration || this.declaration instanceof MethodDeclaration) {
                MemberDeclaration memberDeclaration = (MemberDeclaration)this.declaration;
                return memberDeclaration.getDeclaringType().getQualifiedName();
            }
            if (this.declaration instanceof ClassDeclaration) {
                ClassDeclaration classDeclaration = (ClassDeclaration)this.declaration;
                return classDeclaration.getPackage() + "." + classDeclaration.getSimpleName();
            }
            return this.declaration.getSimpleName();
        }

        public String getPackage() {
            if (this.declaration instanceof TypeDeclaration) {
                TypeDeclaration typeDeclaration = (TypeDeclaration)this.declaration;
                return typeDeclaration.getPackage().getQualifiedName();
            }
            if (this.declaration instanceof FieldDeclaration || this.declaration instanceof MethodDeclaration) {
                MemberDeclaration memberDeclaration = (MemberDeclaration)this.declaration;
                return memberDeclaration.getDeclaringType().getPackage().getQualifiedName();
            }
            return null;
        }

        public String getMember() {
            if (this.declaration instanceof FieldDeclaration || this.declaration instanceof MethodDeclaration) {
                MemberDeclaration memberDeclaration = (MemberDeclaration)this.declaration;
                return this.declaration.getSimpleName();
            }
            return null;
        }

        public String getMemberAnchor() {
            if (this.declaration instanceof FieldDeclaration || this.declaration instanceof MethodDeclaration) {
                MemberDeclaration memberDeclaration = (MemberDeclaration)this.declaration;
                return this.declaration.toString();
            }
            return null;
        }

        public String getKey() {
            return this.getSpecDoc() + " " + this.getSpecSection() + " " + this.getClassName() + " " + this.getMember() + " " + (Object)((Object)this.getCoverageLevel()) + " " + (Object)((Object)this.getComplianceStatus());
        }

        public String getSpecSection() {
            return this.specCompliant.section();
        }

        public String getSpecDoc() {
            String specRaw = this.specCompliant.spec();
            if (specRaw == null) {
                return null;
            }
            return specRaw.toLowerCase();
        }

        public String getSpecDocURL() {
            String spec = this.getSpecDoc();
            if (spec == null) {
                return null;
            }
            if (spec.startsWith("xep")) {
                return "http://xmpp.org/extensions/" + spec + ".html";
            }
            if (spec.startsWith("rfc")) {
                if (!spec.contains("bis")) {
                    return "http://tools.ietf.org/html/" + spec;
                }
                return "http://tools.ietf.org/html/draft-saintandre-" + spec;
            }
            return null;
        }

        public SpecCompliant.ComplianceCoverage getCoverageLevel() {
            return this.specCompliant.coverage();
        }

        public SpecCompliant.ComplianceStatus getComplianceStatus() {
            return this.specCompliant.status();
        }

        public String getComment() {
            return this.specCompliant.comment();
        }
    }

    private static class SpecCompliantClassAP
    implements AnnotationProcessor {
        protected final AnnotationProcessorEnvironment env;
        protected AnnotationTypeDeclaration specCompliantAnnotation;
        protected AnnotationTypeDeclaration specCompliantCollectionAnnotation;
        protected Map<String, SpecDoc> map = new TreeMap<String, SpecDoc>();
        protected PrintWriter fileWriter;

        SpecCompliantClassAP(AnnotationProcessorEnvironment env) {
            this.env = env;
            this.specCompliantAnnotation = (AnnotationTypeDeclaration)env.getTypeDeclaration("org.apache.vysper.compliance.SpecCompliant");
            this.specCompliantCollectionAnnotation = (AnnotationTypeDeclaration)env.getTypeDeclaration("org.apache.vysper.compliance.SpecCompliance");
            try {
                this.fileWriter = env.getFiler().createTextFile(Filer.Location.SOURCE_TREE, "", new File("spec_compliance.html"), null);
            }
            catch (IOException e) {
                throw new RuntimeException("could not write to output file", e);
            }
        }

        public void process() {
            Collection declarations = this.env.getDeclarationsAnnotatedWith(this.specCompliantAnnotation);
            System.out.println("number of solitairy @SpecCompliant: " + declarations.size());
            for (Declaration declaration : declarations) {
                SpecDoc doc = new SpecDoc(declaration, (SpecCompliant)declaration.getAnnotation(SpecCompliant.class));
                this.map.put(doc.getKey(), doc);
            }
            Collection moreDeclarations = this.env.getDeclarationsAnnotatedWith(this.specCompliantCollectionAnnotation);
            System.out.println("number of @SpecCompliance: " + moreDeclarations.size());
            for (Declaration declaration : moreDeclarations) {
                SpecCompliant[] specCompliants;
                SpecCompliance compliance = (SpecCompliance)declaration.getAnnotation(SpecCompliance.class);
                for (SpecCompliant specCompliant : specCompliants = compliance.compliant()) {
                    if (specCompliant == null) continue;
                    SpecDoc doc = new SpecDoc(declaration, specCompliant);
                    this.map.put(doc.getKey(), doc);
                }
            }
            this.fileWriter.println("<html><head><link rel='stylesheet' type='text/css' href='http://yui.yahooapis.com/2.7.0/build/reset-fonts-grids/reset-fonts-grids.css'>\n<link rel='stylesheet' type='text/css' href='http://yui.yahooapis.com/2.7.0/build/base/base-min.css'>\n</head><body><table><thead><th>spec</th><th>section</th><th>package</th><th>class</th><th>field/method/etc.</th><th>coverage</th><th>implementation</th><th>comment</th></thead>");
            for (String key : this.map.keySet()) {
                String specDoc;
                this.fileWriter.print("<tr>");
                System.out.println(key);
                SpecDoc doc = this.map.get(key);
                this.fileWriter.print("<td>");
                String specURL = doc.getSpecDocURL();
                if (specURL != null) {
                    this.fileWriter.print("<a href='" + specURL + "'>");
                }
                if ((specDoc = doc.getSpecDoc()) != null) {
                    this.fileWriter.print(specDoc);
                }
                if (specURL != null) {
                    this.fileWriter.print("</a>");
                }
                this.fileWriter.print("</td>");
                this.fileWriter.print("<td>");
                String specSection = doc.getSpecSection();
                if (specSection != null && specSection.length() > 0) {
                    String anchorLink;
                    if (specSection.endsWith(".")) {
                        specSection = specSection.substring(0, specSection.length() - 1);
                    }
                    String string = anchorLink = Character.isDigit(specSection.charAt(0)) ? "#section-" : "#appendix-";
                    if (specURL != null) {
                        this.fileWriter.print("<a href='" + specURL + anchorLink + specSection + "'>");
                    }
                    this.fileWriter.print(specSection);
                    if (specURL != null) {
                        this.fileWriter.print("</a>");
                    }
                }
                this.fileWriter.print("</td>");
                this.fileWriter.print("<td>");
                String packageName = doc.getPackage();
                if (packageName != null) {
                    this.fileWriter.print(this.o_a_v_shortened(packageName));
                }
                this.fileWriter.print("</td>");
                this.fileWriter.print("<td>");
                String className = doc.getClassName();
                if (className != null) {
                    this.fileWriter.print("<a href='" + doc.getFQClassName().replace(".", "/") + ".html'>");
                    this.fileWriter.print(this.o_a_v_cut(packageName, className));
                    this.fileWriter.print("</a>");
                }
                this.fileWriter.print("</td>");
                this.fileWriter.print("<td>");
                String member = doc.getMember();
                if (member != null) {
                    if (className != null) {
                        this.fileWriter.print("<a href='" + className.replace(".", "/") + ".html#" + doc.getMemberAnchor().replace(",", ",%20") + "'>");
                    }
                    this.fileWriter.print(this.o_a_v_cut(packageName, member));
                    if (className != null) {
                        this.fileWriter.print("</a>");
                    }
                }
                this.fileWriter.print("</td>");
                this.fileWriter.print("<td>");
                SpecCompliant.ComplianceCoverage coverage = doc.getCoverageLevel();
                if (coverage != null) {
                    this.fileWriter.print(coverage.toString().toLowerCase());
                }
                this.fileWriter.print("</td>");
                this.fileWriter.print("<td>");
                SpecCompliant.ComplianceStatus complianceStatus = doc.getComplianceStatus();
                if (complianceStatus != null) {
                    this.fileWriter.print(complianceStatus.toString().toLowerCase());
                }
                this.fileWriter.print("</td>");
                this.fileWriter.print("<td>");
                String comment = doc.getComment();
                if (comment != null) {
                    this.fileWriter.print(comment);
                }
                this.fileWriter.print("</td>");
                this.fileWriter.println("</tr>");
            }
            this.fileWriter.println("</table></body>");
        }

        private String o_a_v_shortened(String packageString) {
            if (packageString != null && packageString.contains("org.apache.vysper.")) {
                return packageString.replace("org.apache.vysper.", "o.a.v.");
            }
            return packageString;
        }

        private String o_a_v_cut(String packageString, String memberString) {
            if (memberString != null && memberString.contains(packageString + ".")) {
                return memberString.replace(packageString + ".", "");
            }
            return memberString;
        }
    }
}

