/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xml.fragment;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xml.fragment.FragmentFactory;
import org.apache.vysper.xml.fragment.XMLElementVerifier;
import org.apache.vysper.xml.fragment.XMLFragment;
import org.apache.vysper.xml.fragment.XMLSemanticError;
import org.apache.vysper.xml.fragment.XMLText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLElement
implements XMLFragment {
    private String name;
    private String namespaceURI;
    private String namespacePrefix;
    private List<Attribute> attributes;
    private Map<String, String> namespaces;
    private List<XMLFragment> innerFragments;
    protected XMLElementVerifier xmlElementVerifier;

    public XMLElement(String namespaceURI, String name, String namespacePrefix, Attribute[] attributes, XMLFragment[] innerFragments) {
        this(namespaceURI, name, namespacePrefix, attributes, innerFragments, null);
    }

    public XMLElement(String namespaceURI, String name, String namespacePrefix, Attribute[] attributes, XMLFragment[] innerFragments, Map<String, String> namespaces) {
        this(namespaceURI, name, namespacePrefix, FragmentFactory.asList(attributes), FragmentFactory.asList(innerFragments), namespaces);
    }

    public XMLElement(String namespaceURI, String name, String namespacePrefix, List<Attribute> attributes, List<XMLFragment> innerFragments) {
        this(namespaceURI, name, namespacePrefix, attributes, innerFragments, null);
    }

    public XMLElement(String namespaceURI, String name, String namespacePrefix, List<Attribute> attributes, List<XMLFragment> innerFragments, Map<String, String> namespaces) {
        this.namespaceURI = namespaceURI == null ? "" : namespaceURI;
        this.namespacePrefix = namespacePrefix == null ? "" : namespacePrefix;
        this.name = name;
        this.attributes = attributes == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(attributes);
        this.namespaces = namespaces == null ? Collections.EMPTY_MAP : Collections.unmodifiableMap(namespaces);
        List<XMLFragment> list = this.innerFragments = innerFragments == null ? Collections.EMPTY_LIST : Collections.unmodifiableList(innerFragments);
        if (name == null) {
            throw new IllegalArgumentException("XMLElement name cannot be null");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNamespacePrefix() {
        return this.namespacePrefix;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttribute(String name) {
        return this.getAttribute("", name);
    }

    public Attribute getAttribute(String namespaceUri, String name) {
        for (Attribute attribute : this.attributes) {
            if (!attribute.getName().equals(name) || !attribute.getNamespaceUri().equals(namespaceUri)) continue;
            return attribute;
        }
        return null;
    }

    public String getAttributeValue(String name) {
        return this.getAttributeValue("", name);
    }

    public String getAttributeValue(String namespaceUri, String name) {
        Attribute attribute = this.getAttribute(namespaceUri, name);
        if (attribute == null) {
            return null;
        }
        return attribute.getValue();
    }

    public Map<String, String> getDeclaredNamespaces() {
        return this.namespaces;
    }

    public String getXMLLang() {
        return this.getAttributeValue("http://www.w3.org/XML/1998/namespace", "lang");
    }

    public List<XMLFragment> getInnerFragments() {
        return Collections.unmodifiableList(this.innerFragments);
    }

    public XMLElement getFirstInnerElement() {
        if (this.innerFragments == null || this.innerFragments.size() < 1) {
            return null;
        }
        for (XMLFragment xmlFragment : this.innerFragments) {
            if (!(xmlFragment instanceof XMLElement)) continue;
            return (XMLElement)xmlFragment;
        }
        return null;
    }

    public List<XMLElement> getInnerElements() {
        if (this.innerFragments == null || this.innerFragments.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<XMLElement> innerElements = new ArrayList<XMLElement>();
        for (XMLFragment xmlFragment : this.innerFragments) {
            if (!(xmlFragment instanceof XMLElement)) continue;
            innerElements.add((XMLElement)xmlFragment);
        }
        return innerElements;
    }

    public List<XMLText> getInnerTexts() {
        if (this.innerFragments == null || this.innerFragments.size() < 1) {
            return Collections.emptyList();
        }
        ArrayList<XMLText> innerTexts = new ArrayList<XMLText>();
        for (XMLFragment xmlFragment : this.innerFragments) {
            if (!(xmlFragment instanceof XMLText)) continue;
            innerTexts.add((XMLText)xmlFragment);
        }
        return innerTexts;
    }

    public XMLText getFirstInnerText() {
        if (this.innerFragments == null || this.innerFragments.size() < 1) {
            return null;
        }
        for (XMLFragment xmlFragment : this.innerFragments) {
            if (!(xmlFragment instanceof XMLText)) continue;
            return (XMLText)xmlFragment;
        }
        return null;
    }

    public XMLText getSingleInnerText() throws XMLSemanticError {
        List<XMLText> innerTexts = this.getInnerTexts();
        if (innerTexts == null || innerTexts.isEmpty()) {
            return null;
        }
        if (innerTexts.size() > 1) {
            throw new XMLSemanticError("element has more than one inner text fragment");
        }
        return innerTexts.get(0);
    }

    public XMLText getInnerText() {
        boolean hadText = false;
        StringBuffer sb = new StringBuffer();
        for (XMLText text : this.getInnerTexts()) {
            sb.append(text.getText());
            hadText = true;
        }
        if (hadText) {
            return new XMLText(sb.toString());
        }
        return null;
    }

    public List<XMLElement> getInnerElementsNamed(String name) {
        return this.getInnerElementsNamed(name, null);
    }

    public List<XMLElement> getInnerElementsNamed(String name, String namespaceUri) {
        if (name == null) {
            return null;
        }
        List<XMLElement> innerElements = this.getInnerElements();
        if (innerElements == null) {
            return null;
        }
        if (innerElements.size() == 0) {
            return innerElements;
        }
        Iterator<XMLElement> elementIterator = innerElements.iterator();
        while (elementIterator.hasNext()) {
            XMLElement xmlElement = elementIterator.next();
            if (name.equals(xmlElement.getName()) && (namespaceUri == null || namespaceUri.equals(xmlElement.getNamespaceURI()))) continue;
            elementIterator.remove();
        }
        return innerElements;
    }

    public XMLElement getSingleInnerElementsNamed(String name) throws XMLSemanticError {
        return this.getSingleInnerElementsNamed(name, null);
    }

    public XMLElement getSingleInnerElementsNamed(String name, String namespaceUri) throws XMLSemanticError {
        List<XMLElement> innerElements = this.getInnerElementsNamed(name, namespaceUri);
        if (innerElements == null) {
            return null;
        }
        if (innerElements.isEmpty()) {
            return null;
        }
        if (innerElements.size() > 1) {
            throw new XMLSemanticError("element has more than one inner element named: " + name);
        }
        return innerElements.get(0);
    }

    public Map<String, XMLElement> getInnerElementsByXMLLangNamed(String name) throws XMLSemanticError {
        if (name == null) {
            return null;
        }
        List<XMLElement> innerElements = this.getInnerElementsNamed(name);
        HashMap<String, XMLElement> langMap = new HashMap<String, XMLElement>();
        for (XMLElement xmlElement : innerElements) {
            String xmlLang = xmlElement.getXMLLang();
            if (langMap.containsKey(xmlLang)) {
                throw new XMLSemanticError("two inner elements '" + name + "' with same language attribute " + xmlLang);
            }
            langMap.put(xmlLang, xmlElement);
        }
        return langMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof XMLElement)) {
            return false;
        }
        XMLElement that = (XMLElement)o;
        if (this.attributes != null && that.attributes != null) {
            if (this.attributes.size() != that.attributes.size()) {
                return false;
            }
            for (Attribute attribute : this.attributes) {
                boolean found = false;
                for (Attribute thatAttribute : that.attributes) {
                    if (!thatAttribute.equals(attribute)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else if (this.attributes != null || that.attributes != null) {
            return false;
        }
        if (this.innerFragments != null ? !((Object)this.innerFragments).equals(that.innerFragments) : that.innerFragments != null) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        return !(this.namespacePrefix != null ? !this.namespacePrefix.equals(that.namespacePrefix) : that.namespacePrefix != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 29 * result + (this.namespacePrefix != null ? this.namespacePrefix.hashCode() : 0);
        result = 29 * result + (this.attributes != null ? ((Object)this.attributes).hashCode() : 0);
        result = 29 * result + (this.innerFragments != null ? ((Object)this.innerFragments).hashCode() : 0);
        return result;
    }

    public XMLElementVerifier getVerifier() {
        if (this.xmlElementVerifier == null) {
            this.xmlElementVerifier = new XMLElementVerifier(this);
        }
        return this.xmlElementVerifier;
    }
}

