/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.extension.xep0124;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.vysper.xmpp.extension.xep0124.BoshBackedSessionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InactivityChecker
extends Thread {
    private static final Logger LOGGER = LoggerFactory.getLogger(InactivityChecker.class);
    private final int CHECKING_INTERVAL = 1000;
    private final SortedMap<Long, Object> sessions;

    public InactivityChecker() {
        this.setName(InactivityChecker.class.getSimpleName());
        this.setDaemon(true);
        this.sessions = new TreeMap<Long, Object>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateExpireTime(BoshBackedSessionContext session, Long oldExpireTime, Long newExpireTime) {
        boolean ret = session.isWatchedByInactivityChecker();
        if (oldExpireTime == null && newExpireTime == null || newExpireTime != null && newExpireTime.equals(oldExpireTime)) {
            return ret;
        }
        SortedMap<Long, Object> sortedMap = this.sessions;
        synchronized (sortedMap) {
            if (oldExpireTime != null) {
                Object oldValue = this.sessions.get(oldExpireTime);
                if (oldValue instanceof Set) {
                    ((Set)oldValue).remove((Object)session);
                    if (((Set)oldValue).isEmpty()) {
                        this.sessions.remove(oldExpireTime);
                    }
                } else if (oldValue != null) {
                    this.sessions.remove(oldExpireTime);
                }
                ret = false;
            }
            if (newExpireTime != null) {
                Object value = this.sessions.get(newExpireTime);
                if (value instanceof Set) {
                    ((Set)value).add(session);
                } else if (value == null) {
                    this.sessions.put(newExpireTime, (Object)session);
                } else {
                    HashSet<BoshBackedSessionContext> set = new HashSet<BoshBackedSessionContext>();
                    this.sessions.put(newExpireTime, set);
                    set.add((BoshBackedSessionContext)((Object)value));
                    set.add(session);
                }
                ret = true;
            }
        }
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (!Thread.interrupted()) {
            InactivityChecker inactivityChecker = this;
            synchronized (inactivityChecker) {
                try {
                    this.wait(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
            }
            long time = System.currentTimeMillis();
            ArrayList<BoshBackedSessionContext> inactiveSessions = null;
            SortedMap<Long, Object> sortedMap = this.sessions;
            synchronized (sortedMap) {
                Long expireTime;
                Long l = expireTime = this.sessions.isEmpty() ? null : this.sessions.firstKey();
                while (expireTime != null && time >= expireTime) {
                    Object value;
                    if (inactiveSessions == null) {
                        inactiveSessions = new ArrayList<BoshBackedSessionContext>();
                    }
                    if ((value = this.sessions.get(expireTime)) instanceof Set) {
                        inactiveSessions.addAll((Set)value);
                    } else if (value != null) {
                        inactiveSessions.add((BoshBackedSessionContext)((Object)value));
                    }
                    this.sessions.remove(expireTime);
                    expireTime = this.sessions.isEmpty() ? null : this.sessions.firstKey();
                }
            }
            if (inactiveSessions == null) continue;
            for (BoshBackedSessionContext session : inactiveSessions) {
                LOGGER.error("BOSH session {} reached maximum inactivity period, closing session...", (Object)session);
                session.close();
            }
        }
    }
}

