/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.mina;

import java.util.concurrent.TimeUnit;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.CloseFuture;
import org.apache.mina.core.future.IoFuture;
import org.apache.mina.core.future.IoFutureListener;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.filter.ssl.SslFilter;
import org.apache.vysper.mina.codec.StanzaWriteInfo;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.server.AbstractSessionContext;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionState;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.writer.StanzaWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MinaBackedSessionContext
extends AbstractSessionContext
implements StanzaWriter,
IoFutureListener {
    final Logger logger = LoggerFactory.getLogger(MinaBackedSessionContext.class);
    private IoSession minaSession;
    private boolean openingStanzaWritten = false;
    private boolean switchToTLS = false;
    private boolean clientTLS = false;
    protected CloseFuture closeFuture;

    public MinaBackedSessionContext(ServerRuntimeContext serverRuntimeContext, SessionStateHolder sessionStateHolder, IoSession minaSession) {
        super(serverRuntimeContext, sessionStateHolder);
        this.minaSession = minaSession;
        this.closeFuture = minaSession.getCloseFuture();
        this.closeFuture.addListener((IoFutureListener)this);
        sessionStateHolder.setState(SessionState.INITIATED);
    }

    public StanzaWriter getResponseWriter() {
        return this;
    }

    public void switchToTLS(boolean delayed, boolean clientTls) {
        this.clientTLS = clientTls;
        if (delayed) {
            this.switchToTLS = true;
        } else {
            this.addSslFilter();
        }
    }

    public void setIsReopeningXMLStream() {
        this.openingStanzaWritten = false;
    }

    private void addSslFilter() {
        this.minaSession.suspendRead();
        this.minaSession.suspendWrite();
        SslFilter filter = new SslFilter(this.getServerRuntimeContext().getSslContext());
        filter.setUseClientMode(this.clientTLS);
        this.minaSession.getFilterChain().addFirst("sslFilter", (IoFilter)filter);
        if (!this.clientTLS) {
            this.minaSession.setAttribute((Object)SslFilter.DISABLE_ENCRYPTION_ONCE, (Object)Boolean.TRUE);
        }
        this.minaSession.setAttribute((Object)SslFilter.USE_NOTIFICATION, (Object)Boolean.TRUE);
        this.minaSession.resumeWrite();
        this.minaSession.resumeRead();
    }

    public void write(Stanza stanza) {
        if (this.switchToTLS) {
            this.addSslFilter();
            this.switchToTLS = false;
        }
        this.minaSession.write((Object)new StanzaWriteInfo(stanza, !this.openingStanzaWritten));
        this.openingStanzaWritten = true;
    }

    public void close() {
        this.logger.info("session will be closed now");
        this.closeFuture.setClosed();
        try {
            if (!this.minaSession.close(false).await(5000L, TimeUnit.MILLISECONDS)) {
                this.minaSession.close(true);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.logger.info("session closed");
    }

    public void operationComplete(IoFuture ioFuture) {
        this.logger.info("close future called");
    }
}

