/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.addressing.stringprep;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.vysper.xmpp.addressing.stringprep.StringPrepConstants;
import org.apache.vysper.xmpp.addressing.stringprep.StringPrepViolationException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringPrep {
    private Map<String, String> mapping = this.buildMapping();
    private Set<String> prohibited = this.buildProhibitedSet();

    public String prepareString(String str) throws StringPrepViolationException {
        String codePoint;
        int i;
        for (i = 0; i < str.length(); ++i) {
            codePoint = this.codePointAt(str, i);
            if (!this.mapping.containsKey(codePoint)) continue;
            str = str.replace(codePoint, this.mapping.get(codePoint));
        }
        for (i = 0; i < str.length(); ++i) {
            codePoint = this.codePointAt(str, i);
            if (!this.prohibited.contains(codePoint)) continue;
            throw new StringPrepViolationException(String.format("character '%s' prohibited!", codePoint));
        }
        boolean containsRAndAlCat = false;
        boolean containsLCat = false;
        for (int i2 = 0; i2 < str.length() && this.NAND(containsRAndAlCat, containsLCat); ++i2) {
            String codePoint2 = this.codePointAt(str, i2);
            containsRAndAlCat |= StringPrepConstants.D_1_CharactersWithBiDiPropertiesRorAl.contains(codePoint2);
            containsLCat |= StringPrepConstants.D_2_CharactersWithBiDiPropertyL.contains(codePoint2);
        }
        if (containsRAndAlCat && containsLCat) {
            throw new StringPrepViolationException("invalid bidi sequence");
        }
        if (!(!containsRAndAlCat || StringPrepConstants.D_1_CharactersWithBiDiPropertiesRorAl.contains(this.codePointAt(str, 0)) && StringPrepConstants.D_1_CharactersWithBiDiPropertiesRorAl.contains(this.codePointAt(str, str.length() - 1)))) {
            throw new StringPrepViolationException("invalid bidi sequence");
        }
        return str;
    }

    protected Map<String, String> buildMapping() {
        HashMap<String, String> mapping = new HashMap<String, String>();
        mapping.putAll(StringPrepConstants.B_1_CommonlyMappedtoNothing);
        mapping.putAll(StringPrepConstants.B_2_MappingForCaseFoldingUsedWithKFC);
        mapping.putAll(StringPrepConstants.B_3_MappingForCaseFoldingWithNoNormalization);
        return mapping;
    }

    protected Set<String> buildProhibitedSet() {
        HashSet<String> prohibited = new HashSet<String>();
        prohibited.addAll(StringPrepConstants.C_1_1_AsciiSpaceCharacters);
        prohibited.addAll(StringPrepConstants.C_1_2_NonAsciiSpaceCharacters);
        prohibited.addAll(StringPrepConstants.C_2_1_AsciiControlCharacters);
        prohibited.addAll(StringPrepConstants.C_2_2_NonAsciiControlCharacters);
        prohibited.addAll(StringPrepConstants.C_3_PrivateUse);
        prohibited.addAll(StringPrepConstants.C_4_NonCharacterCodePoints);
        prohibited.addAll(StringPrepConstants.C_5_SurrogateCodes);
        prohibited.addAll(StringPrepConstants.C_6_InappropriateForPlainText);
        prohibited.addAll(StringPrepConstants.C_7_InappropriateForCanonicalRepresentation);
        prohibited.addAll(StringPrepConstants.C_8_ChangeDisplayPropertiesOrAreDeprecated);
        prohibited.addAll(StringPrepConstants.C_9_TaggingCharacters);
        return prohibited;
    }

    private String codePointAt(String node, int i) {
        int c = node.codePointAt(i);
        return new String(Character.toChars(c));
    }

    private boolean NAND(boolean a, boolean b) {
        return !a && !b || a ^ b;
    }
}

