/*
 * Decompiled with CFR 0.152.
 */
package org.apache.vysper.xmpp.modules.core.base.handler;

import org.apache.vysper.xml.fragment.Attribute;
import org.apache.vysper.xmpp.addressing.Entity;
import org.apache.vysper.xmpp.addressing.EntityImpl;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainer;
import org.apache.vysper.xmpp.protocol.ResponseStanzaContainerImpl;
import org.apache.vysper.xmpp.protocol.SessionStateHolder;
import org.apache.vysper.xmpp.protocol.StanzaHandler;
import org.apache.vysper.xmpp.protocol.StreamErrorCondition;
import org.apache.vysper.xmpp.server.ServerRuntimeContext;
import org.apache.vysper.xmpp.server.SessionContext;
import org.apache.vysper.xmpp.server.response.ServerErrorResponses;
import org.apache.vysper.xmpp.stanza.IQStanzaType;
import org.apache.vysper.xmpp.stanza.Stanza;
import org.apache.vysper.xmpp.stanza.XMPPCoreStanza;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class XMPPCoreStanzaHandler
implements StanzaHandler {
    static final Logger logger = LoggerFactory.getLogger(XMPPCoreStanzaHandler.class);

    public boolean verify(Stanza stanza) {
        boolean typeVerified = this.verifyType(stanza);
        boolean namespaceVerified = this.verifyNamespace(stanza);
        return typeVerified && namespaceVerified;
    }

    public boolean isSessionRequired() {
        return true;
    }

    protected abstract boolean verifyType(Stanza var1);

    protected boolean verifyNamespace(Stanza stanza) {
        return true;
    }

    public ResponseStanzaContainer execute(Stanza anyStanza, ServerRuntimeContext serverRuntimeContext, boolean isOutboundStanza, SessionContext sessionContext, SessionStateHolder sessionStateHolder) {
        Stanza responseStanza;
        XMPPCoreStanza stanza = XMPPCoreStanza.getWrapper(anyStanza);
        if (stanza == null) {
            throw new IllegalArgumentException("can only handle core XMPP stanzas (iq, message, presence)");
        }
        Attribute typeAttribute = stanza.getAttribute("type");
        XMPPCoreStanza xmppCoreStanza = XMPPCoreStanza.getWrapper(stanza);
        if (xmppCoreStanza != null && typeAttribute != null) {
            String errorDescription = null;
            String type = typeAttribute.getValue();
            if (IQStanzaType.ERROR.value().equals(type)) {
                if (!stanza.getVerifier().subElementPresent("error")) {
                    errorDescription = "stanza of type error must include an 'error' child";
                }
            } else if (stanza.getVerifier().subElementPresent("error")) {
                errorDescription = "stanza which is not of type error must not include an 'error' child";
            }
        }
        Entity to = stanza.getTo();
        if (sessionContext != null && sessionContext.isServerToServer() && to == null) {
            return new ResponseStanzaContainerImpl(ServerErrorResponses.getStreamError(StreamErrorCondition.IMPROPER_ADDRESSING, stanza.getXMLLang(), "missing to attribute", null));
        }
        if (to != null) {
            // empty if block
        }
        if ((responseStanza = this.executeCore(stanza, serverRuntimeContext, isOutboundStanza, sessionContext)) != null) {
            return new ResponseStanzaContainerImpl(responseStanza);
        }
        return null;
    }

    protected abstract Stanza executeCore(XMPPCoreStanza var1, ServerRuntimeContext var2, boolean var3, SessionContext var4);

    public static Entity extractSenderJID(XMPPCoreStanza stanza, SessionContext sessionContext) {
        Entity from = stanza.getFrom();
        if (from == null) {
            from = new EntityImpl(sessionContext.getInitiatingEntity(), sessionContext.getServerRuntimeContext().getResourceRegistry().getUniqueResourceForSession(sessionContext));
        }
        return from;
    }

    public static Entity extractUniqueSenderJID(XMPPCoreStanza stanza, SessionContext sessionContext) {
        Entity from = stanza.getFrom();
        if (from != null) {
            return from;
        }
        Entity initiatingEntity = sessionContext.getInitiatingEntity();
        if (initiatingEntity == null) {
            throw new RuntimeException("no 'from' attribute, and initiating entity not set");
        }
        String resourceId = sessionContext.getServerRuntimeContext().getResourceRegistry().getUniqueResourceForSession(sessionContext);
        if (resourceId == null) {
            logger.warn("no 'from' attribute, and cannot uniquely determine sending resource for initiating entity {} in session {}", (Object)initiatingEntity.getFullQualifiedName(), (Object)sessionContext.getSessionId());
            return null;
        }
        return new EntityImpl(initiatingEntity, resourceId);
    }
}

